/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.custom.editor.editors;

import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.modisco.infra.browser.custom.MetamodelView;
import org.eclipse.modisco.infra.browser.custom.editor.Activator;
import org.eclipse.modisco.infra.browser.custom.editor.editors.CustomizationEditor;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.ui.IEditorPart;

public class WorkspaceChangeListener
implements IResourceChangeListener {
    private final CustomizationEditor customizationEditor;
    private boolean editorSaved = false;

    public WorkspaceChangeListener(CustomizationEditor customizationEditor) {
        this.customizationEditor = customizationEditor;
    }

    public void setEditorSaved(boolean editorSaved) {
        this.editorSaved = editorSaved;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta eventDelta = event.getDelta();
        try {
            class ResourceDeltaVisitor
            implements IResourceDeltaVisitor {
                private boolean changed = false;
                private boolean removed = false;

                ResourceDeltaVisitor() {
                }

                public boolean isChanged() {
                    return this.changed;
                }

                public boolean isRemoved() {
                    return this.removed;
                }

                public boolean visit(IResourceDelta deltaResource) {
                    Resource eResource;
                    MetamodelView metamodelView;
                    if (deltaResource.getResource().getType() == 1 && (deltaResource.getKind() == 2 || deltaResource.getKind() == 4 && deltaResource.getFlags() != 131072) && (metamodelView = WorkspaceChangeListener.this.customizationEditor.getMetamodelView()) != null && (eResource = metamodelView.eResource()) != null) {
                        IPath filePath = null;
                        if (eResource.getURI().isPlatformResource()) {
                            filePath = new Path(eResource.getURI().path()).removeFirstSegments(1).makeAbsolute();
                        } else if (eResource.getURI().isFile()) {
                            IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                            Path path = new Path(eResource.getURI().toFileString());
                            int nSegments = path.matchingFirstSegments(workspaceLocation);
                            if (nSegments == workspaceLocation.segmentCount()) {
                                filePath = path.removeFirstSegments(nSegments).setDevice(null).makeAbsolute();
                            } else {
                                MoDiscoLogger.logError((String)"Not a workspace file", (Plugin)Activator.getDefault());
                            }
                        } else {
                            MoDiscoLogger.logError((String)"Unhandled resource URI kind", (Plugin)Activator.getDefault());
                        }
                        if (filePath != null && filePath.equals((Object)deltaResource.getFullPath())) {
                            if (deltaResource.getKind() == 2) {
                                this.removed = true;
                            } else if (WorkspaceChangeListener.this.editorSaved) {
                                WorkspaceChangeListener.this.editorSaved = false;
                            } else {
                                this.changed = true;
                            }
                        }
                    }
                    return true;
                }
            }
            ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
            eventDelta.accept((IResourceDeltaVisitor)visitor);
            if (visitor.isRemoved()) {
                this.handleRemoved();
            } else if (visitor.isChanged()) {
                this.handleChanged();
            }
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    public void handleChanged() {
        final CustomizationEditor editor = this.customizationEditor;
        editor.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                editor.setResourceChanged(true);
                if (editor.getSite().getPage().getActiveEditor() == editor) {
                    editor.handleActivate();
                }
            }
        });
    }

    public void handleRemoved() {
        final CustomizationEditor editor = this.customizationEditor;
        editor.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                editor.setResourceDeleted(true);
                if (!editor.isDirty()) {
                    editor.getSite().getPage().closeEditor((IEditorPart)editor, false);
                }
            }
        });
    }
}

