/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.conversion;

import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineJoin;
import org.eclipse.gef.dot.internal.language.arrowtype.AbstractArrowShape;
import org.eclipse.gef.dot.internal.language.arrowtype.ArrowShape;
import org.eclipse.gef.dot.internal.language.arrowtype.ArrowType;
import org.eclipse.gef.dot.internal.language.arrowtype.DeprecatedArrowShape;
import org.eclipse.gef.dot.internal.language.arrowtype.PrimitiveShape;
import org.eclipse.gef.fx.utils.NodeUtils;

class DotArrowShapeDecorations {
    private static double size = 10.0;

    DotArrowShapeDecorations() {
    }

    static Node getDefault(double arrowSize, boolean isGraphDirected, Double penwidth, String color, String fillColor) {
        Normal shape = isGraphDirected ? new Normal(arrowSize) : null;
        DotArrowShapeDecorations.setStroke((Shape)shape, penwidth, color, fillColor);
        return shape;
    }

    static Node get(ArrowType arrowType, double arrowSize, Double penwidth, String color, String fillColor) {
        double offset = 0.0;
        Group group = new Group();
        for (AbstractArrowShape arrowShape : arrowType.getArrowShapes()) {
            Object currentShape = DotArrowShapeDecorations.get(arrowShape, arrowSize, penwidth, color, fillColor);
            if (currentShape == null) {
                currentShape = new Box(arrowSize);
                currentShape.setFill((Paint)Color.TRANSPARENT);
                currentShape.setTranslateX(offset);
            } else if (currentShape instanceof Circle) {
                currentShape.setTranslateX(offset + currentShape.getLayoutBounds().getWidth() / 2.0);
            } else {
                currentShape.setTranslateX(offset);
            }
            offset += NodeUtils.getShapeBounds((Node)currentShape).getWidth() - currentShape.getStrokeWidth();
            group.getChildren().add(currentShape);
        }
        return group;
    }

    private static Shape get(AbstractArrowShape abstractArrowShape, double arrowSize, Double penwidth, String color, String fillColor) {
        Object shape = null;
        if (abstractArrowShape instanceof DeprecatedArrowShape) {
            switch (((DeprecatedArrowShape)abstractArrowShape).getShape()) {
                case EDIAMOND: {
                    shape = new Diamond(arrowSize);
                    DotArrowShapeDecorations.setOpen(shape, penwidth, color);
                    break;
                }
                case OPEN: {
                    shape = new Vee(arrowSize);
                    DotArrowShapeDecorations.setStroke(shape, penwidth, color, fillColor);
                    break;
                }
                case HALFOPEN: {
                    shape = new Vee(arrowSize);
                    DotArrowShapeDecorations.setSide(shape, "l");
                    DotArrowShapeDecorations.setStroke(shape, penwidth, color, fillColor);
                    break;
                }
                case EMPTY: {
                    shape = new Normal(arrowSize);
                    DotArrowShapeDecorations.setOpen(shape, penwidth, color);
                    break;
                }
                case INVEMPTY: {
                    shape = new Inv(arrowSize);
                    DotArrowShapeDecorations.setOpen(shape, penwidth, color);
                    break;
                }
            }
        } else {
            ArrowShape arrowShape = (ArrowShape)abstractArrowShape;
            shape = DotArrowShapeDecorations.getPrimitiveShape(arrowShape.getShape(), arrowSize);
            if (arrowShape.isOpen()) {
                DotArrowShapeDecorations.setOpen(shape, penwidth, color);
            } else {
                DotArrowShapeDecorations.setStroke(shape, penwidth, color, fillColor);
            }
            if (arrowShape.getSide() != null) {
                DotArrowShapeDecorations.setSide(shape, arrowShape.getSide());
            }
        }
        return shape;
    }

    private static void setStroke(Shape shape, Double penwidth, String color, String fillColor) {
        if (shape != null) {
            String style = "";
            if (color == null) {
                color = "#000000";
            }
            style = String.valueOf(style) + "-fx-stroke: " + color + ";";
            if (fillColor == null) {
                fillColor = color;
            }
            style = String.valueOf(style) + "-fx-fill: " + fillColor + ";";
            if (penwidth != null) {
                style = String.valueOf(style) + "-fx-stroke-width: " + penwidth + ";";
            }
            shape.setStyle(style);
            shape.setStrokeLineJoin(StrokeLineJoin.ROUND);
        }
    }

    private static void setOpen(Shape shape, Double penwidth, String color) {
        DotArrowShapeDecorations.setStroke(shape, penwidth, color, "#ffffff");
    }

    private static void setSide(Shape shape, String side) {
        if (shape instanceof Polygon) {
            DotArrowShapeDecorations.setSide((Polygon)shape, side);
        } else if (shape instanceof Arc) {
            DotArrowShapeDecorations.setSide((Arc)shape, side);
        }
    }

    private static void setSide(Polygon polygon, String side) {
        ObservableList points = polygon.getPoints();
        int i = 1;
        while (i < points.size()) {
            double yCoordinate = (Double)points.get(i);
            if (yCoordinate < 0.0 && side.equals("l") || yCoordinate > 0.0 && side.equals("r")) {
                points.remove(i);
                points.add(i, (Object)0.0);
            }
            i += 2;
        }
    }

    private static void setSide(Arc arc, String side) {
        if (arc instanceof Curve && side.equals("l")) {
            arc.setStartAngle(180.0);
            arc.setLength(90.0);
        }
        if (arc instanceof ICurve && side.equals("l")) {
            arc.setStartAngle(0.0);
            arc.setLength(-90.0);
        }
        if (arc instanceof Curve && side.equals("r")) {
            arc.setLength(90.0);
        }
        if (arc instanceof ICurve && side.equals("r")) {
            arc.setLength(-90.0);
        }
    }

    private static Shape getPrimitiveShape(PrimitiveShape primitiveShape, double arrowSize) {
        switch (primitiveShape) {
            case BOX: {
                return new Box(arrowSize);
            }
            case CROW: {
                return new Crow(arrowSize);
            }
            case CURVE: {
                return new Curve(arrowSize);
            }
            case ICURVE: {
                return new ICurve(arrowSize);
            }
            case DIAMOND: {
                return new Diamond(arrowSize);
            }
            case DOT: {
                return new Dot(arrowSize);
            }
            case INV: {
                return new Inv(arrowSize);
            }
            case NONE: {
                return null;
            }
            case NORMAL: {
                return new Normal(arrowSize);
            }
            case TEE: {
                return new Tee(arrowSize);
            }
            case VEE: {
                return new Vee(arrowSize);
            }
        }
        return null;
    }

    private static class Box
    extends Polygon
    implements IPrimitiveShape {
        private Box(double arrowSize) {
            super(new double[]{0.0, arrowSize * size / 2.0, 0.0, -arrowSize * size / 2.0, arrowSize * size, -arrowSize * size / 2.0, arrowSize * size, arrowSize * size / 2.0});
        }

        @Override
        public double getOffset() {
            return -NodeUtils.getShapeBounds((Node)this).getX() - this.getStrokeWidth() / 2.0;
        }
    }

    private static class Crow
    extends Polygon
    implements IPrimitiveShape {
        private Crow(double arrowSize) {
            super(new double[]{arrowSize * size / 2.0, 0.0, 0.0, -arrowSize * size / 2.0, arrowSize * size, 0.0, 0.0, arrowSize * size / 2.0});
        }

        @Override
        public double getOffset() {
            return NodeUtils.getShapeBounds((Node)this).getX();
        }
    }

    private static class Curve
    extends Arc
    implements IPrimitiveShape {
        private Curve(double arrowSize) {
            super(arrowSize * size / 2.0, 0.0, arrowSize * size / 2.0, arrowSize * size / 2.0, 90.0, 180.0);
            this.setStyle("-fx-stroke: black;-fx-fill: transparent;");
        }

        @Override
        public double getOffset() {
            return 0.0;
        }
    }

    private static class Diamond
    extends Polygon
    implements IPrimitiveShape {
        private Diamond(double arrowSize) {
            super(new double[]{0.0, 0.0, arrowSize * size / 2.0, -arrowSize * size / 3.0, arrowSize * size, 0.0, arrowSize * size / 2.0, arrowSize * size / 3.0});
        }

        @Override
        public double getOffset() {
            return NodeUtils.getShapeBounds((Node)this).getX();
        }
    }

    private static class Dot
    extends Circle
    implements IPrimitiveShape {
        private Dot(double arrowSize) {
            super(0.0, 0.0, arrowSize * size / 2.0);
        }

        @Override
        public double getOffset() {
            return -this.getStrokeWidth() / 2.0;
        }
    }

    private static class ICurve
    extends Arc
    implements IPrimitiveShape {
        private ICurve(double arrowSize) {
            super(0.0, 0.0, arrowSize * size / 2.0, arrowSize * size / 2.0, 90.0, -180.0);
            this.setStyle("-fx-stroke: black;-fx-fill: transparent;");
        }

        @Override
        public double getOffset() {
            return NodeUtils.getShapeBounds((Node)this).getWidth();
        }
    }

    public static interface IPrimitiveShape {
        public double getOffset();
    }

    private static class Inv
    extends Polygon
    implements IPrimitiveShape {
        private Inv(double arrowSize) {
            super(new double[]{0.0, arrowSize * size / 3.0, arrowSize * size, 0.0, 0.0, -arrowSize * size / 3.0});
        }

        @Override
        public double getOffset() {
            return 0.0;
        }
    }

    private static class Normal
    extends Polygon
    implements IPrimitiveShape {
        private Normal(double arrowSize) {
            super(new double[]{0.0, 0.0, arrowSize * size, -arrowSize * size / 3.0, arrowSize * size, arrowSize * size / 3.0});
        }

        @Override
        public double getOffset() {
            return 0.0;
        }
    }

    private static class Tee
    extends Polygon
    implements IPrimitiveShape {
        private Tee(double arrowSize) {
            super(new double[]{0.0, -arrowSize * size / 2.0, arrowSize * size / 4.0, -arrowSize * size / 2.0, arrowSize * size / 4.0, arrowSize * size / 2.0, 0.0, arrowSize * size / 2.0});
        }

        @Override
        public double getOffset() {
            return -NodeUtils.getShapeBounds((Node)this).getX();
        }
    }

    private static class Vee
    extends Polygon
    implements IPrimitiveShape {
        private Vee(double arrowSize) {
            super(new double[]{0.0, 0.0, arrowSize * size, -arrowSize * size / 2.0, 2.0 * arrowSize * size / 3.0, 0.0, arrowSize * size, arrowSize * size / 2.0});
        }

        @Override
        public double getOffset() {
            return 0.0;
        }
    }
}

