/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.resourcesstatus;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.google.common.primitives.Ints;
import java.text.FieldPosition;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.model.OsStrings;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.common.core.format.DecimalUnitFormat;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.registry.LinuxStyle;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.resourcesstatus.Messages;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.resourcesstatus.ResourcesEntryModel;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.resourcesstatus.ResourcesEntryModelWeighted;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.resourcesstatus.SoftIrqLabelProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.AnnotationCategoriesModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.AnnotationModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.EventAnnotationProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.IOutputAnnotationProvider;
import org.eclipse.tracecompass.internal.tmf.core.analysis.callsite.CallsiteAnalysis;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.internal.tmf.core.model.timegraph.AbstractTimeGraphDataProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.TmfStrings;
import org.eclipse.tracecompass.tmf.core.analysis.callsite.ITmfCallsiteResolver;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.X11ColorUtils;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfCallsite;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.IOutputStyleProvider;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.OutputStyleModel;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.presentation.RotatingPaletteProvider;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class ResourcesStatusDataProvider
extends AbstractTimeGraphDataProvider<KernelAnalysisModule, ResourcesEntryModel>
implements IOutputAnnotationProvider,
IOutputStyleProvider {
    public static final @NonNull String ID = "org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus.ResourcesStatusDataProvider";
    private static final String WILDCARD = "*";
    private static final @NonNull String SEPARATOR = "";
    private static final @NonNull Format FREQUENCY_FORMATTER = new DecimalUnitFormat(){
        private static final long serialVersionUID = 2101980732073309988L;

        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return super.format(obj, toAppendTo, pos).append("Hz");
        }
    };
    private static final long FREQUENCY_MULTIPLIER = 1000L;
    private static final @NonNull Map<@NonNull String, @NonNull OutputElementStyle> STATE_MAP;
    private static final @NonNull Map<@NonNull String, @NonNull OutputElementStyle> STYLE_MAP;
    private static final int NUM_COLORS = 25;
    private static final float BRIGHTNESS = 0.8f;
    private static final float SATURATION = 0.8f;
    private static final int COLOR_DIFFERENCIATION_FACTOR = 14;
    private static final List<@NonNull RGBAColor> PALETTE;
    private static final String BASE_FREQUENCY_STYLE = "frequency";
    private static final String BASE_THREAD_STYLE = "thread";
    private final HashMap<Integer, ResourcesEntryModel.Type> fEntryModelTypes = new HashMap();
    private final Map<Integer, Long> fSeparatorIds = new HashMap<Integer, Long>();
    private static final @NonNull List<ResourcesEntryModel.Type> CPU_GROUP_ORDER;
    private static final Comparator<ResourcesEntryModel> COMPARATOR;
    private final BiMap<Long, Integer> fTwinIdsToQuark = HashBiMap.create();
    private static final Comparator<ITmfStateInterval> CACHE_COMPARATOR;
    private final TreeMultimap<Integer, ITmfStateInterval> fExecNamesCache = TreeMultimap.create(Integer::compare, CACHE_COMPARATOR);
    private final IOutputAnnotationProvider fEventAnnotatonProvider;
    private @NonNull Map<@NonNull Integer, @NonNull Long> fFreqMap = new HashMap<Integer, Long>();

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    static {
        STYLE_MAP = Collections.synchronizedMap(new HashMap());
        PALETTE = new RotatingPaletteProvider.Builder().setNbColors(25).setBrightness(0.8f).setSaturation(0.8f).build().get();
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull @NonNull ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)LinuxStyle.IDLE.getLabel(), (Object)new OutputElementStyle(null, ResourcesStatusDataProvider.toGroup(LinuxStyle.IDLE.toMap(), Messages.ResourcesStatusDataProvider_styleGroupCpu, null)));
        builder.put((Object)LinuxStyle.USERMODE.getLabel(), (Object)new OutputElementStyle(null, ResourcesStatusDataProvider.toGroup(LinuxStyle.USERMODE.toMap(), Messages.ResourcesStatusDataProvider_styleGroupCpu, null)));
        builder.put((Object)LinuxStyle.SYSCALL.getLabel(), (Object)new OutputElementStyle(null, ResourcesStatusDataProvider.toGroup(LinuxStyle.SYSCALL.toMap(), Messages.ResourcesStatusDataProvider_styleGroupCpu, null)));
        builder.put((Object)LinuxStyle.INTERRUPTED.getLabel(), (Object)new OutputElementStyle(null, ResourcesStatusDataProvider.toGroup(LinuxStyle.INTERRUPTED.toMap(), Messages.ResourcesStatusDataProvider_styleGroupCpu, null)));
        builder.put((Object)LinuxStyle.SOFT_IRQ.getLabel(), (Object)new OutputElementStyle(null, ResourcesStatusDataProvider.toGroup(LinuxStyle.SOFT_IRQ.toMap(), Messages.ResourcesStatusDataProvider_styleGroupCpu, null)));
        builder.put((Object)LinuxStyle.SOFT_IRQ_RAISED.getLabel(), (Object)new OutputElementStyle(null, ResourcesStatusDataProvider.toGroup(LinuxStyle.SOFT_IRQ_RAISED.toMap(), Messages.ResourcesStatusDataProvider_styleGroupCpu, null)));
        builder.put((Object)BASE_FREQUENCY_STYLE, (Object)new OutputElementStyle(null, ResourcesStatusDataProvider.toGroup(LinuxStyle.USERMODE.toMap(), Messages.ResourcesStatusDataProvider_styleGroupOther, Messages.ResourcesStatusDataProvider_styleNameThread)));
        builder.put((Object)BASE_THREAD_STYLE, (Object)new OutputElementStyle(null, ResourcesStatusDataProvider.toGroup(LinuxStyle.USERMODE.toMap(), Messages.ResourcesStatusDataProvider_styleGroupOther, Messages.ResourcesStatusDataProvider_styleNameFrequency)));
        STATE_MAP = builder.build();
        CPU_GROUP_ORDER = Arrays.asList(ResourcesEntryModel.Type.CURRENT_THREAD, ResourcesEntryModel.Type.CPU, ResourcesEntryModel.Type.FREQUENCY, ResourcesEntryModel.Type.GROUP);
        COMPARATOR = Comparator.comparing(entry -> CPU_GROUP_ORDER.contains((Object)entry.getType()) ? ResourcesEntryModel.Type.GROUP : entry.getType()).thenComparing(ResourcesEntryModel::getResourceId).thenComparing(entry -> CPU_GROUP_ORDER.indexOf((Object)entry.getType()));
        CACHE_COMPARATOR = (a, b) -> {
            if (a.getEndTime() < b.getStartTime()) {
                return -1;
            }
            if (a.getStartTime() > b.getEndTime()) {
                return 1;
            }
            return 0;
        };
    }

    private static @NonNull Map<@NonNull String, @NonNull Object> toGroup(Map<@NonNull String, @NonNull Object> originalMap, @NonNull String group, @Nullable String styleName) {
        HashMap<@NonNull String, @NonNull Object> builder = new HashMap<String, Object>(originalMap);
        builder.put("style-group", group);
        if (styleName != null) {
            builder.put("style-name", styleName);
        }
        return ImmutableMap.copyOf(builder);
    }

    protected ResourcesStatusDataProvider(@NonNull ITmfTrace trace, @NonNull KernelAnalysisModule module) {
        super(trace, (TmfStateSystemAnalysisModule)module);
        Predicate<@NonNull ResourcesEntryModel> additional = model -> ResourcesEntryModel.Type.CURRENT_THREAD.equals((Object)model.getType());
        this.fEventAnnotatonProvider = new EventAnnotationProvider(TmfStrings.cpu(), additional, candidate -> !(candidate instanceof IKernelTrace) && trace != candidate, TmfCpuAspect.class, trace, (fetchParameters, monitor) -> this.fetchTree((Map)fetchParameters, (IProgressMonitor)monitor));
    }

    protected TmfTreeModel<@NonNull ResourcesEntryModel> getTree(@NonNull ITmfStateSystem ss, Map<String, Object> parameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        long start = ss.getStartTime();
        long end = ss.getCurrentEndTime();
        ArrayList<@NonNull ResourcesEntryModel> builder = new ArrayList<ResourcesEntryModel>();
        long traceId = this.getId(-1);
        ResourcesEntryModel resourcesEntryModel = new ResourcesEntryModel(traceId, -1L, Collections.singletonList(this.getTrace().getName()), start, end, -1, ResourcesEntryModel.Type.GROUP);
        builder.add(resourcesEntryModel);
        for (Integer cpuQuark : ss.getQuarks(new String[]{"CPUs", WILDCARD})) {
            @NonNull String cpuName = ss.getAttributeName(cpuQuark.intValue());
            int cpu = Integer.parseInt(cpuName);
            Integer currentThreadQuark = ss.optQuarkRelative(cpuQuark.intValue(), new String[]{"Current_thread"});
            if (currentThreadQuark != -2) {
                ResourcesEntryModel currentThreadEntry = new ResourcesEntryModel(this.getId(currentThreadQuark), traceId, ResourcesStatusDataProvider.computeEntryName(ResourcesEntryModel.Type.CURRENT_THREAD, cpu), start, end, cpu, ResourcesEntryModel.Type.CURRENT_THREAD);
                builder.add(currentThreadEntry);
                this.fEntryModelTypes.put(currentThreadQuark, ResourcesEntryModel.Type.CURRENT_THREAD);
            }
            ResourcesEntryModel cpuEntry = new ResourcesEntryModel(this.getId(cpuQuark), traceId, ResourcesStatusDataProvider.computeEntryName(ResourcesEntryModel.Type.CPU, cpu), start, end, cpu, ResourcesEntryModel.Type.CPU);
            builder.add(cpuEntry);
            this.fEntryModelTypes.put(cpuQuark, ResourcesEntryModel.Type.CPU);
            Integer currentFreqQuark = ss.optQuarkRelative(cpuQuark.intValue(), new String[]{"Frequency"});
            if (currentFreqQuark != -2) {
                long minFrequency = ResourcesStatusDataProvider.getCpuFrequency(ss, cpuQuark, "Min frequency");
                long maxFrequency = ResourcesStatusDataProvider.getCpuFrequency(ss, cpuQuark, "Max frequency");
                ResourcesEntryModelWeighted currentFreqEntry = new ResourcesEntryModelWeighted(this.getId(currentFreqQuark), traceId, ResourcesStatusDataProvider.computeEntryName(ResourcesEntryModel.Type.FREQUENCY, cpu), start, end, cpu, ResourcesEntryModel.Type.FREQUENCY, minFrequency, maxFrequency);
                builder.add(currentFreqEntry);
                this.fEntryModelTypes.put(currentFreqQuark, ResourcesEntryModel.Type.FREQUENCY);
                this.fFreqMap.put(currentFreqQuark, maxFrequency);
            }
            long id = this.fSeparatorIds.computeIfAbsent(cpu, key -> this.getEntryId());
            builder.add(new ResourcesEntryModel(id, traceId, Collections.singletonList(SEPARATOR), start, end, cpu, ResourcesEntryModel.Type.GROUP));
            List irqQuarks = ss.getQuarks(cpuQuark.intValue(), new String[]{"IRQs", WILDCARD});
            this.createInterrupt(ss, start, end, cpuEntry, irqQuarks, ResourcesEntryModel.Type.IRQ, builder);
            List softIrqQuarks = ss.getQuarks(cpuQuark.intValue(), new String[]{"Soft_IRQs", WILDCARD});
            this.createInterrupt(ss, start, end, cpuEntry, softIrqQuarks, ResourcesEntryModel.Type.SOFT_IRQ, builder);
        }
        Collections.sort(builder, COMPARATOR);
        return new TmfTreeModel(Collections.emptyList(), (List)ImmutableList.copyOf(builder));
    }

    private static long getCpuFrequency(@NonNull ITmfStateSystem ss, int cpuQuark, @NonNull String freqAttribute) throws StateSystemDisposedException {
        int quark = ss.optQuarkRelative(cpuQuark, new String[]{freqAttribute});
        if (quark == -2) {
            return 1L;
        }
        Object value = ss.querySingleState(ss.getStartTime(), quark).getValue();
        return value instanceof Long ? (Long)value / 1000L : 1L;
    }

    private void createInterrupt(ITmfStateSystem ssq, long startTime, long endTime, ResourcesEntryModel cpuEntry, List<Integer> irqQuarks, ResourcesEntryModel.Type type, List<ResourcesEntryModel> builder) {
        for (Integer irqQuark : irqQuarks) {
            String resourceName = ssq.getAttributeName(irqQuark.intValue());
            int resourceId = Integer.parseInt(resourceName);
            long irqId = this.getId(irqQuark);
            builder.add(new ResourcesEntryModel(irqId, cpuEntry.getId(), ResourcesStatusDataProvider.computeEntryName(type, resourceId), startTime, endTime, resourceId, type));
            this.fEntryModelTypes.put(irqQuark, type);
            String aggregateIrqtype = type == ResourcesEntryModel.Type.IRQ ? "IRQs" : "Soft_IRQs";
            int aggregateQuark = ssq.optQuarkAbsolute(new String[]{aggregateIrqtype, resourceName});
            if (aggregateQuark == -2) continue;
            long aggregateId = this.getId(aggregateQuark);
            if (!Iterables.any(builder, entry -> entry.getId() == aggregateId)) {
                builder.add(new ResourcesEntryModel(aggregateId, cpuEntry.getParentId(), ResourcesStatusDataProvider.computeEntryName(type, resourceId), startTime, endTime, resourceId, type));
            }
            this.fEntryModelTypes.put(aggregateQuark, type);
            long id = (Long)this.fTwinIdsToQuark.inverse().computeIfAbsent((Object)irqQuark, key -> this.getEntryId());
            builder.add(new ResourcesEntryModel(id, aggregateId, ResourcesStatusDataProvider.computeEntryName(ResourcesEntryModel.Type.CPU, cpuEntry.getResourceId()), startTime, endTime, cpuEntry.getResourceId(), type));
        }
    }

    private static @NonNull List<@NonNull String> computeEntryName(ResourcesEntryModel.Type type, int id) {
        String cpuEntryName;
        if (type == ResourcesEntryModel.Type.SOFT_IRQ) {
            return Collections.singletonList(String.valueOf(type.toString()) + ' ' + id + ' ' + SoftIrqLabelProvider.getSoftIrq(id));
        }
        if (type == ResourcesEntryModel.Type.CURRENT_THREAD) {
            String threadEntryName = NLS.bind((String)Messages.ThreadEntry, (Object)id);
            if (threadEntryName != null) {
                return Collections.singletonList(threadEntryName);
            }
        } else if (type == ResourcesEntryModel.Type.CPU) {
            String cpuEntryName2 = NLS.bind((String)Messages.CpuEntry, (Object)id);
            if (cpuEntryName2 != null) {
                return Collections.singletonList(cpuEntryName2);
            }
        } else if (type == ResourcesEntryModel.Type.FREQUENCY && (cpuEntryName = NLS.bind((String)Messages.FrequencyEntry, (Object)id)) != null) {
            return Collections.singletonList(cpuEntryName);
        }
        return Collections.singletonList(String.valueOf(type.toString()) + ' ' + id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    public TimeGraphModel getRowModel(ITmfStateSystem ss, @NonNull Map<@NonNull String, @NonNull Object> parameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        TreeMultimap intervals = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparing(ITmfStateInterval::getStartTime));
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(parameters);
        if (filter == null) {
            return null;
        }
        @NonNull @NonNull Map idsToQuark = this.getSelectedEntries(filter);
        this.addTwinIrqIds(filter, idsToQuark);
        Collection times = ResourcesStatusDataProvider.getTimes((TimeQueryFilter)filter, (long)ss.getStartTime(), (long)ss.getCurrentEndTime());
        Set<@NonNull Integer> quarks = ResourcesStatusDataProvider.addThreadStatus(ss, idsToQuark.values());
        for (ITmfStateInterval interval : ss.query2D(quarks, times)) {
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            intervals.put((Object)interval.getAttribute(), (Object)interval);
        }
        HashMap<@NonNull K, @NonNull @NonNull @NonNull @NonNull V> predicates = new HashMap();
        @NonNull @NonNull Multimap regexesMap = DataProviderParameterUtils.extractRegexFilter(parameters);
        if (regexesMap != null) {
            predicates.putAll(this.computeRegexPredicate(regexesMap));
        }
        @NonNull ArrayList<@NonNull TimeGraphRowModel> rows = new ArrayList<TimeGraphRowModel>();
        for (Map.Entry idToQuark : idsToQuark.entrySet()) {
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            Long key = Objects.requireNonNull((Long)idToQuark.getKey());
            ArrayList eventList = new ArrayList();
            for (ITmfStateInterval interval : intervals.get((Object)((Integer)idToQuark.getValue()))) {
                TimeGraphState timeGraphState2;
                long startTime = interval.getStartTime();
                long duration = interval.getEndTime() - startTime + 1L;
                Object status = interval.getValue();
                ResourcesEntryModel.Type type = this.fEntryModelTypes.get(interval.getAttribute());
                if (status instanceof Integer) {
                    TimeGraphState timeGraphState3;
                    int s = (Integer)status;
                    int currentThreadQuark = ss.optQuarkRelative(interval.getAttribute(), new String[]{"Current_thread"});
                    if (type == ResourcesEntryModel.Type.CPU && s == 4) {
                        List<@NonNull ITimeGraphState> syscalls = ResourcesStatusDataProvider.getSyscalls(ss, interval, intervals.get((Object)currentThreadQuark));
                        syscalls.forEach(timeGraphState -> this.applyFilterAndAddState(eventList, (ITimeGraphState)timeGraphState, key, predicates, monitor));
                        continue;
                    }
                    if (type == ResourcesEntryModel.Type.CPU && s == 2) {
                        List<@NonNull TimeGraphState> currentThreads = ResourcesStatusDataProvider.getCurrentThreads(ss, interval, intervals.get((Object)currentThreadQuark));
                        currentThreads.forEach(timeGraphState -> this.applyFilterAndAddState(eventList, (ITimeGraphState)timeGraphState, key, predicates, monitor));
                        continue;
                    }
                    if (type == ResourcesEntryModel.Type.CURRENT_THREAD && s != 0) {
                        String execName = null;
                        TreeMultimap<Integer, ITmfStateInterval> treeMultimap = this.fExecNamesCache;
                        synchronized (treeMultimap) {
                            if (this.fExecNamesCache.containsEntry(status, (Object)interval)) {
                                NavigableSet intervalSet = this.fExecNamesCache.get((Object)s);
                                ITmfStateInterval execNameInterval = intervalSet.ceiling(interval);
                                if (execNameInterval != null && CACHE_COMPARATOR.compare(execNameInterval, interval) == 0) {
                                    execName = (String)execNameInterval.getValue();
                                }
                            } else {
                                int quark = ss.optQuarkAbsolute(new String[]{"Threads", Integer.toString(s), "Exec_name"});
                                if (quark != -2) {
                                    ITmfStateInterval namedInterval = ss.querySingleState(interval.getEndTime(), quark);
                                    this.fExecNamesCache.put((Object)s, (Object)namedInterval);
                                    execName = (String)namedInterval.getValue();
                                }
                            }
                        }
                        timeGraphState2 = new TimeGraphState(startTime, duration, execName != null ? String.valueOf(execName) + ' ' + '(' + String.valueOf(s) + ')' : String.valueOf(s), ResourcesStatusDataProvider.getSpecificStyleForTid(s));
                        this.applyFilterAndAddState(eventList, (ITimeGraphState)timeGraphState2, key, predicates, monitor);
                        continue;
                    }
                    if (type == ResourcesEntryModel.Type.CURRENT_THREAD) {
                        timeGraphState3 = new TimeGraphState(startTime, duration, Integer.MIN_VALUE);
                        this.applyFilterAndAddState(eventList, (ITimeGraphState)timeGraphState3, key, predicates, monitor);
                        continue;
                    }
                    timeGraphState3 = new TimeGraphState(startTime, duration, null, ResourcesStatusDataProvider.getElementStyle(type, s));
                    this.applyFilterAndAddState(eventList, (ITimeGraphState)timeGraphState3, key, predicates, monitor);
                    continue;
                }
                if (status instanceof Long && type == ResourcesEntryModel.Type.FREQUENCY) {
                    long s = (Long)status;
                    Long maxFrequency = this.fFreqMap.get(interval.getAttribute());
                    timeGraphState2 = new TimeGraphState(startTime, duration, String.valueOf(FREQUENCY_FORMATTER.format(s)), ResourcesStatusDataProvider.getSpecificStyleForFrequency((int)(s / 1000L), key, maxFrequency));
                    this.applyFilterAndAddState(eventList, (ITimeGraphState)timeGraphState2, key, predicates, monitor);
                    continue;
                }
                TimeGraphState timeGraphState4 = new TimeGraphState(startTime, duration, Integer.MIN_VALUE);
                this.applyFilterAndAddState(eventList, (ITimeGraphState)timeGraphState4, key, predicates, monitor);
            }
            rows.add(new TimeGraphRowModel(((Long)idToQuark.getKey()).longValue(), eventList));
        }
        TreeMultimap<Integer, ITmfStateInterval> treeMultimap = this.fExecNamesCache;
        synchronized (treeMultimap) {
            this.fExecNamesCache.clear();
        }
        return new TimeGraphModel(rows);
    }

    private static @NonNull OutputElementStyle getElementStyle(ResourcesEntryModel.Type type, int stateValue) {
        String styleFor = ResourcesStatusDataProvider.getStyleFor(type, stateValue);
        return STYLE_MAP.computeIfAbsent(styleFor, style -> new OutputElementStyle(style));
    }

    private static @NonNull String getStyleFor(ResourcesEntryModel.Type type, int stateValue) {
        if (type == ResourcesEntryModel.Type.IRQ) {
            return LinuxStyle.INTERRUPTED.getLabel();
        }
        switch (stateValue) {
            case 0: {
                return LinuxStyle.IDLE.getLabel();
            }
            case 2: {
                return LinuxStyle.USERMODE.getLabel();
            }
            case 4: {
                return LinuxStyle.SYSCALL.getLabel();
            }
            case 16: {
                return LinuxStyle.INTERRUPTED.getLabel();
            }
            case 8: {
                return LinuxStyle.SOFT_IRQ.getLabel();
            }
            case 1: {
                return LinuxStyle.SOFT_IRQ_RAISED.getLabel();
            }
        }
        return LinuxStyle.UNKNOWN.getLabel();
    }

    private static OutputElementStyle getSpecificStyleForTid(int s) {
        return STYLE_MAP.computeIfAbsent(String.valueOf(s), pidStr -> {
            RGBAColor color = PALETTE.get(Math.floorMod(s + 14, 25));
            return new OutputElementStyle(BASE_THREAD_STYLE, (Map)ImmutableMap.of((Object)"background-color", (Object)X11ColorUtils.toHexColor((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue()), (Object)"style-name", (Object)String.valueOf(s)));
        });
    }

    private static OutputElementStyle getSpecificStyleForFrequency(int frequency, Long entryId, @Nullable Long maxFrequency) {
        return STYLE_MAP.computeIfAbsent(String.valueOf(String.valueOf(entryId)) + '_' + String.valueOf(frequency), freqStr -> new OutputElementStyle(BASE_FREQUENCY_STYLE, (Map)ImmutableMap.of((Object)"height", (Object)Float.valueOf(maxFrequency == null ? 1.0f : (float)frequency / (float)maxFrequency.longValue()))));
    }

    private static @NonNull Set<@NonNull Integer> addThreadStatus(@NonNull ITmfStateSystem ss, @NonNull Collection<@NonNull Integer> values) {
        HashSet<@NonNull Integer> set = new HashSet<Integer>(values);
        for (Integer quark : values) {
            int threadStatus;
            int parentAttributeQuark = ss.getParentAttributeQuark(quark.intValue());
            if (!ss.getAttributeName(parentAttributeQuark).equals("CPUs") || (threadStatus = ss.optQuarkRelative(quark.intValue(), new String[]{"Current_thread"})) == -2) continue;
            set.add(threadStatus);
        }
        return set;
    }

    private void addTwinIrqIds(SelectionTimeQueryFilter filter, Map<@NonNull Long, @NonNull Integer> idsToQuark) {
        for (Long id : filter.getSelectedItems()) {
            Integer quark = (Integer)this.fTwinIdsToQuark.get((Object)id);
            if (quark == null) continue;
            idsToQuark.put(id, quark);
        }
    }

    private static List<@NonNull TimeGraphState> getCurrentThreads(@NonNull ITmfStateSystem ss, ITmfStateInterval userModeInterval, @NonNull NavigableSet<ITmfStateInterval> currentThreadIntervals) throws StateSystemDisposedException {
        ArrayList<@NonNull TimeGraphState> list = new ArrayList<TimeGraphState>();
        for (ITmfStateInterval currentThread : currentThreadIntervals) {
            Object currentThreadName;
            int execNameQuark;
            if (currentThread.getStartTime() > userModeInterval.getEndTime() || currentThread.getEndTime() < userModeInterval.getStartTime()) continue;
            long start = Long.max(userModeInterval.getStartTime(), currentThread.getStartTime());
            long end = Long.min(userModeInterval.getEndTime(), currentThread.getEndTime());
            long duration = end - start + 1L;
            Object tid = currentThread.getValue();
            if (tid instanceof Integer && (execNameQuark = ss.optQuarkAbsolute(new String[]{"Threads", String.valueOf(tid), "Exec_name"})) != -2 && (currentThreadName = ss.querySingleState(currentThread.getEndTime(), execNameQuark).getValue()) instanceof String) {
                list.add(new TimeGraphState(start, duration, (String)currentThreadName, STYLE_MAP.computeIfAbsent(LinuxStyle.USERMODE.getLabel(), style -> new OutputElementStyle(style))));
                continue;
            }
            list.add(new TimeGraphState(start, duration, null, STYLE_MAP.computeIfAbsent(LinuxStyle.USERMODE.getLabel(), style -> new OutputElementStyle(style))));
        }
        return list;
    }

    private static List<@NonNull ITimeGraphState> getSyscalls(@NonNull ITmfStateSystem ss, ITmfStateInterval syscallInterval, @NonNull NavigableSet<ITmfStateInterval> currentThreadIntervals) throws StateSystemDisposedException {
        ArrayList<@NonNull ITimeGraphState> list = new ArrayList<ITimeGraphState>();
        for (ITmfStateInterval currentThread : currentThreadIntervals) {
            Object syscallName;
            int syscallQuark;
            if (currentThread.getStartTime() > syscallInterval.getEndTime() || currentThread.getEndTime() < syscallInterval.getStartTime()) continue;
            long start = Long.max(syscallInterval.getStartTime(), currentThread.getStartTime());
            long end = Long.min(syscallInterval.getEndTime(), currentThread.getEndTime());
            long duration = end - start + 1L;
            Object tid = currentThread.getValue();
            if (tid instanceof Integer && (syscallQuark = ss.optQuarkAbsolute(new String[]{"Threads", String.valueOf(tid), "System_call"})) != -2 && (syscallName = ss.querySingleState(start, syscallQuark).getValue()) instanceof String) {
                list.add((ITimeGraphState)new TimeGraphState(start, duration, String.valueOf(syscallName), STYLE_MAP.computeIfAbsent(LinuxStyle.SYSCALL.getLabel(), style -> new OutputElementStyle(style))));
                continue;
            }
            list.add((ITimeGraphState)new TimeGraphState(start, duration, null, STYLE_MAP.computeIfAbsent(LinuxStyle.SYSCALL.getLabel(), style -> new OutputElementStyle(style))));
        }
        return list;
    }

    public @NonNull TmfModelResponse<@NonNull List<@NonNull ITimeGraphArrow>> fetchArrows(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public @NonNull String getId() {
        return ID;
    }

    public @NonNull TmfModelResponse<@NonNull Map<@NonNull String, @NonNull String>> fetchTooltip(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        ITmfStateSystem ss = ((KernelAnalysisModule)this.getAnalysisModule()).getStateSystem();
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(fetchParameters);
        if (filter == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
        }
        Collection<@NonNull V> quarks = this.getSelectedEntries(filter).values();
        boolean isACopy = false;
        if (quarks.size() != 1) {
            HashMap<Long, Integer> selectedEntries = new HashMap<Long, Integer>();
            for (Long selectedItem : filter.getSelectedItems()) {
                Integer quark = (Integer)this.fTwinIdsToQuark.get((Object)selectedItem);
                if (quark == null || quark < 0) continue;
                selectedEntries.put(selectedItem, quark);
                isACopy = true;
            }
            quarks = selectedEntries.values();
        }
        long start = filter.getStart();
        if (ss == null || quarks.size() != 1 || !((KernelAnalysisModule)this.getAnalysisModule()).isQueryable(start)) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        int quark = (Integer)quarks.iterator().next();
        String attributeName = ss.getAttributeName(quark);
        Integer cpuNumber = Ints.tryParse((String)attributeName);
        String parent = ss.getAttributeName(ss.getParentAttributeQuark(quark));
        if (cpuNumber == null && !attributeName.equals("Current_thread") && !attributeName.equals("Frequency")) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        try {
            LinkedHashMap<String, String> retMap = new LinkedHashMap<String, String>(1);
            List full = ss.queryFullState(start);
            Object object = ((ITmfStateInterval)full.get(quark)).getValue();
            if (object instanceof Integer) {
                int status = (Integer)object;
                if (isACopy) {
                    retMap.put(parent.equals("IRQs") ? Messages.ResourcesStatusDataProvider_attributeIrqName : Messages.ResourcesStatusDataProvider_attributeSoftIrqName, attributeName);
                } else if (parent.equals("IRQs") || parent.equals("Soft_IRQs")) {
                    ResourcesStatusDataProvider.putCpus(ss, quark, retMap, full, parent, status);
                } else if (status == 16) {
                    ResourcesStatusDataProvider.putIrq(ss, attributeName, retMap, full, "IRQs", status);
                } else if (status == 8) {
                    ResourcesStatusDataProvider.putIrq(ss, attributeName, retMap, full, "Soft_IRQs", status);
                } else if (status == 2 || status == 4) {
                    this.putCpuTooltip(ss, attributeName, retMap, full, status);
                } else if (attributeName.equals("Current_thread")) {
                    ResourcesStatusDataProvider.putCurrentThreadTooltip(ss, retMap, full, status);
                }
            } else if (object instanceof Long && attributeName.equals("Frequency")) {
                retMap.put("Frequency", FREQUENCY_FORMATTER.format(object));
            }
            return new TmfModelResponse(retMap, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
    }

    private static void putCpus(ITmfStateSystem ss, int quark, Map<String, String> retMap, List<ITmfStateInterval> full, String irqs, int status) {
        ArrayList<@NonNull String> cpuList = new ArrayList<String>();
        int grandParentAttribute = ss.getParentAttributeQuark(ss.getParentAttributeQuark(quark));
        if (grandParentAttribute != -1 && ss.getAttributeName(ss.getParentAttributeQuark(ss.getParentAttributeQuark(ss.getParentAttributeQuark(quark)))).equals("CPUs")) {
            cpuList.add(ss.getAttributeName(grandParentAttribute));
        } else {
            Iterator iterator = ss.getQuarks(new String[]{"CPUs", WILDCARD, irqs, ss.getAttributeName(quark)}).iterator();
            while (iterator.hasNext()) {
                int objectStatus;
                Object object;
                int cpuQuark = (Integer)iterator.next();
                ITmfStateInterval interval = full.get(cpuQuark);
                if (interval.getValue() == null || !((object = full.get(cpuQuark).getValue()) instanceof Integer) || (objectStatus = ((Integer)object).intValue()) != status) continue;
                String cpu = ss.getAttributeName(ss.getParentAttributeQuark(ss.getParentAttributeQuark(cpuQuark)));
                cpuList.add(cpu);
            }
        }
        if (!cpuList.isEmpty()) {
            Collections.sort(cpuList, (s1, s2) -> Integer.compare(Integer.parseInt(s1), Integer.parseInt(s2)));
            retMap.put(TmfStrings.cpu(), String.join((CharSequence)", ", cpuList));
        }
    }

    private static void putIrq(ITmfStateSystem ss, String attributeName, Map<String, String> retMap, List<ITmfStateInterval> full, String irqs, int status) {
        Iterator iterator = ss.getQuarks(new String[]{"CPUs", attributeName, irqs, WILDCARD}).iterator();
        while (iterator.hasNext()) {
            int objectStatus;
            Object object;
            int irqQuark = (Integer)iterator.next();
            ITmfStateInterval interval = full.get(irqQuark);
            if (interval.getValue() == null || !((object = full.get(irqQuark).getValue()) instanceof Integer) || (objectStatus = ((Integer)object).intValue()) != status) continue;
            retMap.put(status == 16 ? Messages.ResourcesStatusDataProvider_attributeIrqName : Messages.ResourcesStatusDataProvider_attributeSoftIrqName, ss.getAttributeName(irqQuark));
            return;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void putCpuTooltip(ITmfStateSystem ss, String attributeName, Map<String, String> retMap, List<ITmfStateInterval> full, int status) {
        int currentThreadQuark = ss.optQuarkAbsolute(new String[]{"CPUs", attributeName, "Current_thread"});
        if (currentThreadQuark == -2) {
            return;
        }
        Object currentThreadObject = full.get(currentThreadQuark).getValue();
        if (currentThreadObject instanceof Number) {
            ITmfStateInterval interval;
            Object syscall;
            Object processName;
            String currentThread = currentThreadObject.toString();
            retMap.put(Messages.ResourcesStatusDataProvider_attributeTidName, currentThread);
            int execNameQuark = ss.optQuarkAbsolute(new String[]{"Threads", currentThread, "Exec_name"});
            if (execNameQuark != -2 && (processName = full.get(execNameQuark).getValue()) instanceof String) {
                retMap.put(Messages.ResourcesStatusDataProvider_attributeProcessName, (String)processName);
            }
            int syscallQuark = ss.optQuarkAbsolute(new String[]{"Threads", currentThread, "System_call"});
            if (status == 4 && syscallQuark != -2 && (syscall = (interval = full.get(syscallQuark)).getValue()) instanceof String) {
                retMap.put("System_call", (String)syscall);
                ITmfTrace trace = this.getTrace();
                ITmfCallsiteResolver csAnalysis = (ITmfCallsiteResolver)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, CallsiteAnalysis.class, (String)"org.eclipse.tracecompass.tmf.core.analysis.callsite");
                if (csAnalysis != null) {
                    for (ITmfEventAspect aspect : trace.getEventAspects()) {
                        if (!(aspect instanceof TmfCpuAspect)) continue;
                        TmfCpuAspect deviceAspect = (TmfCpuAspect)aspect;
                        @NonNull List callsites = csAnalysis.getCallsites(String.valueOf(trace.getUUID()), deviceAspect.getDeviceType(), attributeName, interval.getStartTime() / 2L + interval.getEndTime() / 2L);
                        if (callsites.isEmpty()) continue;
                        retMap.put(TmfStrings.source(), ((ITmfCallsite)callsites.get(0)).toString());
                    }
                }
            }
        }
    }

    private static void putCurrentThreadTooltip(ITmfStateSystem ss, Map<String, String> retMap, List<ITmfStateInterval> full, int tid) {
        Object processName;
        String currentThread = String.valueOf(tid);
        retMap.put(OsStrings.tid(), currentThread);
        int execNameQuark = ss.optQuarkAbsolute(new String[]{"Threads", currentThread, "Exec_name"});
        if (execNameQuark != -2 && (processName = full.get(execNameQuark).getValue()) instanceof String) {
            retMap.put(OsStrings.execName(), (String)processName);
        }
    }

    protected boolean isCacheable() {
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Multimap<@NonNull String, @NonNull Object> getFilterData(long entryId, long time, @Nullable IProgressMonitor monitor) {
        @NonNull @NonNull HashMultimap data = HashMultimap.create();
        data.putAll(super.getFilterData(entryId, time, monitor));
        SelectionTimeQueryFilter filter = new SelectionTimeQueryFilter(Collections.singletonList(time), Collections.singleton(Objects.requireNonNull(entryId)));
        TmfModelResponse<Map<String, String>> response = this.fetchTooltip(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)filter), monitor);
        @NonNull @NonNull Map model = (Map)response.getModel();
        if (model != null) {
            for (Map.Entry entry : model.entrySet()) {
                data.put((Object)((String)entry.getKey()), entry.getValue());
            }
        }
        return data;
    }

    public @NonNull TmfModelResponse<@NonNull AnnotationCategoriesModel> fetchAnnotationCategories(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return this.fEventAnnotatonProvider.fetchAnnotationCategories(fetchParameters, monitor);
    }

    public @NonNull TmfModelResponse<@NonNull AnnotationModel> fetchAnnotations(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return this.fEventAnnotatonProvider.fetchAnnotations(fetchParameters, monitor);
    }

    public @NonNull TmfModelResponse<@NonNull OutputStyleModel> fetchStyle(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse((Object)new OutputStyleModel(STATE_MAP), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }
}

