/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.ui.launcher;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.pde.launching.JUnitLaunchConfigurationDelegate;
import org.eclipse.reddeer.common.userprofile.UserProfile;
import org.eclipse.reddeer.eclipse.ui.launcher.RedDeerJUnitTab;
import org.eclipse.reddeer.eclipse.ui.launcher.RedDeerLauncherProperties;

public class RedDeerLaunchConfigurationDelegate
extends JUnitLaunchConfigurationDelegate {
    public static final String LAUNCH_CONFIG_ID = "org.eclipse.reddeer.eclipse.ui.launcher.JunitLaunchConfig";

    protected String getApplication(ILaunchConfiguration configuration) {
        return "org.eclipse.reddeer.jdt.junit.reddeertestapplication";
    }

    protected void collectExecutionArguments(ILaunchConfiguration configuration, List vmArguments, List programArgs) throws CoreException {
        super.collectExecutionArguments(configuration, vmArguments, programArgs);
        List<RedDeerLauncherProperties> properties = RedDeerLauncherProperties.loadAll(configuration);
        IStringVariableManager mgr = VariablesPlugin.getDefault().getStringVariableManager();
        if (properties != null && properties.size() > 0) {
            for (RedDeerLauncherProperties property : properties) {
                if (property.getCurrentValue() == null || "".equals(property.getCurrentValue())) continue;
                vmArguments.add(this.getVMArgument(property, mgr));
            }
        } else {
            String userProfileProgramArgs;
            RedDeerLauncherProperties[] redDeerLauncherPropsInitValues;
            RedDeerLauncherProperties[] redDeerLauncherPropertiesArray = redDeerLauncherPropsInitValues = RedDeerLauncherProperties.getInitialRedDeerLauncherProperties();
            int n = redDeerLauncherPropsInitValues.length;
            int n2 = 0;
            while (n2 < n) {
                RedDeerLauncherProperties property = redDeerLauncherPropertiesArray[n2];
                String currValue = property.getCurrentValue();
                if (currValue != null && currValue.length() > 0) {
                    vmArguments.add(this.getVMArgument(property, mgr));
                }
                ++n2;
            }
            ILaunchConfigurationWorkingCopy launchConfigurationWorkingCopy = configuration.getWorkingCopy();
            RedDeerJUnitTab.savePropertiesToLaunchConfiguration(launchConfigurationWorkingCopy, redDeerLauncherPropsInitValues);
            String userProfileVMargs = UserProfile.getInstance().getProperty("vmArgs");
            if (userProfileVMargs != null) {
                String currentVMargs = configuration.getAttribute("org.eclipse.jdt.launching.VM_ARGUMENTS", "");
                launchConfigurationWorkingCopy.setAttribute("org.eclipse.jdt.launching.VM_ARGUMENTS", String.valueOf(currentVMargs) + (currentVMargs.length() > 0 ? " " : "") + userProfileVMargs);
                launchConfigurationWorkingCopy.doSave();
                vmArguments.add(userProfileVMargs);
            }
            if ((userProfileProgramArgs = UserProfile.getInstance().getProperty("programArgs")) != null) {
                String currentProgramArgs = configuration.getAttribute("org.eclipse.jdt.launching.PROGRAM_ARGUMENTS", "");
                launchConfigurationWorkingCopy.setAttribute("org.eclipse.jdt.launching.PROGRAM_ARGUMENTS", String.valueOf(currentProgramArgs) + (currentProgramArgs.length() > 0 ? " " : "") + userProfileProgramArgs);
                launchConfigurationWorkingCopy.doSave();
                programArgs.add(userProfileProgramArgs);
            }
        }
    }

    private String getVMArgument(RedDeerLauncherProperties property, IStringVariableManager mgr) throws CoreException {
        String substituedVariables = mgr.performStringSubstitution(property.getCurrentValue());
        return "-D" + property.getProperty().getName() + "=" + substituedVariables;
    }
}

