/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.ExecutionInfo;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.MachineInfo;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.PS_File;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.PS_Function;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.PS_HwpcEvent;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.PS_HwpcProfile;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.PS_PModule;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.PS_Report;
import org.xml.sax.Attributes;

public class PS_HwpcProfileReport
extends PS_Report {
    private static final String DATETAG = "date";
    private static final String HOSTTAG = "hostname";
    private static final String DOMAINTAG = "domainname";
    private static final String USERTAG = "username";
    private static final String ANNOTATIONTAG = "annotation";
    private static final String EXECUTIONINFOTAG = "executioninfo";
    private static final String MACHINEINFOTAG = "machineinfo";
    private static final String HWPCPROFILETAG = "hwpcprofile";
    private static final String MAPPERATT = "mapper";
    private static final String HWPCEVENTTAG = "hwpcevent";
    private static final String CLASSATT = "class";
    private static final String CLASSVERSIONATT = "version";
    private static final String TYPEATT = "type";
    private static final String NAMEATT = "name";
    private static final String DOMAINATT = "domain";
    private static final String PERIODTAG = "period";
    private static final String TOTALSAMPLESTAG = "totalsamples";
    private static final String MODULETAG = "module";
    private static final String FILETAG = "file";
    private static final String FUNCTIONTAG = "function";
    private static final String LINETAG = "line";
    private static final String LINENOATT = "lineno";
    private static final String DATEFORMAT = "EEE MMM dd HH:mm:ss yyyy";
    private Date date;
    private String hostname;
    private String domainname;
    private String username;
    private String annotation;
    private boolean inExecutionInfo = false;
    private ExecutionInfo executionInfo = new ExecutionInfo();
    private MachineInfo machineInfo = new MachineInfo();
    private List<PS_HwpcProfile> profileList = new ArrayList<PS_HwpcProfile>();
    private String tmpValue = "";
    private String tmpElementName;
    private String tmpMapper;
    private PS_HwpcEvent tmpHwpcEvent;
    private long tmpPeriod;
    private long tmpTotalSamples;
    private int tmpLineNo;
    private PS_Function tmpFunction;
    private PS_File tmpFile;
    private PS_PModule tmpModule;
    private List<PS_PModule> tmpModuleList;
    private PS_HwpcProfile tmpProfile;

    PS_HwpcProfileReport() {
    }

    @Override
    void startElement(String uri, String localName, String qName, Attributes atts) {
        this.tmpElementName = qName;
        String tagname = qName.trim();
        if (tagname.equals(MACHINEINFOTAG)) {
            this.inExecutionInfo = false;
        } else if (this.inExecutionInfo) {
            this.executionInfo.startElement(uri, localName, qName, atts);
        } else if (MachineInfo.containsKey(qName)) {
            this.machineInfo.startElement(uri, localName, qName, atts);
        } else {
            if (tagname.equals(EXECUTIONINFOTAG)) {
                this.inExecutionInfo = true;
            } else if (tagname.equals(HWPCPROFILETAG)) {
                this.tmpMapper = atts.getValue(MAPPERATT);
                this.tmpModuleList = new ArrayList<PS_PModule>();
                this.tmpProfile = new PS_HwpcProfile();
            } else if (tagname.equals(HWPCEVENTTAG)) {
                this.tmpHwpcEvent = new PS_HwpcEvent(atts.getValue(NAMEATT), atts.getValue(CLASSATT), atts.getValue(DOMAINATT), atts.getValue(CLASSVERSIONATT), atts.getValue(TYPEATT));
            } else if (tagname.equals(MODULETAG)) {
                this.tmpModule = new PS_PModule(atts.getValue(NAMEATT));
            } else if (tagname.equals(FILETAG)) {
                this.tmpFile = new PS_File(atts.getValue(NAMEATT));
            } else if (tagname.equals(FUNCTIONTAG)) {
                this.tmpFunction = new PS_Function(atts.getValue(NAMEATT));
            } else if (tagname.equals(LINETAG)) {
                this.tmpLineNo = Integer.parseInt(atts.getValue(LINENOATT));
            }
            this.tmpValue = "";
        }
    }

    @Override
    void characters(char[] ch, int start, int length) {
        if (this.tmpElementName == null) {
            return;
        }
        if (this.inExecutionInfo) {
            this.executionInfo.characters(ch, start, length);
        } else if (MachineInfo.containsKey(this.tmpElementName)) {
            this.machineInfo.characters(ch, start, length);
        } else {
            String tmpString = new String(ch, start, length);
            if (tmpString.length() != 0) {
                this.tmpValue = this.tmpValue.length() == 0 ? tmpString : this.tmpValue.concat(tmpString);
            }
        }
    }

    @Override
    void endElement(String uri, String localName, String qName) {
        this.tmpValue = this.tmpValue.trim();
        if (qName.equals(EXECUTIONINFOTAG)) {
            this.inExecutionInfo = false;
        } else if (this.inExecutionInfo) {
            this.executionInfo.endElement(uri, localName, qName);
        } else if (MachineInfo.containsKey(qName)) {
            this.machineInfo.endElement(uri, localName, qName);
        } else if (qName.equals(DATETAG)) {
            Locale savedDefaultLocale = Locale.getDefault();
            if (!savedDefaultLocale.equals(Locale.US)) {
                Locale.setDefault(Locale.US);
            }
            SimpleDateFormat df = new SimpleDateFormat(DATEFORMAT);
            try {
                this.date = df.parse(this.tmpValue);
            }
            catch (ParseException pe) {
                System.err.println("Error in parsing date in ExecutionInfo.endElement: date = \"" + this.tmpValue + "\".");
                throw new RuntimeException(pe);
            }
            if (!savedDefaultLocale.equals(Locale.US)) {
                Locale.setDefault(savedDefaultLocale);
            }
        } else if (qName.equals(HOSTTAG)) {
            this.hostname = this.tmpValue;
        } else if (qName.equals(DOMAINTAG)) {
            this.domainname = this.tmpValue;
        } else if (qName.equals(USERTAG)) {
            this.username = this.tmpValue;
        } else if (qName.equals(ANNOTATIONTAG)) {
            this.annotation = this.tmpValue;
        } else if (qName.equals(PERIODTAG)) {
            this.tmpPeriod = Long.parseLong(this.tmpValue);
        } else if (qName.equals(TOTALSAMPLESTAG)) {
            this.tmpTotalSamples = Long.parseLong(this.tmpValue);
        } else if (qName.equals(MODULETAG)) {
            this.tmpModuleList.add(this.tmpModule);
        } else if (qName.equals(FILETAG)) {
            this.tmpModule.add(this.tmpFile);
        } else if (qName.equals(FUNCTIONTAG)) {
            this.tmpFile.add(this.tmpFunction);
        } else if (qName.equals(LINETAG)) {
            long tmpNumSamples = Long.parseLong(this.tmpValue);
            this.tmpFunction.add(this.tmpLineNo, tmpNumSamples);
        } else if (qName.equals(HWPCPROFILETAG)) {
            this.tmpProfile.setMapper(this.tmpMapper);
            this.tmpProfile.setHwpcEvent(this.tmpHwpcEvent);
            this.tmpProfile.setPeriod(this.tmpPeriod);
            this.tmpProfile.setTotalSamples(this.tmpTotalSamples);
            this.tmpProfile.setModules(this.tmpModuleList);
            this.profileList.add(this.tmpProfile);
        }
        this.tmpValue = "";
    }

    @Override
    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append(super.toString());
        res.append("  [Date:        " + this.date.toString() + "]\n");
        res.append("  [Hostname:    " + this.hostname + "]\n");
        res.append("  [User:        " + this.username + "]\n");
        if (this.annotation != null) {
            res.append("  [Annotation:  " + this.annotation + "]\n");
        }
        res.append(this.executionInfo.toString());
        res.append(this.machineInfo.toString());
        res.append("Profile Information\n");
        int numProfiles = this.profileList.size();
        if (numProfiles == 0) {
            res.append("No profile information is available.\n");
        }
        int prof_idx = 0;
        while (prof_idx < numProfiles) {
            PS_HwpcProfile cur_profile = this.profileList.get(prof_idx);
            res.append("  Event Info:\n");
            res.append(cur_profile.getHwpcEvent().toString());
            res.append("\n");
            res.append("  Period: " + cur_profile.getPeriod() + "\n");
            res.append("  Total number of samples: " + cur_profile.getTotalSamples() + "\n");
            List<PS_PModule> moduleList = cur_profile.getModules();
            res.append("Module Counts (" + moduleList.size() + " modules)\n");
            for (PS_PModule tmpModule : moduleList) {
                res.append("Module: " + tmpModule.getName() + "\n");
                for (PS_File tmpFile : tmpModule.getFiles()) {
                    res.append("  File: " + tmpFile.getName() + "\n");
                    for (PS_Function tmpFunction : tmpFile.getFunctions()) {
                        res.append("    Function: " + tmpFunction.getName() + "\n");
                        for (Map.Entry<Integer, Long> entry : tmpFunction.getMap().entrySet()) {
                            res.append("      Line number: " + entry.getKey() + ", number of samples: " + entry.getValue() + "\n");
                        }
                    }
                }
            }
            ++prof_idx;
        }
        return res.toString();
    }

    public Date getDate() {
        return this.date;
    }

    public String getHostName() {
        return this.hostname;
    }

    public String getDomainName() {
        return this.domainname;
    }

    public String getUserName() {
        return this.username;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public ExecutionInfo getExecutionInfo() {
        return this.executionInfo;
    }

    public MachineInfo getMachineInfo() {
        return this.machineInfo;
    }

    public float getWallSecs() {
        float mhz = this.machineInfo.getCPUInfo().getClockSpeed();
        long wallTicks = this.executionInfo.getWallTicks();
        float wallsecs = 0L == wallTicks ? this.executionInfo.getWallSecs() : (float)wallTicks / (mhz * 1000000.0f);
        return wallsecs;
    }

    public List<PS_HwpcProfile> getProfiles() {
        return this.profileList;
    }
}

