/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml;

import java.util.Set;
import java.util.TreeSet;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.CPUInfo;
import org.xml.sax.Attributes;

public class MachineInfo {
    private CPUInfo cpuinfo = new CPUInfo();
    private int cpucount;
    private float memorysize;
    private float syspagesize;
    private String tmpValue = "";
    private String tmpElementName;
    private static final String CPUCOUNTTAG = "cpucount";
    private static final String MEMORYSIZETAG = "memoryinfo";
    private static final String SYSPAGESIZETAG = "syspagesize";
    private static final Set<String> keySet = new TreeSet<String>();

    static {
        keySet.add(CPUCOUNTTAG);
        keySet.add(MEMORYSIZETAG);
        keySet.add(SYSPAGESIZETAG);
    }

    MachineInfo() {
    }

    static boolean containsKey(String str) {
        return keySet.contains(str) || CPUInfo.containsKey(str);
    }

    void startElement(String uri, String localName, String qName, Attributes atts) {
        this.tmpElementName = qName;
        if (CPUInfo.containsKey(qName)) {
            this.cpuinfo.startElement(uri, localName, qName, atts);
        }
        this.tmpValue = "";
    }

    void characters(char[] ch, int start, int length) {
        if (CPUInfo.containsKey(this.tmpElementName)) {
            this.cpuinfo.characters(ch, start, length);
        } else {
            String tmpString = new String(ch, start, length);
            if (tmpString.length() != 0) {
                this.tmpValue = this.tmpValue.length() == 0 ? tmpString : this.tmpValue.concat(tmpString);
            }
        }
    }

    void endElement(String uri, String localName, String qName) {
        this.tmpValue = this.tmpValue.trim();
        if (CPUInfo.containsKey(qName)) {
            this.cpuinfo.endElement(uri, localName, qName);
        } else if (qName.equals(CPUCOUNTTAG)) {
            this.cpucount = Integer.parseInt(this.tmpValue);
        } else if (qName.equals(MEMORYSIZETAG)) {
            this.memorysize = Float.parseFloat(this.tmpValue);
        } else if (qName.equals(SYSPAGESIZETAG)) {
            this.syspagesize = Float.parseFloat(this.tmpValue);
        }
        this.tmpValue = "";
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("Machine Information:\n");
        res.append("  [CPUs:        " + this.cpucount + "]\n" + "  [Memory:      " + this.memorysize + " (MB)]\n" + "  [Page:        " + this.syspagesize + " (KB)]\n");
        return String.valueOf(res.toString()) + this.cpuinfo.toString();
    }

    public CPUInfo getCPUInfo() {
        return this.cpuinfo;
    }

    public int getCPUCount() {
        return this.cpucount;
    }

    public float getMemorySize() {
        return this.memorysize;
    }

    public float getSysPageSize() {
        return this.syspagesize;
    }
}

