/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.feedback.perfsuite;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.etfw.feedback.AbstractFeedbackParser;
import org.eclipse.ptp.etfw.feedback.IFeedbackItem;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.PerfSuiteFeedbackItem;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.util.ValueSortedMap;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.PS_HwpcProfileReport;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.PS_MultiHwpcProfileReport;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.PS_Report;
import org.xml.sax.SAXException;

public class PerfSuiteFeedbackParser
extends AbstractFeedbackParser {
    private final boolean traceOn = false;
    private List<IFeedbackItem> items = new ArrayList<IFeedbackItem>();

    public List<IFeedbackItem> getFeedbackItems(IFile ifile) {
        this.items = new ArrayList<IFeedbackItem>();
        try {
            this.items = this.parse(ifile);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.items;
    }

    @Deprecated
    public List<IFeedbackItem> getFeedbackItems(File file) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath location = Path.fromOSString((String)file.getAbsolutePath());
        IFile ifile = workspace.getRoot().getFileForLocation(location);
        List<IFeedbackItem> items = this.getFeedbackItems(ifile);
        return items;
    }

    public String getMarkerID() {
        return "org.eclipse.ptp.etfw.feedback.perfsuite.marker";
    }

    public String getViewID() {
        return "org.eclipse.ptp.etfw.feedback.perfsuite.view";
    }

    public List<IFeedbackItem> parse(IFile ifile) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        ArrayList<IFeedbackItem> items = new ArrayList<IFeedbackItem>();
        IProject project = ifile.getProject();
        String remoteAbsPath = project.getLocationURI().getPath();
        String projectFullPath = project.getFullPath().toString();
        InputStream ais = null;
        try {
            ais = ifile.getContents();
        }
        catch (CoreException ce) {
            System.out.println("Caught CoreException: " + ce.getMessage());
        }
        PS_Report report0 = PS_Report.newInstance(ais, false);
        if (!(report0 instanceof PS_MultiHwpcProfileReport)) {
            System.err.println("Error: The XML is not a PerfSuite multi-HWPC profile report.");
            System.exit(1);
        }
        HashSet<String> skipFileSet = new HashSet<String>();
        PS_MultiHwpcProfileReport report = (PS_MultiHwpcProfileReport)report0;
        for (PS_HwpcProfileReport rep : report.getReports()) {
            int numProfiles = rep.getProfiles().size();
            if (numProfiles > 1) {
                System.out.println("Warning: The report contains multiple profiles, using only the first one.");
            }
            Map<String, Map<String, Map<String, Map<Long, Long>>>> nestedMap = rep.getProfiles().get(0).getNestedModuleMap();
            for (Map.Entry<String, Map<String, Map<String, Map<Long, Long>>>> mentry : ValueSortedMap.getNestedMapDesc(nestedMap).entrySet()) {
                String mName = mentry.getKey();
                Map<String, Map<String, Map<Long, Long>>> fileMap = mentry.getValue();
                for (Map.Entry<String, Map<String, Map<Long, Long>>> fientry : ValueSortedMap.getNestedMapDesc(fileMap).entrySet()) {
                    String fiName = fientry.getKey();
                    Map<String, Map<Long, Long>> funcMap = fientry.getValue();
                    for (Map.Entry<String, Map<Long, Long>> fuentry : ValueSortedMap.getNestedMapDesc(funcMap).entrySet()) {
                        String fuName = fuentry.getKey();
                        Map<Long, Long> lineMap = fuentry.getValue();
                        for (Map.Entry<Long, Long> lentry : ValueSortedMap.getMapDesc(lineMap).entrySet()) {
                            long lineno = lentry.getKey();
                            Long numSamples = lentry.getValue();
                            String parentID = String.valueOf(rep.getHostName()) + "-" + "PID_" + rep.getExecutionInfo().getPid() + "-" + "thread_" + rep.getExecutionInfo().getThreadId();
                            if (!fiName.startsWith(remoteAbsPath)) {
                                if (skipFileSet.contains(fiName)) continue;
                                System.out.println("Plugin: org.eclipse.ptp.etfw.feedback.perfsuite: Project '" + project + "', file '" + fiName + "' does not exist in the work space, skipping...");
                                skipFileSet.add(fiName);
                                continue;
                            }
                            String fiNameInWS = fiName.replace(remoteAbsPath, projectFullPath);
                            if (fiName.equals("??")) continue;
                            try {
                                PerfSuiteFeedbackItem item = new PerfSuiteFeedbackItem(mName, parentID, fuName, fiNameInWS, lineno, Long.toString(numSamples));
                                items.add(item);
                            }
                            catch (Exception e) {
                                System.out.println("PerfSuiteFeedbackParser: Exception creating item.  Likely the file '" + fiName + "' is not in the workspace.  Exception message: " + e.getMessage());
                            }
                        }
                    }
                }
            }
        }
        return items;
    }
}

