/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.common.remote;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.common.remote.UnexpectedExceptionCommandException;

public class ExpressionCommands {
    public static final byte START_EXPRESSION_TREE_PROCESSING = 0;
    public static final byte PUSH_EXPRESSION = 1;
    public static final byte END_EXPRESSION_TREE_PROCESSING = 2;
    public static final byte SYNC_REQUEST = 3;
    public static final byte PULL_VALUE_REQUEST = 4;
    public static final byte TRANSFER_EXPRESSION_REQUEST = 5;
    public static final byte RESUME_EXPRESSION_REQUEST = 6;
    public static final int EXPRESSION_NOEXPRESSIONVALUE_EXCEPTION = 9;
    public static final int EXPRESSIONPROXY_VOIDTYPE = 0;
    public static final int EXPRESSIONPROXY_NOTRESOLVED = 1;
    public static final byte TRACE_DEFAULT = -1;
    public static final byte TRACE_OFF = 0;
    public static final byte TRACE_ON = 1;
    public static final String EXPRESSIONTRACE = "proxyvm.expressionTrace";
    public static final String EXPRESSIONTRACE_TIMER_THRESHOLD = "proxyvm.expressionTraceTimerThreshold";

    public static void sendStartExpressionProcessingCommand(int expressionID, byte trace, DataOutputStream os) throws IOException {
        os.writeByte(19);
        os.writeInt(expressionID);
        os.writeByte(0);
        os.writeByte(trace);
    }

    public static void sendEndExpressionProcessingCommand(int expressionID, DataOutputStream os) throws IOException {
        os.writeByte(19);
        os.writeInt(expressionID);
        os.writeByte(2);
        os.flush();
    }

    public static void sendExpressionCommand(int expressionID, DataOutputStream os, byte subcommand) throws IOException {
        os.writeByte(19);
        os.writeInt(expressionID);
        os.writeByte(1);
        os.writeByte(subcommand);
    }

    public static void sendByte(DataOutputStream os, byte aByte) throws IOException {
        os.writeByte(aByte);
    }

    public static void sendInt(DataOutputStream os, int anInt) throws IOException {
        os.writeInt(anInt);
    }

    public static void sendString(DataOutputStream os, String aString) throws IOException {
        Commands.sendStringData(os, aString);
    }

    public static void sendBoolean(DataOutputStream os, boolean aBool) throws IOException {
        os.writeBoolean(aBool);
    }

    public static void sendPullValueCommand(int expressionID, DataOutputStream os, DataInputStream is, Commands.ValueObject proxyids, Commands.ValueSender sender) throws CommandException {
        try {
            os.writeByte(19);
            os.writeInt(expressionID);
            os.writeByte(4);
            ExpressionCommands.sendProxyIDs(os, proxyids);
            os.flush();
            if (proxyids != null) {
                Commands.readBackValue(is, proxyids, (byte)53);
                sender.initialize(proxyids);
                Commands.readArray(is, proxyids.anInt, sender, proxyids, true);
            }
        }
        catch (CommandException e) {
            throw e;
        }
        catch (IOException e) {
            throw new UnexpectedExceptionCommandException(false, (Throwable)e);
        }
    }

    public static void sendSyncCommand(int expressionID, DataOutputStream os, DataInputStream is, Commands.ValueObject proxyids, Commands.ValueSender sender) throws CommandException {
        try {
            os.writeByte(19);
            os.writeInt(expressionID);
            os.writeByte(3);
            ExpressionCommands.sendProxyIDs(os, proxyids);
            os.flush();
            if (proxyids != null) {
                Commands.readBackValue(is, proxyids, (byte)53);
                sender.initialize(proxyids);
                Commands.readArray(is, proxyids.anInt, sender, proxyids, true);
            }
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnexpectedExceptionCommandException(false, (Throwable)e);
        }
    }

    private static void sendProxyIDs(DataOutputStream os, Commands.ValueObject proxyids) throws IOException, CommandException {
        if (proxyids != null) {
            os.writeBoolean(true);
            Commands.writeValue(os, proxyids, false, false);
        } else {
            os.writeBoolean(false);
        }
    }

    public static void sendTransferExpressionCommand(int expressionID, DataOutputStream os, DataInputStream is, Commands.ValueObject expressionProcesserController) throws CommandException {
        try {
            os.writeByte(19);
            os.writeInt(expressionID);
            os.writeByte(5);
            os.flush();
            Commands.readBackValue(is, expressionProcesserController, (byte)-1);
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnexpectedExceptionCommandException(false, (Throwable)e);
        }
    }

    public static void sendResumeExpressionCommand(int expressionID, DataOutputStream os, Commands.ValueObject expressionProcessorController) throws CommandException {
        try {
            os.writeByte(19);
            os.writeInt(expressionID);
            os.writeByte(6);
            Commands.writeValue(os, expressionProcessorController, false, false);
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnexpectedExceptionCommandException(false, (Throwable)e);
        }
    }

    private ExpressionCommands() {
    }
}

