/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.edit.action;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.CommandActionHandler;
import org.eclipse.emf.edit.ui.action.ControlAction;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.emf.parsley.edit.action.EditingDomainValidateAction;
import org.eclipse.emf.parsley.edit.action.EmfCommandAction;
import org.eclipse.emf.parsley.edit.action.IMenuContributionSpecification;
import org.eclipse.emf.parsley.edit.action.MenuActionContributionSpecification;
import org.eclipse.emf.parsley.edit.action.MenuCommandActionHandlerContributionSpecification;
import org.eclipse.emf.parsley.edit.action.MenuSeparatorContributionSpecification;
import org.eclipse.emf.parsley.edit.action.MenuSubmenuSpecification;
import org.eclipse.emf.parsley.edit.domain.EditingDomainFinderStrategy;
import org.eclipse.emf.parsley.runtime.util.IAcceptor;
import org.eclipse.emf.parsley.runtime.util.PolymorphicDispatcher;
import org.eclipse.emf.parsley.util.EmfSelectionHelper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;

public class EditingMenuBuilder {
    @Inject
    private EmfSelectionHelper selectionHelper;
    @Inject
    private ILabelProvider labelProvider;
    @Inject
    private EditingDomainFinderStrategy editingDomainFinderStrategy;
    private CommandActionHandler deleteAction;
    private CommandActionHandler cutAction;
    private CommandActionHandler copyAction;
    private CommandActionHandler pasteAction;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private PolymorphicDispatcher<List<IMenuContributionSpecification>> menuContributionsDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"menuContributions", (int)1, (int)1, (Object)this);
    private PolymorphicDispatcher<List<IMenuContributionSpecification>> emfMenuContributionsDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"emfMenuContributions", (int)1, (int)1, (Object)this);
    private List<IMenuContributionSpecification> currentMenuContributions = Collections.emptyList();
    private List<IMenuContributionSpecification> currentEmfMenuContributions = Collections.emptyList();
    private static final List<IMenuContributionSpecification> POLYMORPHIC_NULL_RESULT = new ArrayList<IMenuContributionSpecification>();

    protected List<IMenuContributionSpecification> getCurrentEmfMenuContributions() {
        return this.currentEmfMenuContributions;
    }

    protected List<IMenuContributionSpecification> getCurrentMenuContributions() {
        return this.currentMenuContributions;
    }

    public void setEditingDomainFinderStrategy(EditingDomainFinderStrategy strategy) {
        this.editingDomainFinderStrategy = strategy;
    }

    public void createActions() {
        this.deleteAction = this.createDeleteAction();
        this.cutAction = this.createCutAction();
        this.copyAction = this.createCopyAction();
        this.pasteAction = this.createPasteAction();
        this.undoAction = this.createUndoAction();
        this.redoAction = this.createRedoAction();
    }

    protected EditingDomain getEditingDomain() {
        return this.editingDomainFinderStrategy.getEditingDomain();
    }

    protected void updateEditingDomain(Object object) {
        this.editingDomainFinderStrategy.updateEditingDomain(object);
        this.updateEditingDomainInActions(this.getEditingDomain());
    }

    protected void updateEditingDomainInActions(EditingDomain editingDomain) {
        this.deleteAction.setEditingDomain(editingDomain);
        this.cutAction.setEditingDomain(editingDomain);
        this.copyAction.setEditingDomain(editingDomain);
        this.pasteAction.setEditingDomain(editingDomain);
        this.undoAction.setEditingDomain(editingDomain);
        this.redoAction.setEditingDomain(editingDomain);
    }

    public void updateSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            this.updateMenuContributions((ISelection)structuredSelection);
            for (IMenuContributionSpecification menuContributionSpecification : this.getCurrentMenuContributions()) {
                menuContributionSpecification.updateSelection(structuredSelection);
            }
        }
    }

    public void updateUndoRedo() {
        if (this.getEditingDomain() != null) {
            this.undoAction.update();
            this.redoAction.update();
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        for (IMenuContributionSpecification menuContributionSpecification : this.getCurrentMenuContributions()) {
            menuManager.add(menuContributionSpecification.getContributionItem());
        }
    }

    public void emfMenuAboutToShow(IMenuManager menuManager) {
        for (IMenuContributionSpecification menuContributionSpecification : this.getCurrentEmfMenuContributions()) {
            menuManager.add(menuContributionSpecification.getContributionItem());
        }
    }

    protected void updateMenuContributions(ISelection selection) {
        Object firstSelectedElement = this.selectionHelper.getFirstSelectedElement(selection);
        this.updateEditingDomain(firstSelectedElement);
        if (this.getEditingDomain() == null) {
            this.currentMenuContributions = Collections.emptyList();
            this.currentEmfMenuContributions = Collections.emptyList();
            return;
        }
        this.currentMenuContributions = (List)this.menuContributionsDispatcher.invoke(new Object[]{firstSelectedElement});
        this.currentEmfMenuContributions = (List)this.emfMenuContributionsDispatcher.invoke(new Object[]{firstSelectedElement});
        if (POLYMORPHIC_NULL_RESULT == this.currentEmfMenuContributions) {
            this.currentEmfMenuContributions = (List)this.emfMenuContributionsDispatcher.invoke(new Object[]{selection});
        }
    }

    protected List<IMenuContributionSpecification> menuContributions(Object object) {
        return this.defaultMenuContributions(object);
    }

    protected List<IMenuContributionSpecification> emfMenuContributions(Object object) {
        return POLYMORPHIC_NULL_RESULT;
    }

    protected List<IMenuContributionSpecification> emfMenuContributions(ISelection selection) {
        return this.defaultEmfMenuContributions(selection);
    }

    protected List<IMenuContributionSpecification> defaultMenuContributions(Object object) {
        return Lists.newArrayList((Object[])new IMenuContributionSpecification[]{this.actionUndo(), this.actionRedo(), this.separator(), this.actionCut(), this.actionCopy(), this.actionPaste(), this.separator(), this.actionDelete(), this.separator()});
    }

    protected List<IMenuContributionSpecification> defaultEmfMenuContributions(ISelection selection) {
        return Lists.newArrayList((Object[])new IMenuContributionSpecification[]{this.submenu("&New Child", this.createChildActions(selection)), this.submenu("N&ew Sibling", this.createSiblingActions(selection))});
    }

    protected IMenuContributionSpecification separator() {
        return new MenuSeparatorContributionSpecification();
    }

    protected IMenuContributionSpecification submenu(String text, List<IMenuContributionSpecification> menuContributions) {
        return new MenuSubmenuSpecification(text, menuContributions);
    }

    protected IMenuContributionSpecification actionDelete() {
        return new MenuCommandActionHandlerContributionSpecification(this.deleteAction);
    }

    protected DeleteAction createDeleteAction() {
        return new DeleteAction(true);
    }

    protected IMenuContributionSpecification actionCut() {
        return new MenuCommandActionHandlerContributionSpecification(this.cutAction);
    }

    protected CutAction createCutAction() {
        return new CutAction();
    }

    protected IMenuContributionSpecification actionCopy() {
        return new MenuCommandActionHandlerContributionSpecification(this.copyAction);
    }

    protected CopyAction createCopyAction() {
        return new CopyAction();
    }

    protected IMenuContributionSpecification actionPaste() {
        return new MenuCommandActionHandlerContributionSpecification(this.pasteAction);
    }

    protected PasteAction createPasteAction() {
        return new PasteAction();
    }

    protected IMenuContributionSpecification actionUndo() {
        return new MenuActionContributionSpecification((Action)this.undoAction);
    }

    protected UndoAction createUndoAction() {
        return new UndoAction();
    }

    protected IMenuContributionSpecification actionRedo() {
        return new MenuActionContributionSpecification((Action)this.redoAction);
    }

    protected CommandActionHandler getDeleteAction() {
        return this.deleteAction;
    }

    protected CommandActionHandler getCutAction() {
        return this.cutAction;
    }

    protected CommandActionHandler getCopyAction() {
        return this.copyAction;
    }

    protected CommandActionHandler getPasteAction() {
        return this.pasteAction;
    }

    protected UndoAction getUndoAction() {
        return this.undoAction;
    }

    protected RedoAction getRedoAction() {
        return this.redoAction;
    }

    protected RedoAction createRedoAction() {
        return new RedoAction();
    }

    protected LoadResourceAction createLoadResourceAction() {
        return new LoadResourceAction();
    }

    protected ControlAction createControlAction() {
        return new ControlAction();
    }

    protected EditingDomainValidateAction createValidateAction() {
        return new EditingDomainValidateAction();
    }

    protected <T> IMenuContributionSpecification actionAdd(String text, EList<? super T> list, T value) {
        return this.actionAdd(text, list, value, null);
    }

    protected <T> IMenuContributionSpecification actionAdd(String text, EList<? super T> list, T value, IAcceptor<T> addedObjectInitialier) {
        AddCommand addCommand = this.addCommand(list, value);
        addCommand.setDescription(text);
        return new MenuActionContributionSpecification(new EmfCommandAction<T>(text, this.getEditingDomain(), (Command)addCommand, addedObjectInitialier));
    }

    protected <T> AddCommand addCommand(EList<? super T> list, T value) {
        return new CustomAddCommand<T>(this.getEditingDomain(), list, value);
    }

    protected <T extends Notifier> IMenuContributionSpecification actionChange(String text, T element, IAcceptor<T> changeImplementation) {
        ChangeCommand changeCommand = this.changeCommand(element, changeImplementation);
        changeCommand.setDescription(text);
        return new MenuActionContributionSpecification(new EmfCommandAction(text, this.getEditingDomain(), (Command)changeCommand));
    }

    protected <T extends Notifier> ChangeCommand changeCommand(T element, IAcceptor<T> changeImplementation) {
        return new CustomChangeCommand(element, changeImplementation, null);
    }

    public List<IMenuContributionSpecification> createChildActions(ISelection selection) {
        Collection<?> descriptors = this.getDescriptors(selection, false);
        ArrayList<IMenuContributionSpecification> actions = new ArrayList<IMenuContributionSpecification>();
        for (Object descriptor : descriptors) {
            CreateChildAction act = new CreateChildAction(this.getEditingDomain(), selection, descriptor);
            Image imageObj = this.labelProvider.getImage(((CommandParameter)descriptor).getValue());
            act.setImageDescriptor(ImageDescriptor.createFromImage((Image)imageObj));
            actions.add(new MenuActionContributionSpecification((Action)act));
        }
        return actions;
    }

    public List<IMenuContributionSpecification> createSiblingActions(ISelection selection) {
        Collection<?> descriptors = this.getDescriptors(selection, true);
        ArrayList<IMenuContributionSpecification> actions = new ArrayList<IMenuContributionSpecification>();
        for (Object descriptor : descriptors) {
            CreateSiblingAction act = new CreateSiblingAction(this.getEditingDomain(), selection, descriptor);
            Image imageObj = this.labelProvider.getImage(((CommandParameter)descriptor).getValue());
            act.setImageDescriptor(ImageDescriptor.createFromImage((Image)imageObj));
            actions.add(new MenuActionContributionSpecification((Action)act));
        }
        return actions;
    }

    protected Collection<?> getDescriptors(ISelection selection, boolean siblings) {
        Object firstSelectedElement = this.selectionHelper.getFirstSelectedElement(selection);
        if (this.getEditingDomain() == null) {
            return Collections.emptyList();
        }
        if (siblings) {
            return this.getEditingDomain().getNewChildDescriptors(null, firstSelectedElement);
        }
        return this.getEditingDomain().getNewChildDescriptors(firstSelectedElement, null);
    }

    private static class CustomAddCommand<T>
    extends AddCommand {
        public CustomAddCommand(EditingDomain domain, EList<? super T> list, T value) {
            super(domain, list, value);
        }

        public void doUndo() {
            EObject eContainer = ((EObject)this.collection.iterator().next()).eContainer();
            super.doUndo();
            this.affectedObjects = Collections.singleton(eContainer);
        }
    }

    private static final class CustomChangeCommand<T extends Notifier>
    extends ChangeCommand {
        private final T element;
        private final IAcceptor<T> changeImplementation;

        private CustomChangeCommand(T element, IAcceptor<T> changeImplementation) {
            super(element);
            this.element = element;
            this.changeImplementation = changeImplementation;
        }

        protected void doExecute() {
            this.changeImplementation.accept(this.element);
        }

        public Collection<?> getAffectedObjects() {
            return this.changeDescription.getObjectChanges().keySet();
        }

        /* synthetic */ CustomChangeCommand(Notifier notifier, IAcceptor iAcceptor, CustomChangeCommand customChangeCommand) {
            this(notifier, iAcceptor);
        }
    }
}

