/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.controls;

import javax.inject.Inject;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.editor.controls.ExpectedValueControlRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.stack.model.VStackItem;
import org.eclipse.emf.ecp.view.spi.stack.model.VStackLayout;
import org.eclipse.emf.ecp.view.spi.stack.model.VStackPackage;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class StackItemControlRenderer
extends ExpectedValueControlRenderer {
    @Inject
    public StackItemControlRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding databindingService, EMFFormsLabelProvider labelProvider, VTViewTemplateProvider viewTemplateProvider) {
        super(vElement, viewContext, reportService, databindingService, labelProvider, viewTemplateProvider);
    }

    @Override
    protected void onSelectButton(Label control) {
        VStackItem stackItem;
        try {
            stackItem = (VStackItem)this.getObservedEObject();
        }
        catch (DatabindingFailedException ex) {
            this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return;
        }
        VStackLayout eContainer = (VStackLayout)stackItem.eContainer();
        if (eContainer.getDomainModelReference() == null) {
            MessageDialog.openError((Shell)control.getShell(), (String)"No Feature Path Domain Model Reference found", (String)"A Feature Path Domain Model Reference needs to be added to the Stack Layout first. ");
            return;
        }
        EStructuralFeature structuralFeature = ((VFeaturePathDomainModelReference)eContainer.getDomainModelReference()).getDomainModelEFeature();
        if (structuralFeature == null) {
            MessageDialog.openError((Shell)control.getShell(), (String)"No value selected", (String)"Please set a value to the Domain Model Reference first. ");
            return;
        }
        if (EReference.class.isInstance(structuralFeature)) {
            return;
        }
        Object object = this.getSelectedObject((EAttribute)structuralFeature);
        if (object != null) {
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)stackItem);
            editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)stackItem, (Object)VStackPackage.eINSTANCE.getStackItem_Value(), (Object)object));
            control.setText(object.toString());
        }
    }
}

