/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.shells.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteOutput;

public class SimpleCommandOperation {
    protected IRemoteCmdSubSystem _subsystem;
    protected IRemoteFile _workingDirectory;
    protected IRemoteCommandShell _cmdShell;
    protected List _envVars;
    protected int _outputLineIndex = 0;
    protected boolean _runAsShell = false;

    public SimpleCommandOperation(IRemoteCmdSubSystem subsystem, IRemoteFile workingDirectory, boolean runAsShell) {
        this._subsystem = subsystem;
        this._workingDirectory = workingDirectory;
        this._envVars = new ArrayList();
        this._runAsShell = runAsShell;
    }

    public IRemoteCommandShell getCommandShell() {
        return this._cmdShell;
    }

    public void setEnvironmentVariable(String name, String value) {
        this._envVars.add(String.valueOf(name) + "=" + value);
    }

    public void setEnvironmentVariables(String[] names, String[] values) {
        int i = 0;
        while (i < names.length) {
            this.setEnvironmentVariable(names[i], values[i]);
            ++i;
        }
    }

    public void setEnvironmentVariables(String[] vars) {
        int i = 0;
        while (i < vars.length) {
            this._envVars.add(vars[i]);
            ++i;
        }
    }

    public String[] getEnvironmentVariables() {
        String[] vars = new String[this._envVars.size()];
        int i = 0;
        while (i < vars.length) {
            vars[i] = (String)this._envVars.get(i);
            ++i;
        }
        return vars;
    }

    public void runCommand(String command, boolean exitShell) throws Exception {
        if (this._runAsShell) {
            this._cmdShell = this._subsystem.runShell(this._workingDirectory, null);
            this._subsystem.sendCommandToShell(command, this._cmdShell, (IProgressMonitor)new NullProgressMonitor());
            if (exitShell) {
                this._subsystem.sendCommandToShell("exit", this._cmdShell, (IProgressMonitor)new NullProgressMonitor());
            }
        } else {
            Object[] result = this._subsystem.runCommand(command, this._workingDirectory, false, (IProgressMonitor)new NullProgressMonitor());
            this._cmdShell = (IRemoteCommandShell)result[0];
        }
    }

    public void runCommandInShell(String exports, String command, boolean exitShell) throws Exception {
        this._runAsShell = true;
        this._cmdShell = this._subsystem.runShell(this._workingDirectory, null);
        if (exports != null) {
            this._subsystem.sendCommandToShell(exports, this._cmdShell, (IProgressMonitor)new NullProgressMonitor());
        }
        this._subsystem.sendCommandToShell(command, this._cmdShell, (IProgressMonitor)new NullProgressMonitor());
        if (exitShell) {
            this.exitShell();
        }
    }

    public void removeShell() {
        try {
            this._subsystem.removeShell(this._cmdShell);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void exitShell() {
        if (this._runAsShell) {
            try {
                this._subsystem.sendCommandToShell("exit", this._cmdShell, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void putInput(String input) throws Exception {
        if (this.isActive()) {
            this._subsystem.sendCommandToShell(input, this._cmdShell, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public boolean isActive() {
        if (this._cmdShell != null) {
            return this._cmdShell.isActive();
        }
        return false;
    }

    protected boolean hasMoreOutput() {
        if (this._cmdShell != null) {
            if (this._cmdShell.getSize() > this._outputLineIndex) {
                return true;
            }
            if (this._cmdShell.listOutput().length > this._outputLineIndex) {
                return true;
            }
        }
        return false;
    }

    public void cancelCommand() throws Exception {
        if (this._cmdShell != null && this._cmdShell.isActive()) {
            this._cmdShell.getCommandSubSystem().cancelShell(this._cmdShell, null);
        }
    }

    public String readLine(boolean waitForOutput) {
        if (this._cmdShell != null) {
            Object[] out;
            boolean isActive = true;
            if (!this.hasMoreOutput() && waitForOutput) {
                while (!this.hasMoreOutput() && isActive) {
                    try {
                        isActive = this.isActive();
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if ((out = this._cmdShell.listOutput()).length > this._outputLineIndex) {
                Object output = out[this._outputLineIndex];
                ++this._outputLineIndex;
                if (output instanceof IRemoteOutput) {
                    return ((IRemoteOutput)output).getText();
                }
                if (output instanceof IRemoteFile) {
                    return ((IRemoteFile)output).getLabel();
                }
            } else if (!isActive) {
                return null;
            }
        }
        return "";
    }
}

