/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.debug.ui.views.breakpoints;

import java.util.List;
import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.AbstractWait;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.condition.WidgetIsFound;
import org.eclipse.reddeer.core.matcher.WithMnemonicTextMatcher;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.debug.ui.views.breakpoints.Breakpoint;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.reddeer.jface.wizard.WizardDialog;
import org.eclipse.reddeer.swt.api.Control;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.condition.ControlIsEnabled;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.button.YesButton;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.text.LabeledText;
import org.eclipse.reddeer.swt.impl.toolbar.DefaultToolItem;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.workbench.impl.view.WorkbenchView;
import org.eclipse.swt.widgets.Button;
import org.hamcrest.Matcher;

public class BreakpointsView
extends WorkbenchView {
    public BreakpointsView() {
        super("Breakpoints");
    }

    public void addJavaExceptionBreakpoint(String exception) {
        log.info("Adding java exception breakpoint '" + exception + "'");
        this.open();
        new DefaultToolItem((ReferencedComposite)this.cTabItem.getFolder(), "Add Java Exception Breakpoint").click();
        FilteredItemsSelectionDialog breakpointsDialog = new FilteredItemsSelectionDialog(new Matcher[]{new WithTextMatcher("Add Java Exception Breakpoint")});
        breakpointsDialog.setFilterText(exception);
        new WaitUntil((WaitCondition)new ControlIsEnabled((Control)new OkButton((ReferencedComposite)breakpointsDialog)), TimePeriod.LONG);
        breakpointsDialog.ok();
    }

    public boolean isBreakpointAvailable(String label) {
        this.open();
        return this.getBreakpoint(label) != null;
    }

    public Breakpoint getBreakpoint(String label) {
        log.info("Accessing breakpoints in Breakpoints view");
        this.open();
        AbstractWait.sleep((TimePeriod)TimePeriod.SHORT);
        List items = new DefaultTree((ReferencedComposite)this).getItems();
        for (TreeItem item : items) {
            log.debug("\tfound: " + item.getText());
            if (!item.getText().contains(label)) continue;
            return new Breakpoint(item);
        }
        return null;
    }

    public void removeAllBreakpoints() {
        log.info("Removing all breakpoints from Breakpoints view");
        this.open();
        DefaultToolItem removeBreakpointsItem = new DefaultToolItem((ReferencedComposite)this.cTabItem.getFolder(), "Remove All Breakpoints");
        if (removeBreakpointsItem.isEnabled()) {
            removeBreakpointsItem.click();
            DefaultShell removeBreakpointsShell = new DefaultShell("Remove All Breakpoints");
            WidgetIsFound removeButtonTest = new WidgetIsFound(Button.class, removeBreakpointsShell.getControl(), new Matcher[]{new WithMnemonicTextMatcher("Remove")});
            Object button = removeButtonTest.test() ? new PushButton((Button)removeButtonTest.getResult()) : new YesButton((ReferencedComposite)removeBreakpointsShell);
            button.click();
            new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)removeBreakpointsShell));
        }
    }

    public void importBreakpoints(String path) {
        log.info("Importing breakpoints from '" + path + "'");
        this.open();
        new DefaultTree((ReferencedComposite)this).getContextMenu().getItem(new String[]{"Import Breakpoints..."}).select();
        final WizardDialog importBreakpointsDialog = new WizardDialog("Import Breakpoints");
        importBreakpointsDialog.isOpen();
        new LabeledText((ReferencedComposite)importBreakpointsDialog, "From file:").setText(path);
        new WaitUntil((WaitCondition)new AbstractWaitCondition(){

            public boolean test() {
                return importBreakpointsDialog.isFinishEnabled();
            }
        }, TimePeriod.SHORT, false);
        if (!importBreakpointsDialog.isFinishEnabled()) {
            throw new EclipseLayerException("Finish button is not enabled. Dialog error is '" + importBreakpointsDialog.getMessage() + "'");
        }
        importBreakpointsDialog.finish();
    }
}

