/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.TomcatPublishModuleVisitor;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Context;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.JarResources;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.PostResources;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.PreResources;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.ServerInstance;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;

public class Tomcat85PublishModuleVisitor
extends TomcatPublishModuleVisitor {
    Tomcat85PublishModuleVisitor(IPath baseDir, String tomcatVersion, ServerInstance serverInstance, String sharedLoader, boolean enableMetaInfResources) {
        super(baseDir, tomcatVersion, serverInstance, sharedLoader, enableMetaInfResources);
    }

    @Override
    public void endVisitWebComponent(IVirtualComponent component) throws CoreException {
        boolean dirty = false;
        IModule module = ServerUtil.getModule((IProject)component.getProject());
        Context context = this.findContext(module);
        if (context == null) {
            String name = module != null ? module.getName() : component.getName();
            Trace.trace((byte)2, "Could not find context for module " + name);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPublishContextNotFound, (Object)name), null));
        }
        dirty = this.includeProjectContextXml(component, context);
        dirty = this.updateDocBaseAndPath(component, context);
        for (Object virtualClassClasspathElement : this.virtualClassClasspathElements) {
            PreResources preResources = (PreResources)context.getResources().createElement("PreResources");
            preResources.setClassName("org.apache.catalina.webresources.DirResourceSet");
            preResources.setBase(virtualClassClasspathElement.toString());
            preResources.setWebAppMount("/WEB-INF/classes");
            preResources.setInternalPath("/");
            preResources.setClassLoaderOnly("false");
        }
        this.virtualClassClasspathElements.clear();
        for (Object virtualJarClassClasspathElement : this.virtualJarClasspathElements) {
            String jarPath = virtualJarClassClasspathElement.toString();
            if (jarPath.endsWith(".jar")) {
                JarResources jarResources = (JarResources)context.getResources().createElement("JarResources");
                jarResources.setClassName("org.apache.catalina.webresources.JarResourceSet");
                jarResources.setBase(jarPath);
                jarResources.setWebAppMount("/WEB-INF/classes");
                jarResources.setInternalPath("/");
                jarResources.setClassLoaderOnly("true");
                continue;
            }
            PostResources postResources = (PostResources)context.getResources().createElement("PostResources");
            postResources.setClassName("org.apache.catalina.webresources.DirResourceSet");
            postResources.setBase(jarPath);
            postResources.setWebAppMount("/WEB-INF/classes");
            postResources.setInternalPath("/");
            postResources.setClassLoaderOnly("false");
            File metaInfDir = new File(String.valueOf(jarPath) + "/META-INF");
            if (!metaInfDir.isDirectory() || !metaInfDir.exists()) continue;
            postResources = (PostResources)context.getResources().createElement("PostResources");
            postResources.setClassName("org.apache.catalina.webresources.DirResourceSet");
            postResources.setBase(metaInfDir.getPath());
            postResources.setWebAppMount("/META-INF");
            postResources.setInternalPath("/");
            postResources.setClassLoaderOnly("false");
            File[] tldFiles = metaInfDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().endsWith(".tld");
                }
            });
            int n = 0;
            while (n < tldFiles.length) {
                postResources = (PostResources)context.getResources().createElement("PostResources");
                postResources.setClassName("org.apache.catalina.webresources.FileResourceSet");
                postResources.setBase(tldFiles[0].getPath());
                postResources.setWebAppMount("/WEB-INF/" + tldFiles[0].getName());
                postResources.setInternalPath("/");
                postResources.setClassLoaderOnly("false");
                ++n;
            }
        }
        this.virtualJarClasspathElements.clear();
        HashSet<String> rtPathsProcessed = new HashSet<String>();
        HashSet<String> locationsIncluded = new HashSet<String>();
        String docBase = context.getDocBase();
        locationsIncluded.add(docBase);
        HashMap<String, String> retryLocations = new HashMap<String, String>();
        IVirtualResource[] virtualResources = component.getRootFolder().getResources("");
        int i = 0;
        while (i < virtualResources.length) {
            String string = virtualResources[i].getRuntimePath().toString();
            if (!rtPathsProcessed.contains(string)) {
                if (!"/WEB-INF/classes".equals(string)) {
                    IResource[] underlyingResources = virtualResources[i].getUnderlyingResources();
                    if ("/".equals(string)) {
                        int j = 0;
                        while (j < underlyingResources.length) {
                            IPath resLoc = underlyingResources[j].getLocation();
                            String location = resLoc.toOSString();
                            if (!location.equals(docBase)) {
                                PreResources preResources = (PreResources)context.getResources().createElement("PreResources");
                                preResources.setClassName("org.apache.catalina.webresources.DirResourceSet");
                                preResources.setBase(location);
                                preResources.setWebAppMount("/");
                                preResources.setInternalPath("/");
                                preResources.setClassLoaderOnly("false");
                                locationsIncluded.add(location);
                            }
                            ++j;
                        }
                    } else {
                        int idx = string.lastIndexOf(47);
                        if (idx >= 0) {
                            String lastSegment = string.substring(idx + 1);
                            int j = 0;
                            while (j < underlyingResources.length) {
                                IPath resLoc = underlyingResources[j].getLocation();
                                String location = resLoc.toOSString();
                                if (!lastSegment.equals(resLoc.lastSegment())) {
                                    PreResources preResources = (PreResources)context.getResources().createElement("PreResources");
                                    preResources.setClassName("org.apache.catalina.webresources.DirResourceSet");
                                    preResources.setBase(location);
                                    preResources.setWebAppMount(string);
                                    preResources.setInternalPath("/");
                                    preResources.setClassLoaderOnly("false");
                                    locationsIncluded.add(location);
                                } else {
                                    retryLocations.put(location, string);
                                }
                                ++j;
                            }
                        }
                    }
                }
                rtPathsProcessed.add(string);
            }
            ++i;
        }
        if (!retryLocations.isEmpty()) {
            Iterator<Object> iterator = retryLocations.keySet().iterator();
            block6: while (iterator.hasNext()) {
                String string = (String)iterator.next();
                for (String includedLocation : locationsIncluded) {
                    if (!string.equals(includedLocation) && !string.startsWith(String.valueOf(includedLocation) + File.separator)) continue;
                    iterator.remove();
                    continue block6;
                }
            }
            if (!retryLocations.isEmpty()) {
                for (Map.Entry entry : retryLocations.entrySet()) {
                    String location = (String)entry.getKey();
                    String rtPath = (String)entry.getValue();
                    PreResources preResources = (PreResources)context.getResources().createElement("PreResources");
                    preResources.setClassName("org.apache.catalina.webresources.DirResourceSet");
                    preResources.setBase(location);
                    preResources.setWebAppMount(rtPath);
                    preResources.setInternalPath("/");
                    preResources.setClassLoaderOnly("false");
                }
            }
        }
        if (!this.virtualDependentResources.isEmpty()) {
            for (Map.Entry entry : this.virtualDependentResources.entrySet()) {
                String rtPath = (String)entry.getKey();
                List locations = (List)entry.getValue();
                for (String location : locations) {
                    PostResources postResources = (PostResources)context.getResources().createElement("PostResources");
                    postResources.setClassName("org.apache.catalina.webresources.DirResourceSet");
                    postResources.setBase(location);
                    postResources.setWebAppMount(rtPath.length() > 0 ? rtPath : "/");
                    postResources.setInternalPath("/");
                    postResources.setClassLoaderOnly("false");
                }
            }
        }
        this.virtualDependentResources.clear();
    }
}

