/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.internal.series;

import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.ICircularSeries;
import org.eclipse.swtchart.internal.axis.Axis;
import org.eclipse.swtchart.internal.compress.Compress;
import org.eclipse.swtchart.internal.compress.CompressCircularSeries;
import org.eclipse.swtchart.internal.series.Pie;
import org.eclipse.swtchart.internal.series.Series;
import org.eclipse.swtchart.model.IdNodeDataModel;
import org.eclipse.swtchart.model.Node;

public abstract class CircularSeries
extends Series
implements ICircularSeries {
    protected Chart chart;
    protected IdNodeDataModel model;
    protected Node rootNode;
    protected Node rootPointer;
    protected int maxTreeDepth;
    protected Color borderColor;
    protected int borderWidth;
    protected int highlightLineWidth;
    protected int borderStyle;
    protected Node highlightedNode;
    protected Color highlightColor;

    public CircularSeries(Chart chart, String id) {
        super(chart, id);
        this.chart = chart;
        this.initialise();
        this.model = new IdNodeDataModel(id);
        this.rootNode = this.model.getRootNode();
        this.rootPointer = this.model.getRootPointer();
        this.compressor = this.model.getCompressor();
        this.borderColor = Display.getDefault().getSystemColor(2);
        this.borderWidth = 1;
        this.highlightLineWidth = 3;
        this.borderStyle = 1;
    }

    @Override
    public Color getBorderColor() {
        return this.borderColor;
    }

    @Override
    public int getBorderWidth() {
        return this.borderWidth;
    }

    @Override
    public int getBorderStyle() {
        return this.borderStyle;
    }

    @Override
    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    @Override
    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    @Override
    public void setBorderStyle(int borderStyle) {
        this.borderStyle = borderStyle;
    }

    @Override
    public void setHighlightLineWidth(int width) {
        this.highlightLineWidth = width;
    }

    @Override
    public Compress getCompressor() {
        return (Compress)this.compressor;
    }

    @Override
    public Node getRootNode() {
        return this.rootNode;
    }

    public Node getRootPointer() {
        return this.model.getRootPointer();
    }

    @Override
    public Node getNodeById(String id) {
        return this.model.getTree().get(id);
    }

    @Override
    public List<Node> getSeries() {
        return this.rootNode.getChildren();
    }

    @Override
    public void addNode(String id, double val) {
        this.rootNode.addChild(id, val);
    }

    @Override
    public String[] getLabels() {
        List<Node>[] nodes = this.model.getNodes();
        int tot = 0;
        int index = 0;
        this.maxTreeDepth = this.getRootPointer().getMaxSubTreeDepth() - 1;
        int i = 1;
        while (i <= this.maxTreeDepth) {
            tot += nodes[i].size();
            ++i;
        }
        String[] labels = new String[tot];
        int i2 = 1;
        while (i2 <= this.maxTreeDepth) {
            int len = nodes[i2].size();
            int j = 0;
            while (j != len) {
                labels[index] = nodes[i2].get(j).getId();
                ++index;
                ++j;
            }
            ++i2;
        }
        return labels;
    }

    @Override
    public Color[] getColors() {
        List<Node>[] nodes = this.model.getNodes();
        int tot = 0;
        int ind = 0;
        int i = 1;
        while (i <= this.maxTreeDepth) {
            tot += nodes[i].size();
            ++i;
        }
        Color[] colors = new Color[tot];
        int i2 = 1;
        while (i2 <= this.maxTreeDepth) {
            int len = nodes[i2].size();
            int j = 0;
            while (j != len) {
                colors[ind] = nodes[i2].get(j).getColor();
                ++ind;
                ++j;
            }
            ++i2;
        }
        return colors;
    }

    @Override
    public void setColor(Color[] colors) {
        int length = this.getLabels().length;
        int cfr_ignored_0 = colors.length;
        int i = 0;
        while (i != length) {
            if (colors[i] != null) {
                this.model.getNodeById(this.getLabels()[i]).setColor(colors[i]);
            }
            ++i;
        }
    }

    @Override
    public void setColor(String label, Color color) {
        Node node = this.model.getNodeById(label);
        if (node == null) {
            return;
        }
        node.setColor(color);
    }

    @Override
    public void setSeries(String[] labels, double[] values) {
        int length = labels.length;
        int cfr_ignored_0 = values.length;
        int i = 0;
        while (i != length) {
            new Node(labels[i], values[i], this.rootNode);
            ++i;
        }
        this.model.update();
    }

    @Override
    public Node getHighlightedNode() {
        return this.highlightedNode;
    }

    @Override
    public void setHighlightedNode(Node highlightedNode) {
        if (highlightedNode == null) {
            this.highlightedNode = null;
            return;
        }
        Node ptr = highlightedNode;
        while (ptr != this.getRootPointer() && ptr != this.getRootNode()) {
            ptr = ptr.getParent();
        }
        if (ptr != this.getRootPointer()) {
            return;
        }
        if (this.highlightColor == null) {
            this.highlightColor = Display.getDefault().getSystemColor(2);
        }
        this.highlightedNode = highlightedNode;
    }

    @Override
    public void setHighlightColor(Color color) {
        this.highlightColor = color;
    }

    @Override
    protected void draw(GC gc, int width, int height, Axis xAxis, Axis yAxis) {
        this.setBothAxisRange(width, height, xAxis, yAxis);
        gc.setForeground(this.borderColor);
        gc.setLineStyle(this.borderStyle);
        gc.setLineWidth(this.borderWidth);
        this.drawNode(this.getRootPointer(), gc, xAxis, yAxis);
        if (this.highlightedNode != null && this.highlightColor != null) {
            gc.setForeground(this.highlightColor);
            gc.setLineWidth(this.highlightLineWidth);
            int level = this.highlightedNode.getLevel() - this.getRootPointer().getLevel() + (this instanceof Pie ? 0 : 1);
            int xStart = xAxis.getPixelCoordinate(-level);
            int yStart = yAxis.getPixelCoordinate(level);
            int xWidth = xAxis.getPixelCoordinate(level) - xStart;
            int yWidth = yAxis.getPixelCoordinate(-level) - yStart;
            int angleStart = this.highlightedNode.getAngleBounds().x;
            int angleWidth = this.highlightedNode.getAngleBounds().y;
            gc.drawArc(xStart, yStart, xWidth, yWidth, angleStart, angleWidth);
            if (this.highlightedNode == this.getRootPointer()) {
                return;
            }
            int xParentStart = xAxis.getPixelCoordinate(-level + 1);
            int yParentStart = yAxis.getPixelCoordinate(level - 1);
            int xParentWidth = xAxis.getPixelCoordinate(level - 1) - xParentStart;
            int yParentWidth = yAxis.getPixelCoordinate(-level + 1) - yParentStart;
            gc.drawArc(xParentStart, yParentStart, xParentWidth, yParentWidth, angleStart, angleWidth);
            double xParentStartCoordinate = (double)(level - 1) * Math.cos(Math.toRadians(angleStart));
            double yParentStartCoordinate = (double)(level - 1) * Math.sin(Math.toRadians(angleStart));
            int xParentStartPixelCoordinate = xAxis.getPixelCoordinate(xParentStartCoordinate);
            int yParentStartPixelCoordinate = yAxis.getPixelCoordinate(yParentStartCoordinate);
            double xStartCoordinate = (double)level * Math.cos(Math.toRadians(angleStart));
            double yStartCoordinate = (double)level * Math.sin(Math.toRadians(angleStart));
            int xStartPixelCoordinate = xAxis.getPixelCoordinate(xStartCoordinate);
            int yStartPixelCoordinate = yAxis.getPixelCoordinate(yStartCoordinate);
            gc.drawLine(xParentStartPixelCoordinate, yParentStartPixelCoordinate, xStartPixelCoordinate, yStartPixelCoordinate);
            double xEndCoordinate = (double)level * Math.cos(Math.toRadians(angleStart + angleWidth));
            double yEndCoordinate = (double)level * Math.sin(Math.toRadians(angleStart + angleWidth));
            int xEndPixelCoordinate = xAxis.getPixelCoordinate(xEndCoordinate);
            int yEndPixelCoordinate = yAxis.getPixelCoordinate(yEndCoordinate);
            double xParentEndCoordinate = (double)(level - 1) * Math.cos(Math.toRadians(angleStart + angleWidth));
            double yParentEndCoordinate = (double)(level - 1) * Math.sin(Math.toRadians(angleStart + angleWidth));
            int xParentEndPixelCoordinate = xAxis.getPixelCoordinate(xParentEndCoordinate);
            int yParentEndPixelCoordinate = yAxis.getPixelCoordinate(yParentEndCoordinate);
            gc.drawLine(xParentEndPixelCoordinate, yParentEndPixelCoordinate, xEndPixelCoordinate, yEndPixelCoordinate);
        }
    }

    protected abstract void setBothAxisRange(int var1, int var2, Axis var3, Axis var4);

    protected abstract void drawNode(Node var1, GC var2, Axis var3, Axis var4);

    @Override
    protected void setCompressor() {
        ((CompressCircularSeries)this.compressor).update();
    }

    @Override
    public int getMaxTreeDepth() {
        return this.rootPointer.getMaxSubTreeDepth() - 1;
    }

    private void initialise() {
        IAxis[] axes;
        IAxis[] iAxisArray = axes = this.chart.getAxisSet().getAxes();
        int n = axes.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            axis.getTick().setVisible(false);
            axis.getGrid().setVisible(false);
            axis.getTitle().setVisible(false);
            ++n2;
        }
    }

    @Override
    public IdNodeDataModel getModel() {
        return this.model;
    }

    public void setRootPointer(Node rootPointer) {
        if (this.highlightedNode != null) {
            if (this.highlightedNode == this.getRootPointer()) {
                this.highlightedNode = null;
            }
            Node ptr = this.highlightedNode;
            while (ptr != this.getRootPointer() && ptr != this.getRootNode()) {
                ptr = ptr.getParent();
            }
            if (ptr != this.getRootPointer()) {
                this.highlightedNode = null;
            }
        }
        this.rootPointer = rootPointer;
        this.model.setRootPointer(rootPointer);
    }

    @Override
    public void setDataModel(IdNodeDataModel data) {
        this.model = data;
        this.rootNode = this.model.getRootNode();
        this.rootPointer = this.model.getRootPointer();
        this.maxTreeDepth = this.rootPointer.getMaxSubTreeDepth() - 1;
    }

    @Override
    public double getSlicePercent(String id) {
        Node node = this.getNodeById(id);
        double percent = node.getValue() * 100.0 / this.getRootPointer().getValue();
        return percent;
    }

    @Override
    public Node getPieSliceFromPosition(int x, int y) {
        double primaryX = this.chart.getAxisSet().getXAxis(0).getDataCoordinate(x);
        double primaryY = this.chart.getAxisSet().getXAxis(0).getDataCoordinate(y);
        return this.getPieSliceFromPosition(primaryX, primaryY);
    }
}

