/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.jaxb.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;

public class ToolPaneTypeUtil {
    public static List<String> getArguments(ILaunchConfiguration configuration, String configID) {
        ArrayList<String> arguments = new ArrayList<String>();
        try {
            String controlId = configuration.getAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", "");
            String attributeKey = String.valueOf(controlId) + "." + configID;
            Iterator iterator = configuration.getAttributes().keySet().iterator();
            while (iterator.hasNext()) {
                String key = iterator.next().toString();
                if (!key.startsWith(attributeKey) || key.endsWith("_SAVED")) continue;
                String value = "";
                try {
                    value = configuration.getAttribute(key, "");
                }
                catch (DebugException e) {
                    try {
                        value = Integer.toString(configuration.getAttribute(key, 0));
                    }
                    catch (DebugException debugException) {
                        // empty catch block
                    }
                }
                if (value.trim().isEmpty()) continue;
                arguments.add(value);
                String pairedKey = String.valueOf(key) + "_SAVED";
                if (!configuration.hasAttribute(pairedKey)) continue;
                arguments.add(configuration.getAttribute(pairedKey, ""));
            }
            return arguments;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return arguments;
        }
    }

    public static Map<String, String> getEnvVars(ILaunchConfiguration configuration, String configVarID) {
        HashMap<String, String> envMap = null;
        try {
            String controlId = configuration.getAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", "");
            envMap = new HashMap<String, String>();
            Iterator iterator = configuration.getAttributes().keySet().iterator();
            String keyStartsWith = String.valueOf(controlId) + "." + configVarID;
            while (iterator.hasNext()) {
                String key = iterator.next().toString();
                if (!key.startsWith(keyStartsWith)) continue;
                String value = "";
                if (key.endsWith("MAP")) {
                    Map map = configuration.getAttribute(key, new HashMap());
                    for (Object envKey : map.keySet()) {
                        Object envValue = map.get(envKey);
                        envMap.put(envKey.toString().trim(), envValue.toString().trim());
                    }
                    continue;
                }
                String mapKey = key.replace(keyStartsWith, "");
                try {
                    value = configuration.getAttribute(key, "");
                }
                catch (DebugException e) {
                    try {
                        value = Integer.toString(configuration.getAttribute(key, 0));
                    }
                    catch (DebugException debugException) {
                        // empty catch block
                    }
                }
                if (value == null || value.trim().length() <= 0) continue;
                envMap.put(mapKey, value);
            }
            return envMap;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }
}

