/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core;

import java.net.MalformedURLException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.client.TracException;
import org.eclipse.mylyn.internal.trac.core.client.TracLoginException;
import org.eclipse.mylyn.internal.trac.core.client.TracWebClient;
import org.eclipse.mylyn.internal.trac.core.client.TracXmlRpcClient;

public class TracClientFactory {
    public static ITracClient createClient(AbstractWebLocation location, ITracClient.Version version) {
        if (version == ITracClient.Version.TRAC_0_9) {
            return new TracWebClient(location, version);
        }
        if (version == ITracClient.Version.XML_RPC) {
            return new TracXmlRpcClient(location, version);
        }
        return new TracXmlRpcClient(location, ITracClient.Version.XML_RPC);
    }

    public static ITracClient.Version probeClient(AbstractWebLocation location) throws MalformedURLException, TracException {
        try {
            TracXmlRpcClient repository = new TracXmlRpcClient(location, ITracClient.Version.XML_RPC);
            repository.validate((IProgressMonitor)new NullProgressMonitor());
            return ITracClient.Version.XML_RPC;
        }
        catch (TracException e) {
            try {
                TracWebClient repository = new TracWebClient(location, ITracClient.Version.TRAC_0_9);
                repository.validate((IProgressMonitor)new NullProgressMonitor());
                return ITracClient.Version.TRAC_0_9;
            }
            catch (TracLoginException e2) {
                throw e;
            }
            catch (TracException tracException) {
                throw new TracException();
            }
        }
    }
}

