/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.common.core.internal.extensions;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.modisco.infra.common.core.internal.CommonModiscoActivator;
import org.eclipse.modisco.infra.common.core.internal.Messages;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractRegistry {
    protected void initialize() {
        IExtension[] extensions;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(this.getExtensionPointNamespace(), this.getExtensionPointName());
        if (extensionPoint == null) {
            MoDiscoLogger.logError("Extension point not found:" + this.getExtensionPointNamespace() + "." + this.getExtensionPointName(), (Plugin)CommonModiscoActivator.getDefault());
            return;
        }
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configurationElements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configurationElements = extension.getConfigurationElements();
            int n3 = configurationElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                this.handleRootElement(configurationElement);
                ++n4;
            }
            ++n2;
        }
    }

    protected abstract String getExtensionPointNamespace();

    protected abstract String getExtensionPointName();

    protected abstract void handleRootElement(IConfigurationElement var1);

    protected void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        StringBuffer buf = new StringBuffer();
        buf.append(NLS.bind((String)Messages.AbstractRegistry_pluginExtension, (Object)extension.getNamespaceIdentifier(), (Object)extension.getExtensionPointUniqueIdentifier()));
        String id = element.getAttribute("id");
        if (id != null) {
            buf.append(Messages.AbstractRegistry_id);
            buf.append(id);
        }
        buf.append(String.valueOf(Messages.AbstractRegistry_colon) + text);
        MoDiscoLogger.logError(buf.toString(), (Plugin)CommonModiscoActivator.getDefault());
    }

    protected void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.logError(element, NLS.bind((String)Messages.AbstractRegistry_requiredAttributeNotDefined, (Object)attributeName));
    }

    protected void logUnknownElement(IConfigurationElement element) {
        this.logError(element, String.valueOf(Messages.AbstractRegistry_unknownExtensionTag) + element.getName());
    }
}

