/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import org.eclipse.mat.report.internal.Messages;
import org.eclipse.mat.util.IProgressListener;

public class ConsoleProgressListener
implements IProgressListener {
    private PrintWriter out;
    private boolean isDone = false;
    private int workPerDot;
    private int workAccumulated;
    private int dotsPrinted;

    public ConsoleProgressListener(OutputStream out) {
        this(new PrintWriter(out));
    }

    public ConsoleProgressListener(PrintWriter out) {
        this.out = out;
    }

    @Override
    public void beginTask(String name, int totalWork) {
        this.out.write(String.valueOf(Messages.ConsoleProgressListener_Label_Task) + " " + name + "\n");
        this.out.write("[");
        this.workPerDot = totalWork > 80 ? totalWork / 80 : 1;
        this.workAccumulated = 0;
        this.dotsPrinted = 0;
        this.out.flush();
    }

    @Override
    public void done() {
        if (!this.isDone) {
            this.out.write("]\n");
            this.out.flush();
            this.isDone = true;
        }
    }

    @Override
    public boolean isCanceled() {
        return false;
    }

    @Override
    public void setCanceled(boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void subTask(String name) {
        this.out.write("\n" + Messages.ConsoleProgressListener_Label_Subtask + " " + name + "\n[");
        int ii = 0;
        while (ii < this.dotsPrinted) {
            this.out.write(".");
            ++ii;
        }
        this.out.flush();
    }

    @Override
    public void worked(int work) {
        this.workAccumulated += work;
        int dotsToPrint = this.workAccumulated / this.workPerDot;
        if (dotsToPrint > 0) {
            this.dotsPrinted += dotsToPrint;
            int ii = 0;
            while (ii < dotsToPrint) {
                this.out.write(".");
                ++ii;
            }
            this.workAccumulated -= dotsToPrint * this.workPerDot;
            this.out.flush();
        }
    }

    @Override
    public void sendUserMessage(IProgressListener.Severity severity, String message, Throwable exception) {
        this.out.write("\n");
        switch (severity) {
            case INFO: {
                this.out.write("[INFO] ");
                break;
            }
            case WARNING: {
                this.out.write("[WARNING] ");
                break;
            }
            case ERROR: {
                this.out.write("[ERROR] ");
                break;
            }
            default: {
                this.out.write("[UNKNOWN] ");
            }
        }
        this.out.write(message);
        if (exception != null) {
            this.out.write("\n");
            exception.printStackTrace(this.out);
        }
        this.out.write("\n[");
        int ii = 0;
        while (ii < this.dotsPrinted) {
            this.out.write(".");
            ++ii;
        }
    }
}

