/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view;

import java.util.List;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.DataModelInitializedEvent;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.MulticoreVisualizerUIPlugin;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerCore;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerExecutionState;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerModel;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerThread;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizer;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizerCanvas;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils.DSFDebugModel;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcessDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIRunControl;
import org.eclipse.cdt.dsf.mi.service.command.events.IMIDMEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MISignalEvent;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;

public class MulticoreVisualizerEventListener {
    private static final String THE_THREAD_ID_DOES_NOT_CONVERT_TO_AN_INTEGER = "The thread id does not convert to an integer: ";
    protected MulticoreVisualizer fVisualizer;

    public MulticoreVisualizerEventListener(MulticoreVisualizer visualizer) {
        this.fVisualizer = visualizer;
    }

    @DsfServiceEventHandler
    public void handleEvent(final IRunControl.ISuspendedDMEvent event) {
        final VisualizerModel model = this.fVisualizer.getModel();
        if (model == null) {
            return;
        }
        IDMContext context = event.getDMContext();
        if (context != null && this.isSessionAllStop(context.getSessionId())) {
            this.fVisualizer.update();
            return;
        }
        if (!(context instanceof IRunControl.IContainerDMContext) && context instanceof IMIExecutionDMContext) {
            final IMIExecutionDMContext execDmc = (IMIExecutionDMContext)context;
            IProcesses.IThreadDMContext threadContext = (IProcesses.IThreadDMContext)DMContexts.getAncestorOfType((IDMContext)execDmc, IProcesses.IThreadDMContext.class);
            DsfServicesTracker tracker = new DsfServicesTracker(MulticoreVisualizerUIPlugin.getBundleContext(), execDmc.getSessionId());
            IProcesses procService = (IProcesses)tracker.getService(IProcesses.class);
            final IStack stackService = (IStack)tracker.getService(IStack.class);
            tracker.dispose();
            procService.getExecutionData(threadContext, (DataRequestMonitor)new ImmediateDataRequestMonitor<IProcesses.IThreadDMData>(){

                protected void handleSuccess() {
                    String[] cores;
                    IProcesses.IThreadDMData data = (IProcesses.IThreadDMData)this.getData();
                    if (data instanceof IGDBProcesses.IGdbThreadDMData && (cores = ((IGDBProcesses.IGdbThreadDMData)data).getCores()) != null) {
                        if (!$assertionsDisabled && cores.length != 1) {
                            throw new AssertionError();
                        }
                        int coreId = Integer.parseInt(cores[0]);
                        final VisualizerCore vCore = model.getCore(coreId);
                        VisualizerThread threadTmp = null;
                        try {
                            int tid = Integer.parseInt(execDmc.getThreadId());
                            threadTmp = model.getThread(tid);
                        }
                        catch (NumberFormatException e) {
                            if (!$assertionsDisabled) {
                                throw new AssertionError((Object)(MulticoreVisualizerEventListener.THE_THREAD_ID_DOES_NOT_CONVERT_TO_AN_INTEGER + execDmc.getThreadId()));
                            }
                            return;
                        }
                        if (threadTmp != null) {
                            String signalName;
                            Object miEvent;
                            final VisualizerThread thread = threadTmp;
                            if (!$assertionsDisabled && thread.getState() != VisualizerExecutionState.RUNNING) {
                                throw new AssertionError();
                            }
                            VisualizerExecutionState _newState = VisualizerExecutionState.SUSPENDED;
                            if (event.getReason() == IRunControl.StateChangeReason.SIGNAL && event instanceof IMIDMEvent && (miEvent = ((IMIDMEvent)event).getMIEvent()) instanceof MISignalEvent && DSFDebugModel.isCrashSignal(signalName = ((MISignalEvent)miEvent).getName())) {
                                _newState = VisualizerExecutionState.CRASHED;
                            }
                            final VisualizerExecutionState newState = _newState;
                            if (stackService != null) {
                                stackService.getTopFrame((IDMContext)execDmc, (DataRequestMonitor)new ImmediateDataRequestMonitor<IStack.IFrameDMContext>(null){

                                    protected void handleCompleted() {
                                        IStack.IFrameDMContext targetFrameContext = null;
                                        if (this.isSuccess()) {
                                            targetFrameContext = (IStack.IFrameDMContext)this.getData();
                                        }
                                        if (targetFrameContext != null) {
                                            stackService.getFrameData(targetFrameContext, (DataRequestMonitor)new ImmediateDataRequestMonitor<IStack.IFrameDMData>(null){

                                                protected void handleCompleted() {
                                                    IStack.IFrameDMData frameData = null;
                                                    if (this.isSuccess()) {
                                                        frameData = (IStack.IFrameDMData)this.getData();
                                                    }
                                                    MulticoreVisualizerEventListener.this.updateThread(thread, newState, vCore, frameData);
                                                }
                                            });
                                        } else {
                                            MulticoreVisualizerEventListener.this.updateThread(thread, newState, vCore, null);
                                        }
                                    }
                                });
                            } else {
                                MulticoreVisualizerEventListener.this.updateThread(thread, newState, vCore, null);
                            }
                        }
                    }
                }
            });
        }
    }

    private void updateThread(VisualizerThread thread, VisualizerExecutionState newState, VisualizerCore vCore, IStack.IFrameDMData frameData) {
        thread.setState(newState);
        thread.setCore(vCore);
        thread.setLocationInfo(frameData);
        this.fVisualizer.refresh();
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.IResumedDMEvent event) {
        VisualizerModel model = this.fVisualizer.getModel();
        if (model == null) {
            return;
        }
        IDMContext context = event.getDMContext();
        if (context != null && this.isSessionAllStop(context.getSessionId())) {
            List<VisualizerThread> tList = model.getThreads();
            for (VisualizerThread t : tList) {
                t.setState(VisualizerExecutionState.RUNNING);
                t.setLocationInfo((String)null);
            }
            this.fVisualizer.getMulticoreVisualizerCanvas().requestUpdate();
            return;
        }
        if (!(context instanceof IRunControl.IContainerDMContext) && context instanceof IMIExecutionDMContext) {
            VisualizerThread thread = null;
            String strThreadId = ((IMIExecutionDMContext)context).getThreadId();
            try {
                int tid = Integer.parseInt(strThreadId);
                thread = model.getThread(tid);
            }
            catch (NumberFormatException e) {
                assert (false) : "The thread id does not convert to an integer: " + strThreadId;
                return;
            }
            if (thread != null) {
                assert (thread.getState() == VisualizerExecutionState.SUSPENDED || thread.getState() == VisualizerExecutionState.CRASHED);
                thread.setState(VisualizerExecutionState.RUNNING);
                thread.setLocationInfo((String)null);
                this.fVisualizer.getMulticoreVisualizerCanvas().requestUpdate();
            }
        }
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.IStartedDMEvent event) {
        final VisualizerModel model = this.fVisualizer.getModel();
        if (model == null) {
            return;
        }
        IDMContext context = event.getDMContext();
        if (context == null) {
            return;
        }
        String sessionId = context.getSessionId();
        if (this.isSessionAllStop(sessionId) && context instanceof IMIExecutionDMContext) {
            int tid;
            IMIExecutionDMContext execDmc = (IMIExecutionDMContext)context;
            IMIProcessDMContext processContext = (IMIProcessDMContext)DMContexts.getAncestorOfType((IDMContext)execDmc, IMIProcessDMContext.class);
            VisualizerCore vCore = model.getCore(0);
            if (vCore == null) {
                return;
            }
            int pid = Integer.parseInt(processContext.getProcId());
            try {
                tid = Integer.parseInt(execDmc.getThreadId());
            }
            catch (NumberFormatException e) {
                assert (false) : "The thread id does not convert to an integer: " + execDmc.getThreadId();
                return;
            }
            int osTid = 0;
            if (model.getThread(tid) == null) {
                model.addThread(new VisualizerThread(vCore, pid, osTid, tid, VisualizerExecutionState.RUNNING));
                this.fVisualizer.getMulticoreVisualizerCanvas().requestUpdate();
            }
            return;
        }
        if (!(context instanceof IRunControl.IContainerDMContext) && context instanceof IMIExecutionDMContext) {
            final IMIExecutionDMContext execDmc = (IMIExecutionDMContext)context;
            final IMIProcessDMContext processContext = (IMIProcessDMContext)DMContexts.getAncestorOfType((IDMContext)execDmc, IMIProcessDMContext.class);
            IProcesses.IThreadDMContext threadContext = (IProcesses.IThreadDMContext)DMContexts.getAncestorOfType((IDMContext)execDmc, IProcesses.IThreadDMContext.class);
            DsfServicesTracker tracker = new DsfServicesTracker(MulticoreVisualizerUIPlugin.getBundleContext(), sessionId);
            IProcesses procService = (IProcesses)tracker.getService(IProcesses.class);
            tracker.dispose();
            procService.getExecutionData(threadContext, (DataRequestMonitor)new ImmediateDataRequestMonitor<IProcesses.IThreadDMData>(){

                protected void handleSuccess() {
                    String[] cores;
                    IProcesses.IThreadDMData data = (IProcesses.IThreadDMData)this.getData();
                    if (data instanceof IGDBProcesses.IGdbThreadDMData && (cores = ((IGDBProcesses.IGdbThreadDMData)data).getCores()) != null) {
                        int tid;
                        if (!$assertionsDisabled && cores.length != 1) {
                            throw new AssertionError();
                        }
                        int coreId = Integer.parseInt(cores[0]);
                        VisualizerCore vCore = model.getCore(coreId);
                        if (vCore == null) {
                            return;
                        }
                        int pid = Integer.parseInt(processContext.getProcId());
                        try {
                            tid = Integer.parseInt(execDmc.getThreadId());
                        }
                        catch (NumberFormatException e) {
                            if (!$assertionsDisabled) {
                                throw new AssertionError((Object)(MulticoreVisualizerEventListener.THE_THREAD_ID_DOES_NOT_CONVERT_TO_AN_INTEGER + execDmc.getThreadId()));
                            }
                            return;
                        }
                        int osTid = 0;
                        try {
                            osTid = Integer.parseInt(data.getId());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (model.getThread(tid) == null) {
                            model.addThread(new VisualizerThread(vCore, pid, osTid, tid, VisualizerExecutionState.RUNNING));
                            MulticoreVisualizerEventListener.this.fVisualizer.getMulticoreVisualizerCanvas().requestUpdate();
                        }
                    }
                }
            });
        }
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.IExitedDMEvent event) {
        final VisualizerModel model = this.fVisualizer.getModel();
        if (model == null) {
            return;
        }
        IDMContext context = event.getDMContext();
        final MulticoreVisualizerCanvas canvas = this.fVisualizer.getMulticoreVisualizerCanvas();
        if (context instanceof IRunControl.IContainerDMContext) {
            DsfServicesTracker tracker = new DsfServicesTracker(MulticoreVisualizerUIPlugin.getBundleContext(), context.getSessionId());
            IProcesses procService = (IProcesses)tracker.getService(IProcesses.class);
            tracker.dispose();
            procService.getProcessesBeingDebugged(context, (DataRequestMonitor)new ImmediateDataRequestMonitor<IDMContext[]>(){

                protected void handleSuccess() {
                    IDMContext[] contexts;
                    if (!$assertionsDisabled && this.getData() == null) {
                        throw new AssertionError();
                    }
                    IDMContext[] iDMContextArray = contexts = (IDMContext[])this.getData();
                    int n = contexts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block7: {
                            IDMContext c = iDMContextArray[n2];
                            if (c instanceof IMIExecutionDMContext) {
                                int tid;
                                String strThreadId = ((IMIExecutionDMContext)c).getThreadId();
                                try {
                                    tid = Integer.parseInt(strThreadId);
                                }
                                catch (NumberFormatException e) {
                                    if (!$assertionsDisabled) {
                                        throw new AssertionError((Object)(MulticoreVisualizerEventListener.THE_THREAD_ID_DOES_NOT_CONVERT_TO_AN_INTEGER + strThreadId));
                                    }
                                    break block7;
                                }
                                model.markThreadExited(tid);
                            }
                        }
                        ++n2;
                    }
                    if (canvas != null) {
                        canvas.requestUpdate();
                    }
                }

                protected void handleFailure() {
                }
            });
        } else if (context instanceof IMIExecutionDMContext) {
            block7: {
                String strThreadId = ((IMIExecutionDMContext)context).getThreadId();
                try {
                    int tid = Integer.parseInt(strThreadId);
                    model.markThreadExited(tid);
                }
                catch (NumberFormatException e) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError((Object)(THE_THREAD_ID_DOES_NOT_CONVERT_TO_AN_INTEGER + strThreadId));
                }
            }
            if (canvas != null) {
                canvas.requestUpdate();
            }
        }
    }

    @DsfServiceEventHandler
    public void handleEvent(DataModelInitializedEvent event) {
        this.fVisualizer.update();
    }

    private boolean isSessionAllStop(String sessionId) {
        DsfServicesTracker servicesTracker = new DsfServicesTracker(MulticoreVisualizerUIPlugin.getBundleContext(), sessionId);
        IMIRunControl runCtrlService = (IMIRunControl)servicesTracker.getService(IMIRunControl.class);
        servicesTracker.dispose();
        return runCtrlService != null && runCtrlService.getRunMode() == IMIRunControl.MIRunMode.ALL_STOP;
    }
}

