/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISynchronizer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.core.resources.SyncInfoCache;
import org.eclipse.team.internal.ccvs.core.resources.SynchronizerSyncInfoCache;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.FileNameMatcher;
import org.eclipse.team.internal.ccvs.core.util.SyncFileWriter;

class SessionPropertySyncInfoCache
extends SyncInfoCache
implements ISaveParticipant {
    private static final QualifiedName RESOURCE_SYNC_CACHED_KEY = new QualifiedName("org.eclipse.team.cvs.core", "resource-sync-cached");
    private static final Object RESOURCE_SYNC_CACHED = new Object();
    static final FileNameMatcher NULL_IGNORES = new FileNameMatcher();
    private static final FolderSyncInfo NULL_FOLDER_SYNC_INFO = new FolderSyncInfo("dummy-repo", "dummy-root", null, false);
    private QualifiedName FOLDER_DIRTY_STATE_KEY = new QualifiedName("org.eclipse.team.cvs.core", "folder-dirty-state-cached");
    private SynchronizerSyncInfoCache synchronizerCache;

    SessionPropertySyncInfoCache(SynchronizerSyncInfoCache synchronizerCache) {
        this.synchronizerCache = synchronizerCache;
        try {
            ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)CVSProviderPlugin.getPlugin(), (ISaveParticipant)this);
            ISynchronizer synchronizer = ResourcesPlugin.getWorkspace().getSynchronizer();
            synchronizer.add(this.FOLDER_DIRTY_STATE_KEY);
        }
        catch (CoreException e) {
            CVSProviderPlugin.log(e);
        }
    }

    FileNameMatcher getFolderIgnores(IContainer container, boolean threadSafeAccess) throws CVSException {
        FileNameMatcher matcher = (FileNameMatcher)this.safeGetSessionProperty((IResource)container, IGNORE_SYNC_KEY);
        if (threadSafeAccess && matcher == null) {
            String[] ignores = SyncFileWriter.readCVSIgnoreEntries(container);
            matcher = ignores == null ? NULL_IGNORES : new FileNameMatcher(ignores);
            this.safeSetSessionProperty((IResource)container, IGNORE_SYNC_KEY, matcher);
        }
        return matcher;
    }

    boolean isIgnoresCached(IContainer container) throws CVSException {
        return this.safeGetSessionProperty((IResource)container, IGNORE_SYNC_KEY) != null;
    }

    @Override
    boolean isFolderSyncInfoCached(IContainer container) throws CVSException {
        Object info = this.safeGetSessionProperty((IResource)container, FOLDER_SYNC_KEY);
        if (info == null) {
            info = this.synchronizerCache.getCachedFolderSync(container, true);
        }
        return info != null;
    }

    @Override
    boolean isResourceSyncInfoCached(IContainer container) throws CVSException {
        return this.safeGetSessionProperty((IResource)container, RESOURCE_SYNC_CACHED_KEY) != null;
    }

    @Override
    void setResourceSyncInfoCached(IContainer container) throws CVSException {
        this.safeSetSessionProperty((IResource)container, RESOURCE_SYNC_CACHED_KEY, RESOURCE_SYNC_CACHED);
    }

    @Override
    FolderSyncInfo getCachedFolderSync(IContainer container, boolean threadSafeAccess) throws CVSException {
        FolderSyncInfo info = (FolderSyncInfo)this.safeGetSessionProperty((IResource)container, FOLDER_SYNC_KEY);
        if (!threadSafeAccess) {
            return info == NULL_FOLDER_SYNC_INFO ? null : info;
        }
        if (info == null && (info = this.synchronizerCache.getCachedFolderSync(container, true)) != null) {
            this.safeSetSessionProperty((IResource)container, FOLDER_SYNC_KEY, info);
        }
        if (info == null && container.exists() && !container.isDerived()) {
            CVSStatus status = new CVSStatus(4, 4, NLS.bind((String)CVSMessages.EclipseSynchronizer_folderSyncInfoMissing, (Object[])new String[]{container.getFullPath().toString()}), (IResource)container);
            throw new CVSException((IStatus)status);
        }
        if (info == NULL_FOLDER_SYNC_INFO) {
            return null;
        }
        return info;
    }

    IResource[] purgeCache(IContainer container, boolean deep) throws CVSException {
        if (!container.exists()) {
            return new IResource[0];
        }
        try {
            IResource[] members;
            HashSet<Object> flushed = new HashSet<Object>();
            if (container.getType() != 8) {
                this.safeSetSessionProperty((IResource)container, IGNORE_SYNC_KEY, null);
                this.safeSetSessionProperty((IResource)container, FOLDER_SYNC_KEY, null);
                this.safeSetSessionProperty((IResource)container, RESOURCE_SYNC_CACHED_KEY, null);
                flushed.add(container);
                EclipseSynchronizer.getInstance().adjustDirtyStateRecursively((IResource)container, "r");
            }
            IResource[] iResourceArray = members = container.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                this.purgeResourceSyncCache(resource);
                flushed.add(resource);
                if (deep && resource.getType() != 1) {
                    IResource[] flushedChildren = this.purgeCache((IContainer)resource, deep);
                    flushed.addAll(Arrays.asList(flushedChildren));
                }
                ++n2;
            }
            return flushed.toArray(new IResource[flushed.size()]);
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
    }

    void purgeResourceSyncCache(IResource resource) throws CVSException {
        this.safeSetSessionProperty(resource, RESOURCE_SYNC_KEY, null);
        EclipseSynchronizer.getInstance().adjustDirtyStateRecursively(resource, "r");
    }

    void setCachedFolderIgnores(IContainer container, String[] ignores) throws CVSException {
        this.safeSetSessionProperty((IResource)container, IGNORE_SYNC_KEY, new FileNameMatcher(ignores));
    }

    @Override
    void setCachedFolderSync(IContainer container, FolderSyncInfo info, boolean canModifyWorkspace) throws CVSException {
        if (!container.exists()) {
            return;
        }
        if (info == null) {
            info = NULL_FOLDER_SYNC_INFO;
        }
        this.safeSetSessionProperty((IResource)container, FOLDER_SYNC_KEY, info);
        if (canModifyWorkspace && this.synchronizerCache.getCachedFolderSync(container, true) != null) {
            this.synchronizerCache.setCachedFolderSync(container, null, true);
        }
    }

    @Override
    void setDirtyIndicator(IResource resource, String indicator) throws CVSException {
        if (resource.getType() == 1) {
            this.internalSetDirtyIndicator((IFile)resource, indicator);
        } else {
            this.internalSetDirtyIndicator((IContainer)resource, indicator);
        }
    }

    @Override
    String getDirtyIndicator(IResource resource, boolean threadSafeAccess) throws CVSException {
        if (resource.getType() == 1) {
            return this.internalGetDirtyIndicator((IFile)resource, threadSafeAccess);
        }
        return this.internalGetDirtyIndicator((IContainer)resource, threadSafeAccess);
    }

    private void internalSetDirtyIndicator(IFile file, String indicator) throws CVSException {
        this.safeSetSessionProperty((IResource)file, IS_DIRTY, indicator);
    }

    private String internalGetDirtyIndicator(IFile file, boolean threadSafeAccess) throws CVSException {
        String di = (String)this.safeGetSessionProperty((IResource)file, IS_DIRTY);
        if (di == null) {
            di = "r";
        }
        return di;
    }

    private void internalSetDirtyIndicator(IContainer container, String indicator) throws CVSException {
        this.safeSetSessionProperty((IResource)container, IS_DIRTY, indicator);
    }

    private String internalGetDirtyIndicator(IContainer container, boolean threadSafeAccess) throws CVSException {
        try {
            String di;
            block13: {
                block16: {
                    block14: {
                        di = (String)this.safeGetSessionProperty((IResource)container, IS_DIRTY);
                        if (di != null) break block13;
                        byte[] diBytes = ResourcesPlugin.getWorkspace().getSynchronizer().getSyncInfo(this.FOLDER_DIRTY_STATE_KEY, (IResource)container);
                        if (diBytes == null || CVSProviderPlugin.getPlugin().crashOnLastRun()) break block14;
                        switch (di = new String(diBytes)) {
                            case "c": {
                                di = "c";
                                break;
                            }
                            case "d": {
                                di = "d";
                                break;
                            }
                            default: {
                                di = "r";
                                break;
                            }
                        }
                        break block16;
                    }
                    di = "r";
                }
                if (threadSafeAccess) {
                    this.setDirtyIndicator((IResource)container, di);
                }
            }
            return di;
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
    }

    @Override
    void flushDirtyCache(IResource resource) throws CVSException {
        if (resource.exists()) {
            if (resource.getType() == 1) {
                this.safeSetSessionProperty(resource, IS_DIRTY, null);
            } else {
                this.safeSetSessionProperty(resource, IS_DIRTY, null);
                this.flushDirtyStateFromDisk((IContainer)resource);
            }
        }
    }

    @Override
    boolean isSyncInfoLoaded(IContainer parent) throws CVSException {
        if (parent.getFolder((IPath)new Path("CVS")).exists()) {
            if (this.safeGetSessionProperty((IResource)parent, RESOURCE_SYNC_CACHED_KEY) == null) {
                return false;
            }
            if (this.safeGetSessionProperty((IResource)parent, FOLDER_SYNC_KEY) == null) {
                return false;
            }
        }
        return true;
    }

    @Override
    byte[] getCachedSyncBytes(IResource resource, boolean threadSafeAccess) throws CVSException {
        byte[] bytes = (byte[])this.safeGetSessionProperty(resource, RESOURCE_SYNC_KEY);
        if (!threadSafeAccess) {
            return bytes;
        }
        if (bytes == null && (bytes = this.synchronizerCache.getCachedSyncBytes(resource, true)) != null) {
            boolean genderChange = false;
            if (resource.getType() == 1) {
                if (ResourceSyncInfo.isFolder(bytes)) {
                    genderChange = true;
                }
            } else if (!ResourceSyncInfo.isFolder(bytes)) {
                genderChange = true;
            }
            if (genderChange) {
                bytes = null;
            } else {
                this.safeSetSessionProperty(resource, RESOURCE_SYNC_KEY, ResourceSyncInfo.convertFromDeletion(bytes));
            }
        }
        return bytes;
    }

    Object safeGetSessionProperty(IResource resource, QualifiedName key) throws CVSException {
        try {
            return resource.getSessionProperty(key);
        }
        catch (CoreException e) {
            int code;
            IStatus status = e.getStatus();
            if (status != null && ((code = e.getStatus().getCode()) != 369 || code != 368)) {
                return null;
            }
            throw CVSException.wrapException(e);
        }
    }

    void safeSetSessionProperty(IResource resource, QualifiedName key, Object value) throws CVSException {
        try {
            resource.setSessionProperty(key, value);
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
    }

    @Override
    void setCachedSyncBytes(IResource resource, byte[] syncBytes, boolean canModifyWorkspace) throws CVSException {
        if (syncBytes != null && ResourceSyncInfo.isDeletion(syncBytes)) {
            syncBytes = ResourceSyncInfo.convertFromDeletion(syncBytes);
        }
        this.safeSetSessionProperty(resource, RESOURCE_SYNC_KEY, syncBytes);
        if (canModifyWorkspace && this.synchronizerCache.getCachedSyncBytes(resource, true) != null) {
            this.synchronizerCache.setCachedSyncBytes(resource, null, canModifyWorkspace);
        }
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) throws CoreException {
        boolean projectSave;
        boolean fullSave = context.getKind() == 1;
        boolean bl = projectSave = context.getKind() == 3;
        if (projectSave || fullSave) {
            final ISynchronizer synchronizer = ResourcesPlugin.getWorkspace().getSynchronizer();
            IProject[] projects = projectSave ? new IProject[]{context.getProject()} : ResourcesPlugin.getWorkspace().getRoot().getProjects();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId());
                if (provider != null) {
                    project.accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            if (resource.getType() != 1) {
                                String di = null;
                                try {
                                    di = SessionPropertySyncInfoCache.this.getDirtyIndicator(resource, true);
                                }
                                catch (CVSException e) {
                                    CVSProviderPlugin.log((CoreException)((Object)e));
                                }
                                if (di != null) {
                                    synchronizer.setSyncInfo(SessionPropertySyncInfoCache.this.FOLDER_DIRTY_STATE_KEY, resource, di.getBytes());
                                }
                            }
                            return true;
                        }
                    });
                }
                ++n2;
            }
        }
    }

    private void flushDirtyStateFromDisk(IContainer container) {
        ISynchronizer synchronizer = ResourcesPlugin.getWorkspace().getSynchronizer();
        try {
            synchronizer.flushSyncInfo(this.FOLDER_DIRTY_STATE_KEY, (IResource)container, 2);
        }
        catch (CoreException e) {
            CVSProviderPlugin.log(e);
        }
    }

    void purgeDirtyCache(IResource resource) throws CVSException {
        if (!resource.exists()) {
            return;
        }
        try {
            if (resource.getType() != 8) {
                this.safeSetSessionProperty(resource, IS_DIRTY, null);
            }
            if (resource.getType() != 1) {
                IResource[] members;
                ResourcesPlugin.getWorkspace().getSynchronizer().flushSyncInfo(this.FOLDER_DIRTY_STATE_KEY, resource, 2);
                IResource[] iResourceArray = members = ((IContainer)resource).members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    this.purgeDirtyCache(member);
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
    }

    @Override
    public boolean cachesDirtyState() {
        return true;
    }
}

