/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.runner.statement;

import java.util.Iterator;
import java.util.List;
import org.eclipse.reddeer.junit.internal.requirement.Requirements;
import org.eclipse.reddeer.junit.internal.runner.statement.AbstractStatementWithScreenshot;
import org.eclipse.reddeer.junit.screenshot.ScreenshotCapturer;
import org.junit.BeforeClass;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class RunBeforeClasses
extends AbstractStatementWithScreenshot {
    private final List<FrameworkMethod> beforeClasses;
    private Requirements requirements;

    public RunBeforeClasses(String configId, Statement next, TestClass testClass, Requirements requirements) {
        super(configId, next, testClass, null, null);
        this.beforeClasses = testClass.getAnnotatedMethods(BeforeClass.class);
        this.requirements = requirements;
    }

    public void evaluate() throws Throwable {
        FrameworkMethod before = null;
        try {
            this.requirements.runBeforeClass();
            Iterator<FrameworkMethod> iterator = this.beforeClasses.iterator();
            while (iterator.hasNext()) {
                FrameworkMethod bfr;
                before = bfr = iterator.next();
                before.invokeExplosively(this.target, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            if (ScreenshotCapturer.shouldCaptureScreenshotOnException(throwable)) {
                if (this.isClassLevel()) {
                    this.frameworkMethod = before;
                    this.createScreenshot("BeforeClass");
                } else {
                    this.createScreenshot("BeforeClass_" + before.getName());
                }
            }
            throw throwable;
        }
        this.nextStatement.evaluate();
    }
}

