/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.common.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.lang.LocaleUtils;
import org.eclipse.jubula.autagent.common.commands.AbstractStartJavaAut;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;
import org.eclipse.jubula.tools.internal.utils.MonitoringUtil;

public class StartRcpAutServerCommand
extends AbstractStartJavaAut {
    private static final String NL = "-nl";

    private void createDirectAutJavaCallParameter(String pathSeparator, List<String> cmds, Map<String, String> parameters) {
        StringBuffer autClassPath = new StringBuffer();
        String autJar = parameters.get("JAR_FILE");
        String manifestClassPath = this.getClassPathFromManifest(parameters);
        if (manifestClassPath.length() > 0) {
            autClassPath.append(manifestClassPath).append(pathSeparator);
        }
        if (autClassPath.toString() != null && !"".equals(autClassPath.toString())) {
            cmds.add("-classpath");
            cmds.add(autClassPath.toString());
        }
        cmds.add("-jar");
        cmds.add(autJar);
        String autArgs = parameters.get("AUT_ARGUMENTS");
        if (autArgs != null) {
            StringTokenizer args = new StringTokenizer(autArgs, " ");
            while (args.hasMoreTokens()) {
                String arg = args.nextToken();
                cmds.add(arg);
            }
        }
    }

    private void createDirectAutExeCallParameter(List<String> cmds, Map<String, String> parameters) {
        String autArgs = parameters.get("AUT_ARGUMENTS");
        if (autArgs != null) {
            StringTokenizer args = new StringTokenizer(autArgs, " ");
            while (args.hasMoreTokens()) {
                String arg = args.nextToken();
                cmds.add(arg);
            }
        }
    }

    private List<String> createDirectAutJavaCall(Map<String, String> parameters) {
        Vector<String> cmds = new Vector<String>();
        this.addLocale(cmds, LocaleUtils.toLocale((String)parameters.get("AUT_LOCALE")));
        String jreParams = parameters.get("JRE_PARAMETER");
        if (jreParams != null && jreParams.length() > 0) {
            StringTokenizer tok = new StringTokenizer(jreParams, " ");
            while (tok.hasMoreTokens()) {
                cmds.add(tok.nextToken());
            }
        }
        this.addDebugParams(cmds, true);
        return cmds;
    }

    @Override
    protected String getServerClassName() {
        return "org.eclipse.jubula.rc.swt.SwtAUTServer";
    }

    @Override
    protected String[] createCmdArray(String baseCmd, Map<String, String> parameters) {
        List<String> cmds;
        if (!this.isRunningFromExecutable(parameters)) {
            cmds = this.createDirectAutJavaCall(parameters);
            cmds.add(0, baseCmd);
            this.createDirectAutJavaCallParameter(PATH_SEPARATOR, cmds, parameters);
            this.addLocale(cmds, LocaleUtils.toLocale((String)parameters.get("AUT_LOCALE")));
        } else {
            Locale locale;
            cmds = new Vector<String>();
            cmds.add(0, baseCmd);
            this.createDirectAutExeCallParameter(cmds, parameters);
            if (!cmds.contains(NL) && (locale = LocaleUtils.toLocale((String)parameters.get("AUT_LOCALE"))) != null && (locale.getCountry() != null && locale.getCountry().length() > 0 || locale.getLanguage() != null && locale.getLanguage().length() > 0)) {
                cmds.add(1, NL);
                cmds.add(2, locale.toString());
            }
            this.addDebugParams(cmds, true);
        }
        String[] cmdArray = cmds.toArray(new String[cmds.size()]);
        return cmdArray;
    }

    @Override
    protected String[] createEnvArray(Map<String, String> parameters, boolean isAgentSet) {
        String monAgent;
        String[] envArray = super.createEnvArray(parameters, isAgentSet);
        if (envArray == null) {
            envArray = EnvironmentUtils.propToStrArray((Properties)EnvironmentUtils.getProcessEnvironment(), (String)"=");
        }
        Vector<String> envList = new Vector<String>(Arrays.asList(envArray));
        envList.addAll(this.getConnectionProperties(parameters, "="));
        if (MonitoringUtil.shouldAndCanRunWithMonitoring(parameters) && (monAgent = this.getMonitoringAgent(parameters)) != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("_JAVA_OPTIONS=");
            sb.append(monAgent);
            envList.add(sb.toString());
            envArray = super.createEnvArray(parameters, true);
        }
        envArray = envList.toArray(new String[envList.size()]);
        return envArray;
    }

    private List<String> getConnectionProperties(Map<String, String> parameters, String valueSeparator) {
        ArrayList<String> props = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb = new StringBuffer();
        sb.append("KEYBOARD_LAYOUT").append(valueSeparator).append(parameters.get("KEYBOARD_LAYOUT"));
        props.add(sb.toString());
        sb = new StringBuffer();
        sb.append("com.bredexsw.guidancer.aut.register.autAgentHost").append(valueSeparator).append(parameters.get("com.bredexsw.guidancer.aut.register.autAgentHost"));
        props.add(sb.toString());
        sb = new StringBuffer();
        sb.append("com.bredexsw.guidancer.aut.register.autAgentPort").append(valueSeparator).append(parameters.get("com.bredexsw.guidancer.aut.register.autAgentPort"));
        props.add(sb.toString());
        sb = new StringBuffer();
        sb.append("com.bredexsw.guidancer.aut.register.autName").append(valueSeparator).append(parameters.get("com.bredexsw.guidancer.aut.register.autName"));
        props.add(sb.toString());
        sb = new StringBuffer();
        sb.append("org.eclipse.jubula.STARTED_ROOT_DIRECTORY").append(valueSeparator).append(StartRcpAutServerCommand.getInstallDir());
        props.add(sb.toString());
        return props;
    }

    @Override
    public String getRcBundleId() {
        return "org.eclipse.jubula.rc.rcp.swt";
    }
}

