/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jst.server.core.ServerProfilerDelegate;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServerBehaviour;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.osgi.framework.Bundle;

public class TomcatLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public TomcatLaunchConfigurationDelegate() {
        this.allowAdvancedSourcelookup();
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        int versionForComparison;
        String version;
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        if (server == null) {
            Trace.trace((byte)3, "Launch configuration could not find server");
            return;
        }
        if (server.shouldPublish() && ServerCore.isAutoPublishing()) {
            server.publish(1, monitor);
        }
        TomcatServerBehaviour tomcatServer = (TomcatServerBehaviour)server.loadAdapter(TomcatServerBehaviour.class, null);
        String mainTypeName = tomcatServer.getRuntimeClass();
        IVMInstall vm = this.verifyVMInstall(configuration);
        IVMRunner runner = vm.getVMRunner(mode);
        if (runner == null) {
            runner = vm.getVMRunner("run");
        }
        File workingDir = this.verifyWorkingDirectory(configuration);
        String workingDirName = null;
        if (workingDir != null) {
            workingDirName = workingDir.getAbsolutePath();
        }
        String pgmArgs = this.getProgramArguments(configuration);
        String vmArgs = this.getVMArguments(configuration);
        String[] envp = this.getEnvironment(configuration);
        ExecutionArguments execArgs = new ExecutionArguments(vmArgs, pgmArgs);
        Map vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
        String[] classpath = this.getClasspath(configuration);
        VMRunnerConfiguration runConfig = new VMRunnerConfiguration(mainTypeName, classpath);
        runConfig.setProgramArguments(execArgs.getProgramArgumentsArray());
        ArrayList<String> vmArguments = new ArrayList<String>();
        vmArguments.addAll(Arrays.asList(DebugPlugin.parseArguments((String)this.getVMArguments(configuration, mode))));
        vmArguments.addAll(Arrays.asList(execArgs.getVMArgumentsArray()));
        if (vm instanceof IVMInstall2 && (version = ((IVMInstall2)vm).getJavaVersion()) != null && (versionForComparison = Integer.parseInt(version.split("\\.")[0])) > 8) {
            Iterator argsIterator = vmArguments.iterator();
            while (argsIterator.hasNext()) {
                String vmArg = (String)argsIterator.next();
                if (!vmArg.startsWith("-Djava.endorsed.dirs=")) continue;
                argsIterator.remove();
                StringBuilder builder = new StringBuilder();
                builder.append("Skipping argument '");
                builder.append(vmArg);
                builder.append("' while launching ");
                builder.append(server.getName());
                Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.jst.server.tomcat.core")).info(builder.toString());
            }
        }
        runConfig.setVMArguments(vmArguments.toArray(new String[vmArguments.size()]));
        runConfig.setWorkingDirectory(workingDirName);
        runConfig.setEnvironment(envp);
        runConfig.setVMSpecificAttributesMap(vmAttributesMap);
        String[] bootpath = this.getBootpath(configuration);
        if (bootpath != null && bootpath.length > 0) {
            runConfig.setBootClassPath(bootpath);
        }
        this.setDefaultSourceLocator(launch, configuration);
        if ("profile".equals(mode)) {
            try {
                ServerProfilerDelegate.configureProfiling((ILaunch)launch, (IVMInstall)vm, (VMRunnerConfiguration)runConfig, (IProgressMonitor)monitor);
            }
            catch (CoreException ce) {
                tomcatServer.stopImpl();
                throw ce;
            }
        }
        tomcatServer.setupLaunch(launch, mode, monitor);
        try {
            runner.run(runConfig, launch, monitor);
            tomcatServer.addProcessListener(launch.getProcesses()[0]);
        }
        catch (Exception exception) {
            tomcatServer.stopImpl();
        }
    }
}

