/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.index;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.cdt.internal.qt.core.Activator;
import org.eclipse.cdt.internal.qt.core.index.IQMakeInfo;
import org.eclipse.cdt.internal.qt.core.index.IQtVersion;
import org.eclipse.cdt.internal.qt.core.index.QMakeParser;
import org.eclipse.cdt.internal.qt.core.index.QMakeVersion;
import org.eclipse.cdt.utils.spawner.ProcessFactory;

public final class QMakeInfo
implements IQMakeInfo {
    public static final Pattern PATTERN_QUERY_LINE = Pattern.compile("^(\\w+):(.*)$");
    public static final Pattern PATTERN_EVAL_LINE = Pattern.compile("^([a-zA-Z0-9_\\.]+)\\s*=\\s*(.*)$");
    public static final IQMakeInfo INVALID = new QMakeInfo(false, Collections.emptyMap(), Collections.emptyMap());
    private final boolean valid;
    private final Map<String, String> qmakeQueryMap;
    private final IQtVersion qtVersion;
    private final List<String> involvedQMakeFiles;
    private final List<String> qtImportPath;
    private final List<String> qtQmlPath;
    private final List<String> qtDocPath;
    private final List<String> includePath;
    private final List<String> defines;
    private final List<String> sourceFiles;
    private final List<String> headerFiles;
    private final List<String> resourceFiles;
    private final List<String> formFiles;
    private final List<String> otherFiles;

    public QMakeInfo(boolean valid, Map<String, String> queryMap, Map<String, String> proMap) {
        this.valid = valid;
        this.qmakeQueryMap = Collections.unmodifiableMap(queryMap);
        this.qtVersion = QMakeVersion.create(queryMap.get("QT_VERSION"));
        ArrayList<String> tmpQtImportPaths = new ArrayList<String>(QMakeParser.singleValue(queryMap, "QT_INSTALL_IMPORTS"));
        ArrayList<String> tmpQtQmlPaths = new ArrayList<String>(QMakeParser.singleValue(queryMap, "QT_INSTALL_QML"));
        this.qtDocPath = QMakeParser.singleValue(queryMap, "QT_INSTALL_DOCS");
        this.involvedQMakeFiles = QMakeParser.qmake3DecodeValueList(proMap, "QMAKE_INTERNAL_INCLUDED_FILES");
        this.includePath = QMakeParser.qmake3DecodeValueList(proMap, "INCLUDEPATH");
        this.defines = QMakeParser.qmake3DecodeValueList(proMap, "DEFINES");
        this.sourceFiles = QMakeParser.qmake3DecodeValueList(proMap, "SOURCES");
        this.headerFiles = QMakeParser.qmake3DecodeValueList(proMap, "HEADERS");
        this.resourceFiles = QMakeParser.qmake3DecodeValueList(proMap, "RESOURCES");
        this.formFiles = QMakeParser.qmake3DecodeValueList(proMap, "FORMS");
        this.otherFiles = QMakeParser.qmake3DecodeValueList(proMap, "OTHER_FILES");
        List<String> qmlImportPath = QMakeParser.qmake3DecodeValueList(proMap, "QML_IMPORT_PATH");
        tmpQtImportPaths.addAll(qmlImportPath);
        tmpQtQmlPaths.addAll(qmlImportPath);
        this.qtImportPath = Collections.unmodifiableList(tmpQtImportPaths);
        this.qtQmlPath = Collections.unmodifiableList(tmpQtQmlPaths);
    }

    public static IQMakeInfo create(String proPath, String qmakePath, String[] extraEnv) {
        Map<String, String> qmake1;
        if (proPath == null || qmakePath == null) {
            return INVALID;
        }
        try {
            qmake1 = QMakeInfo.exec(PATTERN_QUERY_LINE, extraEnv, qmakePath, "-query");
        }
        catch (IOException e) {
            Activator.log(e);
            return INVALID;
        }
        QMakeVersion version = QMakeVersion.create(qmake1.get("QMAKE_VERSION"));
        Map<String, String> qmake2 = Collections.emptyMap();
        if (version != null && version.getMajor() >= 3) {
            try {
                qmake2 = QMakeInfo.exec(PATTERN_EVAL_LINE, extraEnv, qmakePath, "-E", proPath);
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
        return new QMakeInfo(true, qmake1, qmake2);
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public Map<String, String> getQMakeQueryMap() {
        return this.qmakeQueryMap;
    }

    @Override
    public IQtVersion getQtVersion() {
        return this.qtVersion;
    }

    @Override
    public List<String> getInvolvedQMakeFiles() {
        return this.involvedQMakeFiles;
    }

    @Override
    public List<String> getQtImportPath() {
        return this.qtImportPath;
    }

    @Override
    public List<String> getQtQmlPath() {
        return this.qtQmlPath;
    }

    @Override
    public List<String> getQtDocPath() {
        return this.qtDocPath;
    }

    @Override
    public List<String> getIncludePath() {
        return this.includePath;
    }

    @Override
    public List<String> getDefines() {
        return this.defines;
    }

    @Override
    public List<String> getSourceFiles() {
        return this.sourceFiles;
    }

    @Override
    public List<String> getHeaderFiles() {
        return this.headerFiles;
    }

    @Override
    public List<String> getResourceFiles() {
        return this.resourceFiles;
    }

    @Override
    public List<String> getFormFiles() {
        return this.formFiles;
    }

    @Override
    public List<String> getOtherFiles() {
        return this.otherFiles;
    }

    private static Map<String, String> exec(Pattern regex, String[] extraEnv, String ... command) throws IOException {
        if (command.length < 1 || !new File(command[0]).exists()) {
            throw new IOException("qmake: cannot run command: " + (command.length > 0 ? command[0] : ""));
        }
        Process process = null;
        try {
            Map<String, String> map;
            block15: {
                process = extraEnv != null && extraEnv.length > 0 ? ProcessFactory.getFactory().exec(command, extraEnv) : ProcessFactory.getFactory().exec(command);
                Throwable throwable = null;
                Object var5_6 = null;
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                try {
                    map = QMakeParser.parse(regex, reader);
                    if (reader == null) break block15;
                }
                catch (Throwable throwable2) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                reader.close();
            }
            return map;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }
}

