/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.variable;

import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.variable.AbstractNoNameVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;

public final class ExposedPropertyVariableSupport
extends AbstractNoNameVariableSupport {
    private final JavaInfo m_hostJavaInfo;
    private final Method m_method;

    public ExposedPropertyVariableSupport(JavaInfo javaInfo, JavaInfo hostJavaInfo, Method method) {
        super(javaInfo);
        this.m_hostJavaInfo = hostJavaInfo;
        this.m_method = method;
    }

    public String toString() {
        return "property";
    }

    public boolean isValidStatementForChild(Statement statement) {
        return this.m_hostJavaInfo.getVariableSupport().isValidStatementForChild(statement);
    }

    public String getTitle() throws Exception {
        return String.valueOf(this.m_method.getName()) + "()";
    }

    public String getComponentName() {
        String methodName = this.m_method.getName();
        if (methodName.startsWith("get")) {
            methodName = methodName.substring("get".length());
        }
        return String.valueOf(this.m_hostJavaInfo.getVariableSupport().getComponentName()) + StringUtils.capitalize((String)methodName);
    }

    public boolean hasExpression(NodeTarget target) {
        return this.m_hostJavaInfo.getVariableSupport().hasExpression(target);
    }

    public String getReferenceExpression(NodeTarget target) throws Exception {
        String parentAccess = this.m_hostJavaInfo.getVariableSupport().getAccessExpression(target);
        return String.valueOf(parentAccess) + this.m_method.getName() + "()";
    }

    public String getAccessExpression(NodeTarget target) throws Exception {
        return String.valueOf(this.getReferenceExpression(target)) + ".";
    }

    public StatementTarget getStatementTarget() throws Exception {
        return this.m_hostJavaInfo.getVariableSupport().getStatementTarget();
    }

    public StatementTarget getChildTarget() throws Exception {
        return JavaInfoUtils.getTarget(this.m_hostJavaInfo);
    }
}

