/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.presentation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.IValidator;
import org.eclipse.emf.validation.service.ModelValidationService;

public class EmftvmValidateAction
extends ValidateAction {
    protected final IValidator<EObject> validator = ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);

    protected Diagnostic validate(IProgressMonitor progressMonitor) {
        BasicDiagnostic diagnostics;
        Diagnostic superdiag = super.validate(progressMonitor);
        if (superdiag instanceof BasicDiagnostic) {
            diagnostics = (BasicDiagnostic)superdiag;
        } else {
            diagnostics = new BasicDiagnostic();
            diagnostics.add(superdiag);
        }
        for (EObject eObject : this.selectedObjects) {
            IStatus st = this.validator.validate((Object)eObject);
            if (st.isOK()) continue;
            if (st.getChildren().length > 0) {
                IStatus[] iStatusArray = st.getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus cst = iStatusArray[n2];
                    if (cst instanceof ConstraintStatus) {
                        diagnostics.add((Diagnostic)new BasicDiagnostic(cst.getSeverity(), cst.getPlugin(), cst.getCode(), cst.getMessage(), new Object[]{((ConstraintStatus)cst).getTarget()}));
                    }
                    ++n2;
                }
                continue;
            }
            if (!(st instanceof ConstraintStatus)) continue;
            diagnostics.add((Diagnostic)new BasicDiagnostic(st.getSeverity(), st.getPlugin(), st.getCode(), st.getMessage(), new Object[]{((ConstraintStatus)st).getTarget()}));
        }
        return diagnostics;
    }
}

