/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.utils;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;

public class HTMLSpecialCharHelper {
    private static Logger _log = PDPlugin.getLogger(HTMLSpecialCharHelper.class);
    private static Hashtable _table = new Hashtable(256);
    private static Hashtable _reverse;

    static {
        _table.put(34, "&quot;");
        _table.put(38, "&amp;");
        _table.put(60, "&lt;");
        _table.put(62, "&gt;");
        _table.put(160, "&nbsp;");
        _table.put(161, "&iexcl;");
        _table.put(162, "&cent;");
        _table.put(163, "&pound;");
        _table.put(164, "&curren;");
        _table.put(165, "&yen;");
        _table.put(166, "&brvbar;");
        _table.put(167, "&sect;");
        _table.put(168, "&uml;");
        _table.put(169, "&copy;");
        _table.put(170, "&ordf;");
        _table.put(171, "&laquo;");
        _table.put(172, "&not;");
        _table.put(173, "&shy;");
        _table.put(174, "&reg;");
        _table.put(175, "&macr;");
        _table.put(176, "&deg;");
        _table.put(177, "&plusmn;");
        _table.put(178, "&sup2;");
        _table.put(179, "&sup3;");
        _table.put(180, "&acute;");
        _table.put(181, "&micro;");
        _table.put(182, "&para;");
        _table.put(183, "&middot;");
        _table.put(184, "&cedil;");
        _table.put(185, "&sup1;");
        _table.put(186, "&ordm;");
        _table.put(187, "&raquo;");
        _table.put(188, "&frac14;");
        _table.put(189, "&frac12;");
        _table.put(190, "&frac34;");
        _table.put(191, "&iquest;");
        _table.put(192, "&Agrave;");
        _table.put(193, "&Aacute;");
        _table.put(194, "&Acirc;");
        _table.put(195, "&Atilde;");
        _table.put(196, "&Auml;");
        _table.put(197, "&Aring;");
        _table.put(198, "&AElig;");
        _table.put(199, "&Ccedil;");
        _table.put(200, "&Egrave;");
        _table.put(201, "&Eacute;");
        _table.put(202, "&Ecirc;");
        _table.put(203, "&Euml;");
        _table.put(204, "&Igrave;");
        _table.put(205, "&Iacute;");
        _table.put(206, "&Icirc;");
        _table.put(207, "&Iuml;");
        _table.put(208, "&ETH;");
        _table.put(209, "&Ntilde;");
        _table.put(210, "&Ograve;");
        _table.put(211, "&Oacute;");
        _table.put(212, "&Ocirc;");
        _table.put(213, "&Otilde;");
        _table.put(214, "&Ouml;");
        _table.put(215, "&times;");
        _table.put(216, "&Oslash;");
        _table.put(217, "&Ugrave;");
        _table.put(218, "&Uacute;");
        _table.put(219, "&Ucirc;");
        _table.put(220, "&Uuml;");
        _table.put(221, "&Yacute;");
        _table.put(222, "&THORN;");
        _table.put(223, "&szlig;");
        _table.put(224, "&agrave;");
        _table.put(225, "&aacute;");
        _table.put(226, "&acirc;");
        _table.put(227, "&atilde;");
        _table.put(228, "&auml;");
        _table.put(229, "&aring;");
        _table.put(230, "&aelig;");
        _table.put(231, "&ccedil;");
        _table.put(232, "&egrave;");
        _table.put(233, "&eacute;");
        _table.put(234, "&ecirc;");
        _table.put(235, "&euml;");
        _table.put(236, "&igrave;");
        _table.put(237, "&iacute;");
        _table.put(238, "&icirc;");
        _table.put(239, "&iuml;");
        _table.put(240, "&eth;");
        _table.put(241, "&ntilde;");
        _table.put(242, "&ograve;");
        _table.put(243, "&oacute;");
        _table.put(244, "&ocirc;");
        _table.put(245, "&otilde;");
        _table.put(246, "&ouml;");
        _table.put(247, "&divide;");
        _table.put(248, "&oslash;");
        _table.put(249, "&ugrave;");
        _table.put(250, "&uacute;");
        _table.put(251, "&ucirc;");
        _table.put(252, "&uuml;");
        _table.put(253, "&yacute;");
        _table.put(254, "&thorn;");
        _table.put(255, "&yuml;");
        _table.put(402, "&fnof;");
        _table.put(913, "&Alpha;");
        _table.put(914, "&Beta;");
        _table.put(915, "&Gamma;");
        _table.put(916, "&Delta;");
        _table.put(917, "&Epsilon;");
        _table.put(918, "&Zeta;");
        _table.put(919, "&Eta;");
        _table.put(920, "&Theta;");
        _table.put(921, "&Iota;");
        _table.put(922, "&Kappa;");
        _table.put(923, "&Lambda;");
        _table.put(924, "&Mu;");
        _table.put(925, "&Nu;");
        _table.put(926, "&Xi;");
        _table.put(927, "&Omicron;");
        _table.put(928, "&Pi;");
        _table.put(929, "&Rho;");
        _table.put(931, "&Sigma;");
        _table.put(932, "&Tau;");
        _table.put(933, "&Upsilon;");
        _table.put(934, "&Phi;");
        _table.put(935, "&Chi;");
        _table.put(936, "&Psi;");
        _table.put(937, "&Omega;");
        _table.put(945, "&alpha;");
        _table.put(946, "&beta;");
        _table.put(947, "&gamma;");
        _table.put(948, "&delta;");
        _table.put(949, "&epsilon;");
        _table.put(950, "&zeta;");
        _table.put(951, "&eta;");
        _table.put(952, "&theta;");
        _table.put(953, "&iota;");
        _table.put(954, "&kappa;");
        _table.put(955, "&lambda;");
        _table.put(956, "&mu;");
        _table.put(957, "&nu;");
        _table.put(958, "&xi;");
        _table.put(959, "&omicron;");
        _table.put(960, "&pi;");
        _table.put(961, "&rho;");
        _table.put(962, "&sigmaf;");
        _table.put(963, "&sigma;");
        _table.put(964, "&tau;");
        _table.put(965, "&upsilon;");
        _table.put(966, "&phi;");
        _table.put(967, "&chi;");
        _table.put(968, "&psi;");
        _table.put(969, "&omega;");
        _table.put(977, "&thetasym;");
        _table.put(978, "&upsih;");
        _table.put(982, "&piv;");
        _table.put(8226, "&bull;");
        _table.put(8230, "&hellip;");
        _table.put(8242, "&prime;");
        _table.put(8243, "&Prime;");
        _table.put(8254, "&oline;");
        _table.put(8260, "&frasl;");
        _table.put(8472, "&weierp;");
        _table.put(8465, "&image;");
        _table.put(8476, "&real;");
        _table.put(8482, "&trade;");
        _table.put(8501, "&alefsym;");
        _table.put(8592, "&larr;");
        _table.put(8593, "&uarr;");
        _table.put(8594, "&rarr;");
        _table.put(8595, "&darr;");
        _table.put(8596, "&harr;");
        _table.put(8629, "&crarr;");
        _table.put(8656, "&lArr;");
        _table.put(8657, "&uArr;");
        _table.put(8658, "&rArr;");
        _table.put(8659, "&dArr;");
        _table.put(8660, "&hArr;");
        _table.put(8704, "&forall;");
        _table.put(8706, "&part;");
        _table.put(8707, "&exist;");
        _table.put(8709, "&empty;");
        _table.put(8711, "&nabla;");
        _table.put(8712, "&isin;");
        _table.put(8713, "&notin;");
        _table.put(8715, "&ni;");
        _table.put(8719, "&prod;");
        _table.put(8722, "&sum;");
        _table.put(8722, "&minus;");
        _table.put(8727, "&lowast;");
        _table.put(8730, "&radic;");
        _table.put(8733, "&prop;");
        _table.put(8734, "&infin;");
        _table.put(8736, "&ang;");
        _table.put(8869, "&and;");
        _table.put(8870, "&or;");
        _table.put(8745, "&cap;");
        _table.put(8746, "&cup;");
        _table.put(8747, "&int;");
        _table.put(8756, "&there4;");
        _table.put(8764, "&sim;");
        _table.put(8773, "&cong;");
        _table.put(8773, "&asymp;");
        _table.put(8800, "&ne;");
        _table.put(8801, "&equiv;");
        _table.put(8804, "&le;");
        _table.put(8805, "&ge;");
        _table.put(8834, "&sub;");
        _table.put(8835, "&sup;");
        _table.put(8836, "&nsub;");
        _table.put(8838, "&sube;");
        _table.put(8839, "&supe;");
        _table.put(8853, "&oplus;");
        _table.put(8855, "&otimes;");
        _table.put(8869, "&perp;");
        _table.put(8901, "&sdot;");
        _table.put(8968, "&lceil;");
        _table.put(8969, "&rceil;");
        _table.put(8970, "&lfloor;");
        _table.put(8971, "&rfloor;");
        _table.put(9001, "&lang;");
        _table.put(9002, "&rang;");
        _table.put(9674, "&loz;");
        _table.put(9824, "&spades;");
        _table.put(9827, "&clubs;");
        _table.put(9829, "&hearts;");
        _table.put(9830, "&diams;");
        _table.put(338, "&OElig;");
        _table.put(339, "&oelig;");
        _table.put(352, "&Scaron;");
        _table.put(353, "&scaron;");
        _table.put(376, "&Yuml;");
        _table.put(710, "&circ;");
        _table.put(732, "&tilde;");
        _table.put(8194, "&ensp;");
        _table.put(8195, "&emsp;");
        _table.put(8201, "&thinsp;");
        _table.put(8204, "&zwnj;");
        _table.put(8205, "&zwj;");
        _table.put(8206, "&lrm;");
        _table.put(8207, "&rlm;");
        _table.put(8211, "&ndash;");
        _table.put(151, "&mdash;");
        _table.put(8216, "&lsquo;");
        _table.put(8217, "&rsquo;");
        _table.put(8218, "&sbquo;");
        _table.put(8220, "&ldquo;");
        _table.put(8221, "&rdquo;");
        _table.put(8222, "&bdquo;");
        _table.put(8224, "&dagger;");
        _table.put(8225, "&Dagger;");
        _table.put(8240, "&permil;");
        _table.put(8249, "&lsaquo;");
        _table.put(8250, "&rsaquo;");
        _table.put(8364, "&euro;");
        _reverse = new Hashtable(256);
        Enumeration e = _table.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            String value = (String)_table.get(key);
            _reverse.put(value, key);
            _reverse.put(value.substring(0, value.length() - 1), key);
        }
    }

    public static String getSpecial(int ch) {
        return (String)_table.get(ch);
    }

    public static int getSpecial(String str) {
        Integer result = (Integer)_reverse.get(str);
        if (result == null) {
            return -1;
        }
        return result;
    }

    public static void encode(String str, int start, int end, Writer writer) throws IOException {
        int i = start;
        while (i < end) {
            char ch = str.charAt(i);
            String special = HTMLSpecialCharHelper.getSpecial(ch);
            if (special != null) {
                writer.write(special);
            } else if ((ch & 0xFF) != 0) {
                writer.write("&#");
                writer.write(Integer.toString(ch));
                writer.write(";");
            } else {
                writer.write(ch);
            }
            ++i;
        }
    }

    public static StringBuffer encode(String str, StringBuffer result) {
        return HTMLSpecialCharHelper.encode(str, 0, str.length(), result);
    }

    public static StringBuffer encode(String str, int start, int end, StringBuffer result) {
        int i = start;
        while (i < end) {
            char ch = str.charAt(i);
            String special = HTMLSpecialCharHelper.getSpecial(ch);
            if (special != null) {
                result.append(special);
            } else if ((ch & 0xFF00) != 0) {
                result.append("&#");
                result.append(Integer.toString(ch));
                result.append(";");
            } else {
                result.append(ch);
            }
            ++i;
        }
        return result;
    }

    public static StringBuffer decode(String str, StringBuffer buffer) throws RuntimeException {
        return HTMLSpecialCharHelper.decode(str, 0, str.length(), buffer);
    }

    public static StringBuffer decode(String str, int start, int end, StringBuffer buffer) throws RuntimeException {
        int pos = start;
        do {
            char ch;
            if ((ch = str.charAt(pos)) == '&') {
                int stop = str.indexOf(59, pos + 1);
                if (stop < 0 || stop >= end) {
                    _log.error("HTMLSpecialCharHelper.3");
                    throw new RuntimeException("HTMLSpecialCharHelper.2");
                }
                String sp = str.substring(pos, stop + 1);
                int special = HTMLSpecialCharHelper.getSpecial(sp);
                if (special != -1) {
                    buffer.append((char)special);
                } else {
                    ch = sp.charAt(1);
                    if (ch != '#') {
                        throw new RuntimeException("HTMLSpecialCharHelper.1");
                    }
                    try {
                        buffer.append((char)Integer.parseInt(sp.substring(2, sp.length() - 1)));
                    }
                    catch (NumberFormatException ex) {
                        _log.info("HTMLSpecialCharHelper.0", (Throwable)ex);
                        throw new RuntimeException("illegal: " + sp);
                    }
                }
                pos = stop + 1;
                continue;
            }
            buffer.append(ch);
            ++pos;
        } while (pos < end);
        return buffer;
    }

    public static int decodeEntity(String entityRef) {
        Integer result = (Integer)_reverse.get(entityRef);
        if (result != null) {
            return result;
        }
        if (entityRef.length() >= 2 && entityRef.charAt(1) == '#') {
            String s = entityRef.substring(2);
            if (s.endsWith(";")) {
                s = s.substring(0, s.length() - 1);
            }
            try {
                return Integer.parseInt(s);
            }
            catch (Exception exception) {}
        }
        return -1;
    }
}

