/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.properties;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.properties.AttributePropertySheetPage;
import org.eclipse.jst.pagedesigner.properties.AttributePropertySourceProvider;
import org.eclipse.jst.pagedesigner.properties.DesignerPropertyTool;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;

public class AllPropertySection
extends AbstractPropertySection {
    private AttributePropertySheetPage page;
    protected IPropertySourceProvider _provider;
    protected IDOMElement _element;
    protected INodeAdapter _adapter = new INodeAdapter(){

        public boolean isAdapterForType(Object type) {
            return false;
        }

        public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
            AllPropertySection.this.refresh();
        }
    };

    public AllPropertySection() {
        this.setPropertySourceProvider(new AttributePropertySourceProvider());
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.page = new AttributePropertySheetPage();
        this.page.init(tabbedPropertySheetPage.getSite());
        if (this._provider != null) {
            this.page.setPropertySourceProvider(this._provider);
        }
        this.page.createControl(composite);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.height = 100;
        data.width = 100;
        this.page.getControl().setLayoutData((Object)data);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        IDOMElement newEle = (IDOMElement)DesignerPropertyTool.getElement(part, selection);
        if (this._element != newEle && this.page != null) {
            super.setInput(part, selection);
            this.page.selectionChanged(part, selection);
            if (this._element != null) {
                this._element.removeAdapter(this._adapter);
            }
            this._element = newEle;
            if (this._element != null) {
                this._element.addAdapter(this._adapter);
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this._element != null) {
            this._element.removeAdapter(this._adapter);
        }
        if (this.page != null) {
            this.page.dispose();
            this.page = null;
        }
    }

    public void refresh() {
        if (this.page != null) {
            this.page.refresh();
        }
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void setPropertySourceProvider(IPropertySourceProvider provider) {
        this._provider = provider;
        if (this.page != null) {
            this.page.setPropertySourceProvider(this._provider);
        }
    }
}

