/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils;

import org.eclipse.cdt.visualizer.ui.util.GUIUtils;
import org.eclipse.cdt.visualizer.ui.util.RunnableWithResult;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.launch.LaunchView;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class DebugViewUtils {
    public static LaunchView getDebugView() {
        return (LaunchView)DebugViewUtils.getViewWithID("org.eclipse.debug.ui.DebugView");
    }

    public static TreeModelViewer getDebugViewer() {
        LaunchView debugView = DebugViewUtils.getDebugView();
        TreeModelViewer viewer = debugView == null ? null : (TreeModelViewer)debugView.getViewer();
        return viewer;
    }

    public static IViewPart getViewWithID(String viewID) {
        final String viewID_f = viewID;
        RunnableWithResult<IViewPart> runnable = new RunnableWithResult<IViewPart>(){

            public IViewPart call() {
                IViewPart view = null;
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (activePage != null) {
                    view = viewID_f == null ? null : activePage.findView(viewID_f);
                }
                return view;
            }
        };
        GUIUtils.execAndWait((Runnable)runnable);
        IViewPart result = (IViewPart)runnable.getResult();
        return result;
    }

    public static boolean setDebugViewSelection(ISelection selection) {
        TreeModelViewer viewer = DebugViewUtils.getDebugViewer();
        if (viewer == null || selection == null) {
            return false;
        }
        return viewer.trySelection(selection, true, true);
    }

    public static ISelection getDebugViewSelection() {
        TreeModelViewer viewer = DebugViewUtils.getDebugViewer();
        if (viewer == null) {
            return null;
        }
        return viewer.getSelection();
    }
}

