/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.wizards.pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.core.TransientPeer;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.tcf.core.util.persistence.PeerDataHelper;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelUpdateService;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.tcf.te.tcf.ui.controls.CustomTransportPanel;
import org.eclipse.tcf.te.tcf.ui.controls.PeerAttributesTablePart;
import org.eclipse.tcf.te.tcf.ui.controls.PeerNameControl;
import org.eclipse.tcf.te.tcf.ui.controls.PipeTransportPanel;
import org.eclipse.tcf.te.tcf.ui.controls.TcpTransportPanel;
import org.eclipse.tcf.te.tcf.ui.controls.TransportTypeControl;
import org.eclipse.tcf.te.tcf.ui.controls.TransportTypePanelControl;
import org.eclipse.tcf.te.tcf.ui.dialogs.LocatorNodeSelectionDialog;
import org.eclipse.tcf.te.tcf.ui.help.IContextHelpIds;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.controls.BaseDialogPageControl;
import org.eclipse.tcf.te.ui.controls.BaseEditBrowseTextControl;
import org.eclipse.tcf.te.ui.controls.interfaces.IWizardConfigurationPanel;
import org.eclipse.tcf.te.ui.controls.validator.RegexValidator;
import org.eclipse.tcf.te.ui.controls.validator.Validator;
import org.eclipse.tcf.te.ui.forms.FormLayoutFactory;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode;
import org.eclipse.tcf.te.ui.jface.interfaces.IValidatingContainer;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.tcf.te.ui.wizards.pages.AbstractValidatingWizardPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class NewTargetWizardPage
extends AbstractValidatingWizardPage
implements IDataExchangeNode {
    private PeerNameControl peerNameControl;
    BaseEditBrowseTextControl proxyControl = null;
    TransportTypeControl transportTypeControl;
    TransportTypePanelControl transportTypePanelControl;
    private PeerAttributesTablePart tablePart;
    Button connect = null;
    String proxies = null;
    private FormToolkit toolkit = null;
    boolean autoConnect = false;
    private final UUID uuid = UUID.randomUUID();
    final List<String> usedNames = new ArrayList<String>();

    public NewTargetWizardPage() {
        this(NewTargetWizardPage.class.getName());
    }

    public NewTargetWizardPage(String pageName) {
        super(pageName);
    }

    public void dispose() {
        if (this.peerNameControl != null) {
            this.peerNameControl.dispose();
            this.peerNameControl = null;
        }
        if (this.transportTypeControl != null) {
            this.transportTypeControl.dispose();
            this.transportTypeControl = null;
        }
        if (this.transportTypePanelControl != null) {
            this.transportTypePanelControl.dispose();
            this.transportTypePanelControl = null;
        }
        if (this.tablePart != null) {
            this.tablePart.dispose();
            this.tablePart = null;
        }
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        super.dispose();
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.NewTargetWizardPage_title);
        this.setDescription(Messages.NewTargetWizardPage_description);
        this.toolkit = new FormToolkit(parent.getDisplay());
        Composite mainPanel = this.toolkit.createComposite(parent);
        mainPanel.setLayout((Layout)FormLayoutFactory.createClearGridLayout((boolean)false, (int)1));
        mainPanel.setLayoutData((Object)new GridData(4, 4, true, true));
        mainPanel.setBackground(parent.getBackground());
        this.setControl((Control)mainPanel);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)mainPanel, IContextHelpIds.NEW_TARGET_WIZARD_PAGE);
        boolean changed = this.setValidationInProgress(true);
        this.createMainPanelControls(mainPanel, this.toolkit);
        if (changed) {
            this.setValidationInProgress(false);
        }
        Dialog.applyDialogFont((Control)mainPanel);
        this.validate();
    }

    protected void createMainPanelControls(Composite parent, FormToolkit toolkit) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)toolkit);
        Composite client = toolkit.createComposite(parent);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout((boolean)false, (int)3));
        client.setLayoutData((Object)new GridData(4, 4, true, true));
        client.setBackground(parent.getBackground());
        this.peerNameControl = new PeerNameControl((IDialogPage)this){

            public boolean isValid() {
                boolean valid = true;
                String name = this.getEditFieldControlTextForValidation();
                if (!"".equals(name) && this.getParentPage() instanceof NewTargetWizardPage) {
                    boolean bl = valid = !((NewTargetWizardPage)this.getParentPage()).usedNames.contains(name.trim().toUpperCase());
                    if (!valid) {
                        this.setMessage(Messages.NewTargetWizardPage_error_nameInUse, 3);
                    }
                }
                if (!valid && this.getControlDecoration() != null && this.isEnabled()) {
                    this.updateControlDecoration(this.getMessage(), this.getMessageType());
                }
                return valid ? super.isValid() : false;
            }

            protected void onButtonControlSelected() {
                ISelection selection;
                LocatorNodeSelectionDialog dialog = new LocatorNodeSelectionDialog(null, true){

                    @Override
                    protected String getDialogTitle() {
                        return Messages.NewTargetWizardPage_PeerSelectionDialog_dialogTitle;
                    }

                    @Override
                    protected String getTitle() {
                        return Messages.NewTargetWizardPage_PeerSelectionDialog_title;
                    }

                    @Override
                    protected String getDefaultMessage() {
                        return Messages.NewTargetWizardPage_PeerSelectionDialog_message;
                    }
                };
                ILocatorNode locatorNode = NewTargetWizardPage.this.getLocatorNode();
                dialog.setSelection((ISelection)(locatorNode != null ? new StructuredSelection((Object)locatorNode) : null));
                if (dialog.open() == 0 && (selection = dialog.getSelection()) instanceof IStructuredSelection && !selection.isEmpty()) {
                    if (((IStructuredSelection)selection).getFirstElement() instanceof ILocatorNode) {
                        final IPeer peer = ((ILocatorNode)((IStructuredSelection)selection).getFirstElement()).getPeer();
                        PropertiesContainer data = new PropertiesContainer();
                        Protocol.invokeAndWait((Runnable)new Runnable((IPropertiesContainer)data){
                            private final /* synthetic */ IPropertiesContainer val$data;
                            {
                                this.val$data = iPropertiesContainer;
                            }

                            @Override
                            public void run() {
                                for (Map.Entry attribute : peer.getAttributes().entrySet()) {
                                    this.val$data.setProperty((String)attribute.getKey(), attribute.getValue());
                                }
                            }
                        });
                        NewTargetWizardPage.this.setupData((IPropertiesContainer)data);
                    } else {
                        NewTargetWizardPage.this.proxies = null;
                        NewTargetWizardPage.this.proxyControl.setEditFieldControlText("");
                    }
                }
            }

            @Override
            protected Validator doCreateEditFieldValidator() {
                return new RegexValidator(1, "[0-9a-zA-Z. _()-]+");
            }

            @Override
            protected void configureEditFieldValidator(Validator validator) {
                if (validator == null) {
                    return;
                }
                validator.setMessageText("TextValidator_Information_MissingName", Messages.NewTargetWizardPage_description);
            }
        };
        this.peerNameControl.setFormToolkit(toolkit);
        this.peerNameControl.setParentControlIsInnerPanel(false);
        this.peerNameControl.setHideBrowseButton(false);
        this.peerNameControl.setupPanel(client);
        this.peerNameControl.getEditFieldControl().setFocus();
        this.createEmptySpace(client, 5, 2, toolkit);
        this.proxyControl = new BaseEditBrowseTextControl(null);
        this.proxyControl.setFormToolkit(toolkit);
        this.proxyControl.setParentControlIsInnerPanel(false);
        this.proxyControl.setHideBrowseButton(true);
        this.proxyControl.setReadOnly(true);
        this.proxyControl.setIsGroup(false);
        this.proxyControl.setHasHistory(false);
        this.proxyControl.setEditFieldLabel(Messages.TcpTransportSection_proxies_label);
        this.proxyControl.setupPanel(client);
        SWTControlUtil.setEnabled((Control)this.proxyControl.getEditFieldControl(), (boolean)false);
        this.createEmptySpace(client, 5, 2, toolkit);
        Section transportTypeSection = toolkit.createSection(client, 256);
        transportTypeSection.setText(Messages.NewTargetWizardPage_section_transportType);
        transportTypeSection.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout((boolean)false, (int)2));
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.horizontalSpan = 2;
        transportTypeSection.setLayoutData((Object)layoutData);
        transportTypeSection.setBackground(client.getBackground());
        Composite transportTypeClient = toolkit.createComposite((Composite)transportTypeSection);
        transportTypeClient.setLayout((Layout)new GridLayout());
        transportTypeClient.setBackground(transportTypeSection.getBackground());
        transportTypeSection.setClient((Control)transportTypeClient);
        this.transportTypeControl = new MyTransportTypeControl((IDialogPage)this);
        this.transportTypeControl.setFormToolkit(toolkit);
        this.transportTypeControl.setupPanel(transportTypeClient);
        this.transportTypePanelControl = new MyTransportTypePanelControl((IDialogPage)this);
        TcpTransportPanel tcpTransportPanel = new TcpTransportPanel((BaseDialogPageControl)this.transportTypePanelControl);
        this.transportTypePanelControl.setFormToolkit(toolkit);
        this.transportTypePanelControl.addConfigurationPanel("TCP", (IWizardConfigurationPanel)tcpTransportPanel);
        this.transportTypePanelControl.addConfigurationPanel("SSL", (IWizardConfigurationPanel)tcpTransportPanel);
        this.transportTypePanelControl.addConfigurationPanel("PIPE", (IWizardConfigurationPanel)new PipeTransportPanel((BaseDialogPageControl)this.transportTypePanelControl));
        this.transportTypePanelControl.addConfigurationPanel("Custom", (IWizardConfigurationPanel)new CustomTransportPanel((BaseDialogPageControl)this.transportTypePanelControl));
        this.transportTypePanelControl.setupPanel(transportTypeClient, this.transportTypeControl.getTransportTypes(), toolkit);
        layoutData = new GridData(4, 4, true, true);
        layoutData.horizontalSpan = 2;
        this.transportTypePanelControl.getPanel().setLayoutData((Object)layoutData);
        toolkit.adapt(this.transportTypePanelControl.getPanel());
        this.transportTypePanelControl.showConfigurationPanel(this.transportTypeControl.getSelectedTransportType());
        this.createPeerAttributesTableControl(client, toolkit);
        if (this.hasAutoConnectButton()) {
            if (System.getProperty("NewWizard_autoConnect") != null) {
                this.autoConnect = Boolean.getBoolean("NewWizard_autoConnect");
            }
            this.connect = toolkit.createButton(client, Messages.AbstractConfigWizardPage_connect_label, 32);
            layoutData = new GridData(4, 0x1000000, true, false);
            layoutData.horizontalSpan = 2;
            this.connect.setLayoutData((Object)layoutData);
            this.connect.setSelection(this.autoConnect);
            this.connect.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NewTargetWizardPage.this.autoConnect = SWTControlUtil.getSelection((Button)NewTargetWizardPage.this.connect);
                }
            });
        }
        this.restoreWidgetValues();
        this.initializeUsedNameList();
    }

    protected ILocatorNode getLocatorNode() {
        AtomicReference selectedLocatorNode = new AtomicReference();
        if (this.transportTypeControl.isValid() && this.transportTypePanelControl.isValid()) {
            PropertiesContainer transportData = new PropertiesContainer();
            this.extractData((IPropertiesContainer)transportData);
            Protocol.invokeAndWait((Runnable)new Runnable((IPropertiesContainer)transportData, selectedLocatorNode){
                private final /* synthetic */ IPropertiesContainer val$transportData;
                private final /* synthetic */ AtomicReference val$selectedLocatorNode;
                {
                    this.val$transportData = iPropertiesContainer;
                    this.val$selectedLocatorNode = atomicReference;
                }

                @Override
                public void run() {
                    String proxy = this.val$transportData.getStringProperty("Proxies");
                    if (proxy == null || proxy.trim().length() == 0) {
                        return;
                    }
                    String host = this.val$transportData.getStringProperty("Host");
                    String port = this.val$transportData.getStringProperty("Port");
                    String transport = this.val$transportData.getStringProperty("TransportName");
                    String id = String.valueOf(transport) + ":" + host + ":" + port;
                    HashMap<String, String> attrs = new HashMap<String, String>();
                    attrs.put("ID", id);
                    attrs.put("Host", host);
                    attrs.put("Port", port);
                    attrs.put("TransportName", transport);
                    attrs.put("Proxies", proxy);
                    TransientPeer peer = new TransientPeer(attrs);
                    ILocatorModelLookupService lkup = (ILocatorModelLookupService)ModelManager.getLocatorModel().getService(ILocatorModelLookupService.class);
                    this.val$selectedLocatorNode.set(lkup.lkupLocatorNode((IPeer)peer));
                    if (this.val$selectedLocatorNode.get() == null) {
                        ILocatorModelUpdateService update = (ILocatorModelUpdateService)ModelManager.getLocatorModel().getService(ILocatorModelUpdateService.class);
                        this.val$selectedLocatorNode.set(update.add((IPeer)peer, true));
                    }
                }
            });
        }
        return (ILocatorNode)selectedLocatorNode.get();
    }

    protected void createPeerAttributesTableControl(Composite parent, FormToolkit toolkit) {
        Assert.isNotNull((Object)parent);
        this.createEmptySpace(parent, 5, 2, toolkit);
        Section attributesSection = toolkit.createSection(parent, 256);
        attributesSection.setText(Messages.NewTargetWizardPage_section_attributes);
        attributesSection.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout((boolean)false, (int)2));
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.horizontalSpan = 2;
        attributesSection.setLayoutData((Object)layoutData);
        attributesSection.setBackground(parent.getBackground());
        Composite client = toolkit.createComposite((Composite)attributesSection);
        client.setLayout((Layout)new GridLayout(2, false));
        client.setBackground(attributesSection.getBackground());
        attributesSection.setClient((Control)client);
        this.tablePart = new PeerAttributesTablePart();
        this.tablePart.setMinSize(SWTControlUtil.convertWidthInCharsToPixels((Control)client, (int)20), SWTControlUtil.convertHeightInCharsToPixels((Control)client, (int)6));
        this.tablePart.setBannedNames(new String[]{"ID", "AgentID", "ServiceManagerID", "Name", "TransportName", "Host", "Port", "PipeName"});
        this.tablePart.createControl(client, 65540, 2, toolkit);
    }

    protected IValidatingContainer.ValidationResult doValidate() {
        IValidatingContainer.ValidationResult result = new IValidatingContainer.ValidationResult();
        boolean valid = true;
        if (this.peerNameControl != null) {
            valid &= this.peerNameControl.isValid();
            result.setResult((IMessageProvider)this.peerNameControl);
        }
        if (this.transportTypeControl != null) {
            valid &= this.transportTypeControl.isValid();
            result.setResult((IMessageProvider)this.transportTypeControl);
        }
        if (this.transportTypePanelControl != null) {
            valid &= this.transportTypePanelControl.isValid();
            result.setResult((IMessageProvider)this.transportTypePanelControl);
        }
        result.setValid(valid);
        return result;
    }

    public void setupData(IPropertiesContainer data) {
        String transportType;
        if (this.proxyControl != null) {
            this.proxies = data.getStringProperty("Proxies");
            IPeer[] proxyPeers = PeerDataHelper.decodePeerList((String)this.proxies);
            String proxyInfo = "";
            IPeer[] iPeerArray = proxyPeers;
            int n = proxyPeers.length;
            int n2 = 0;
            while (n2 < n) {
                String name;
                final IPeer proxy = iPeerArray[n2];
                final AtomicReference locatorNode = new AtomicReference();
                Protocol.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ILocatorModelLookupService lkup = (ILocatorModelLookupService)ModelManager.getLocatorModel().getService(ILocatorModelLookupService.class);
                        locatorNode.set(lkup.lkupLocatorNode(proxy));
                    }
                });
                if (proxyInfo.length() > 0) {
                    proxyInfo = String.valueOf(proxyInfo) + " / ";
                }
                String string = name = locatorNode.get() != null ? ((ILocatorNode)locatorNode.get()).getPeer().getName() : proxy.getID();
                if (name == null || name.trim().length() == 0) {
                    name = locatorNode.get() != null ? ((ILocatorNode)locatorNode.get()).getPeer().getID() : proxy.getID();
                }
                proxyInfo = String.valueOf(proxyInfo) + name.trim();
                ++n2;
            }
            this.proxyControl.setEditFieldControlText(proxyInfo);
        }
        if (data.containsKey("Name") && this.peerNameControl != null) {
            String name = data.getStringProperty("Name");
            int i = 1;
            while (this.usedNames.contains(name.toUpperCase())) {
                name = String.valueOf(data.getStringProperty("Name")) + " (" + i + ")";
                ++i;
            }
            this.peerNameControl.setEditFieldControlText(name);
        }
        if ((transportType = data.getStringProperty("TransportName")) != null) {
            IWizardConfigurationPanel panel;
            if (this.transportTypeControl != null) {
                this.transportTypeControl.setSelectedTransportType(transportType);
                if (!this.transportTypeControl.getSelectedTransportType().equals(transportType)) {
                    this.transportTypeControl.setSelectedTransportType("Custom");
                }
                this.transportTypePanelControl.showConfigurationPanel(this.transportTypeControl.getSelectedTransportType());
            }
            IWizardConfigurationPanel iWizardConfigurationPanel = panel = this.transportTypePanelControl != null ? this.transportTypePanelControl.getActiveConfigurationPanel() : null;
            if (panel instanceof IDataExchangeNode) {
                ((IDataExchangeNode)panel).setupData(data);
            }
        }
    }

    protected void updatePeerAttributes(IPropertiesContainer peerAttributes) {
        Map<String, String> additionalAttributes;
        IWizardConfigurationPanel panel;
        String value;
        Assert.isNotNull((Object)peerAttributes);
        if (this.getControl() == null) {
            return;
        }
        peerAttributes.setProperty("ID", (Object)this.uuid.toString());
        peerAttributes.setProperty("Proxies", (Object)this.proxies);
        String string = value = this.peerNameControl != null ? this.peerNameControl.getEditFieldControlText() : null;
        if (value != null && !"".equals(value)) {
            peerAttributes.setProperty("Name", (Object)value);
        }
        String string2 = value = this.transportTypeControl != null ? this.transportTypeControl.getSelectedTransportType() : null;
        if (value != null && !"".equals(value) && !"Custom".equals(value)) {
            peerAttributes.setProperty("TransportName", (Object)value);
        }
        IWizardConfigurationPanel iWizardConfigurationPanel = panel = this.transportTypePanelControl != null ? this.transportTypePanelControl.getConfigurationPanel(value) : null;
        if (panel instanceof IDataExchangeNode) {
            PropertiesContainer data = new PropertiesContainer();
            ((IDataExchangeNode)panel).extractData((IPropertiesContainer)data);
            for (String key : data.getProperties().keySet()) {
                value = data.getStringProperty(key);
                if (value == null || "".equals(value)) continue;
                peerAttributes.setProperty(key, (Object)value);
            }
        }
        Map<String, String> map = additionalAttributes = this.tablePart != null ? this.tablePart.getAttributes() : null;
        if (additionalAttributes != null && !additionalAttributes.isEmpty()) {
            peerAttributes.addProperties(additionalAttributes);
        }
        if (this.isAutoConnect()) {
            peerAttributes.setProperty("autoConnect", true);
        }
    }

    public void extractData(IPropertiesContainer data) {
        Assert.isNotNull((Object)data);
        this.updatePeerAttributes(data);
    }

    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            if (this.peerNameControl != null) {
                this.peerNameControl.saveWidgetValues(settings, null);
            }
            if (this.transportTypeControl != null) {
                this.transportTypeControl.saveWidgetValues(settings, null);
            }
            if (this.transportTypePanelControl != null) {
                this.transportTypePanelControl.saveWidgetValues(settings, null);
            }
        }
    }

    public void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            if (this.peerNameControl != null) {
                this.peerNameControl.restoreWidgetValues(settings, null);
            }
            if (this.transportTypeControl != null) {
                this.transportTypeControl.restoreWidgetValues(settings, null);
            }
            if (this.transportTypePanelControl != null) {
                this.transportTypePanelControl.restoreWidgetValues(settings, null);
            }
        }
    }

    protected void initializeUsedNameList() {
        this.usedNames.clear();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IPeerNode[] peers;
                IPeerNode[] iPeerNodeArray = peers = ModelManager.getPeerModel().getPeerNodes();
                int n = peers.length;
                int n2 = 0;
                while (n2 < n) {
                    IPeerNode peerNode = iPeerNodeArray[n2];
                    String name = peerNode.getPeer().getName();
                    Assert.isNotNull((Object)name);
                    if (!"".equals(name) && !NewTargetWizardPage.this.usedNames.contains(name)) {
                        NewTargetWizardPage.this.usedNames.add(name.trim().toUpperCase());
                    }
                    ++n2;
                }
            }
        };
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        Protocol.invokeAndWait((Runnable)runnable);
    }

    protected boolean hasAutoConnectButton() {
        return true;
    }

    public final boolean isAutoConnect() {
        return this.autoConnect;
    }

    private class MyTransportTypeControl
    extends TransportTypeControl {
        public MyTransportTypeControl(IDialogPage parentPage) {
            super(parentPage);
        }

        public void widgetSelected(SelectionEvent e) {
            if (NewTargetWizardPage.this.transportTypePanelControl != null) {
                NewTargetWizardPage.this.transportTypePanelControl.showConfigurationPanel(this.getSelectedTransportType());
                NewTargetWizardPage.this.validate();
            }
        }
    }

    private class MyTransportTypePanelControl
    extends TransportTypePanelControl {
        public MyTransportTypePanelControl(IDialogPage parentPage) {
            super(parentPage);
        }

        public boolean isValid() {
            String transportType;
            boolean valid = super.isValid();
            if (!valid) {
                return false;
            }
            if (NewTargetWizardPage.this.transportTypeControl != null && (transportType = NewTargetWizardPage.this.transportTypeControl.getSelectedTransportType()) != null) {
                IWizardConfigurationPanel panel = this.getConfigurationPanel(transportType);
                Assert.isNotNull((Object)panel);
                valid = panel.isValid();
                this.setMessage(panel.getMessage(), panel.getMessageType());
            }
            return valid;
        }
    }
}

