/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.permission.observatory;

import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.eclipse.passage.lic.internal.base.permission.observatory.CheckSchedule;
import org.eclipse.passage.lic.internal.base.permission.observatory.Limited;
import org.eclipse.passage.lic.internal.base.permission.observatory.Pool;

final class Guard<T extends Limited>
implements Runnable {
    private final long period;
    private final Pool<T> pool;
    private final Consumer<Set<T>> onExpire;
    private final Executor executor;

    Guard(CheckSchedule schedule, Pool<T> pool, Consumer<Set<T>> onExpire) {
        this.period = schedule.seconds();
        this.pool = pool;
        this.onExpire = onExpire;
        this.executor = Executors.newSingleThreadExecutor();
    }

    @Override
    public void run() {
        while (true) {
            this.rest();
            this.check();
        }
    }

    private void check() {
        this.executor.execute(() -> this.pool.popExpired().dispose(this.onExpire));
    }

    private void rest() {
        try {
            Thread.sleep(this.period * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

