/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester;

import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import org.eclipse.jubula.rc.common.driver.CheckWithTimeoutQueuer;
import org.eclipse.jubula.rc.common.driver.DragAndDropHelper;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.table.Cell;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeOperationContext;
import org.eclipse.jubula.rc.common.implclasses.tree.ExpandCollapseTreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.INodePath;
import org.eclipse.jubula.rc.common.implclasses.tree.StandardDepthFirstTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.TreeNodeOperation;
import org.eclipse.jubula.rc.common.tester.AbstractTreeTableTester;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IComponent;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITreeComponent;
import org.eclipse.jubula.rc.common.tester.interfaces.ITableActions;
import org.eclipse.jubula.rc.common.util.KeyStrokeUtil;
import org.eclipse.jubula.rc.common.util.Verifier;
import org.eclipse.jubula.rc.swt.components.SWTCell;
import org.eclipse.jubula.rc.swt.driver.KeyCodeConverter;
import org.eclipse.jubula.rc.swt.tester.TableTester;
import org.eclipse.jubula.rc.swt.tester.util.CAPUtil;
import org.eclipse.jubula.rc.swt.tester.util.ToggleCheckboxOperation;
import org.eclipse.jubula.rc.swt.tester.util.TreeOperationContext;
import org.eclipse.jubula.rc.swt.tester.util.VerifyCheckboxOperation;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeTester
extends AbstractTreeTableTester
implements ITableActions {
    private Tree getTreeTable() {
        return (Tree)this.getComponent().getRealComponent();
    }

    public void rcCheckPropertyAtMousePosition(final String name, final String value, final String operator, int timeout) {
        CheckWithTimeoutQueuer.invokeAndWait((String)"rcCheckPropertyAtMousePosition", (long)timeout, (Runnable)new Runnable(){

            public void run() {
                Object cell = null;
                int numColumns = (Integer)TreeTester.this.getEventThreadQueuer().invokeAndWait("checkColumnIndex", (IRunnable)new IRunnable<Integer>(){

                    public Integer run() {
                        return TreeTester.this.getTreeTable().getColumnCount();
                    }
                });
                cell = numColumns > 0 ? TreeTester.this.getCellAtMousePosition() : TreeTester.this.getNodeAtMousePosition();
                ITreeComponent bean = TreeTester.this.getTreeAdapter();
                String propToStr = bean.getPropertyValueOfCell(name, cell);
                Verifier.match((String)propToStr, (String)value, (String)operator);
            }
        });
    }

    public void rcVerifyTextAtMousePosition(String pattern, String operator, int timeout) {
        TableTester tableTester = new TableTester((IComponent)this.getTreeAdapter());
        tableTester.rcVerifyTextAtMousePosition(pattern, operator, timeout);
    }

    public void rcVerifyCellTextAtMousePosition(String pattern, String operator, int timeout) {
        this.rcVerifyTextAtMousePosition(pattern, operator, timeout);
    }

    public void rcDragByTextPath(int mouseButton, String modifier, String pathType, int preAscend, String treePath, String operator) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        SwtUtils.waitForDisplayIdle(this.getTreeTable().getDisplay());
        this.rcSelect(pathType, preAscend, treePath, operator, 0, 1, ValueSets.BinaryChoice.no.rcValue());
        SwtUtils.waitForDisplayIdle(this.getTreeTable().getDisplay());
    }

    public void rcDropByTextPath(String pathType, int preAscend, String treePath, String operator, int delayBeforeDrop) {
        final DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        final IRobot robot = this.getRobot();
        try {
            this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
            this.getEventThreadQueuer().invokeAndWait("rcDropByTextPath - perform drag", (IRunnable)new IRunnable<Void>(){

                public Void run() throws StepExecutionException {
                    robot.mousePress(dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
                    CAPUtil.shakeMouse();
                    return null;
                }
            });
            this.postMouseMovementEvent();
            this.rcSelect(pathType, preAscend, treePath, operator, 0, 1, ValueSets.BinaryChoice.no.rcValue());
            SwtUtils.waitForDisplayIdle(this.getTreeTable().getDisplay());
            TreeTester.waitBeforeDrop((int)delayBeforeDrop);
        }
        finally {
            robot.mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            SwtUtils.waitForDisplayIdle(this.getTreeTable().getDisplay());
        }
    }

    public void rcDragByIndexPath(int mouseButton, String modifier, String pathType, int preAscend, String indexPath) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        SwtUtils.waitForDisplayIdle(this.getTreeTable().getDisplay());
        this.rcSelectByIndices(pathType, preAscend, indexPath, 0, 1, ValueSets.BinaryChoice.no.rcValue());
        SwtUtils.waitForDisplayIdle(this.getTreeTable().getDisplay());
    }

    public void rcDropByIndexPath(String pathType, int preAscend, String indexPath, int delayBeforeDrop) {
        final DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        final IRobot robot = this.getRobot();
        try {
            this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
            this.getEventThreadQueuer().invokeAndWait("rcDropByIndexPath - perform drag", (IRunnable)new IRunnable<Void>(){

                public Void run() throws StepExecutionException {
                    robot.mousePress(dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
                    CAPUtil.shakeMouse();
                    return null;
                }
            });
            this.postMouseMovementEvent();
            this.rcSelectByIndices(pathType, preAscend, indexPath, 0, 1, ValueSets.BinaryChoice.no.rcValue());
            SwtUtils.waitForDisplayIdle(this.getTreeTable().getDisplay());
            TreeTester.waitBeforeDrop((int)delayBeforeDrop);
        }
        finally {
            robot.mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            SwtUtils.waitForDisplayIdle(this.getTreeTable().getDisplay());
        }
    }

    private void postMouseMovementEvent() {
        Event wakeEvent = new Event();
        java.awt.Point location = MouseInfo.getPointerInfo().getLocation();
        if (location.x - 400 < 0) {
            wakeEvent.x = location.x + 400;
        }
        if (location.y - 400 < 0) {
            wakeEvent.y = location.y + 400;
        }
        wakeEvent.type = 5;
        this.getTreeTable().getDisplay().post(wakeEvent);
        this.waitForDisplayUpdate();
    }

    protected Object getNodeAtMousePosition() throws StepExecutionException {
        return this.getEventThreadQueuer().invokeAndWait("getItemAtMousePosition", (IRunnable)new IRunnable<TreeItem>(){

            public TreeItem run() throws StepExecutionException {
                Point mousePos = SwtUtils.convertToSwtPoint(TreeTester.this.getRobot().getCurrentMousePosition());
                ItemAtPointTreeNodeOperation op = new ItemAtPointTreeNodeOperation(mousePos, SwtUtils.getWidgetBounds((Widget)TreeTester.this.getTreeTable()));
                TreeItem topItem = TreeTester.this.getTreeTable().getTopItem();
                if (topItem != null) {
                    StandardDepthFirstTraverser traverser = new StandardDepthFirstTraverser((AbstractTreeOperationContext)new TreeOperationContext(TreeTester.this.getEventThreadQueuer(), TreeTester.this.getRobot(), TreeTester.this.getTreeTable()));
                    traverser.traversePath((TreeNodeOperation)op, (Object)topItem);
                    if (op.getItemAtPoint() != null) {
                        return op.getItemAtPoint();
                    }
                }
                throw new StepExecutionException("No tree node found at mouse position.", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
            }
        });
    }

    private Cell getCellAtMousePosition() throws StepExecutionException {
        final Tree tree = this.getTreeTable();
        final java.awt.Point awtMousePos = this.getRobot().getCurrentMousePosition();
        Cell returnvalue = (Cell)this.getEventThreadQueuer().invokeAndWait("getCellAtMousePosition", (IRunnable)new IRunnable<Cell>(){
            private int m_rowCount = 0;

            public Cell run() throws StepExecutionException {
                Cell cell = null;
                TreeItem[] treeItemArray = tree.getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    cell = this.findCell(item);
                    if (cell != null) break;
                    ++n2;
                }
                if (cell == null) {
                    throw new StepExecutionException("No cell under mouse position found!", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
                }
                return cell;
            }

            private Cell findCell(TreeItem item) {
                Cell cell = null;
                if (tree.getColumnCount() != 0) {
                    tree.getColumnCount();
                }
                int col = 0;
                while (col < tree.getColumnCount()) {
                    org.eclipse.swt.graphics.Rectangle itemBounds = item.getBounds(col);
                    Point absItemBounds = tree.toDisplay(itemBounds.x, itemBounds.y);
                    Rectangle absRect = new Rectangle(absItemBounds.x, absItemBounds.y, itemBounds.width, itemBounds.height);
                    if (absRect.contains(awtMousePos)) {
                        cell = new SWTCell(this.m_rowCount, col, item);
                    }
                    ++col;
                }
                ++this.m_rowCount;
                if (cell == null && item.getExpanded()) {
                    TreeItem[] treeItemArray = item.getItems();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem subItem = treeItemArray[n2];
                        cell = this.findCell(subItem);
                        if (cell != null) break;
                        ++n2;
                    }
                }
                return cell;
            }
        });
        return returnvalue;
    }

    private static org.eclipse.swt.graphics.Rectangle getCellBounds(IEventThreadQueuer etq, final Tree table, int row, final int col, final TreeItem ti) {
        org.eclipse.swt.graphics.Rectangle cellBounds = (org.eclipse.swt.graphics.Rectangle)etq.invokeAndWait("getCellBounds", (IRunnable)new IRunnable<org.eclipse.swt.graphics.Rectangle>(){

            public org.eclipse.swt.graphics.Rectangle run() {
                int column = table.getColumnCount() > 0 || col > 0 ? col : 0;
                org.eclipse.swt.graphics.Rectangle r = ti.getBounds(column);
                String text = CAPUtil.getWidgetText((Widget)ti, "TEST_TESTABLE_TEXT_" + column, ti.getText(column));
                Image image = ti.getImage(column);
                if (text != null && text.length() != 0) {
                    GC gc = new GC((Drawable)table);
                    int charWidth = 0;
                    try {
                        FontMetrics fm = gc.getFontMetrics();
                        charWidth = fm.getAverageCharWidth();
                    }
                    finally {
                        gc.dispose();
                    }
                    r.width = text.length() * charWidth;
                    if (image != null) {
                        r.width += image.getBounds().width;
                    }
                } else if (image != null) {
                    r.width = image.getBounds().width;
                }
                if (column > 0) {
                    TreeColumn tc = table.getColumn(column);
                    int alignment = tc.getAlignment();
                    if (alignment == 0x1000000) {
                        r.x = (int)((double)r.x + ((double)tc.getWidth() / 2.0 - (double)r.width / 2.0));
                    }
                    if (alignment == 131072) {
                        r.x += tc.getWidth() - r.width;
                    }
                }
                return new org.eclipse.swt.graphics.Rectangle(r.x, r.y, r.width, r.height);
            }
        });
        return cellBounds;
    }

    public void rcToggleCheckbox(String pathType, int preAscend, String treePath, String operator) throws StepExecutionException {
        this.toggleCheckBoxByPath(pathType, preAscend, this.createStringNodePath(this.splitTextTreePath(treePath), operator));
    }

    public void rcToggleCheckboxByIndices(String pathType, int preAscend, String indexPath) throws StepExecutionException {
        this.toggleCheckBoxByPath(pathType, preAscend, this.createIndexNodePath(this.splitIndexTreePath(indexPath)));
    }

    public void rcVerifyCheckbox(final String pathType, final int preAscend, final String treePath, final String operator, final boolean checked, int timeout) throws StepExecutionException {
        CheckWithTimeoutQueuer.invokeAndWait((String)"rcVerifyCheckBox", (long)timeout, (Runnable)new Runnable(){

            public void run() {
                TreeTester.this.verifyCheckBoxByPath(pathType, preAscend, TreeTester.this.createStringNodePath(TreeTester.this.splitTextTreePath(treePath), operator), checked);
            }
        });
    }

    public void rcVerifyCheckboxByIndices(final String pathType, final int preAscend, final String indexPath, final boolean checked, int timeout) throws StepExecutionException {
        CheckWithTimeoutQueuer.invokeAndWait((String)"rcVerifyChecktboxByIndices", (long)timeout, (Runnable)new Runnable(){

            public void run() {
                TreeTester.this.verifyCheckBoxByPath(pathType, preAscend, TreeTester.this.createIndexNodePath(TreeTester.this.splitIndexTreePath(indexPath)), checked);
            }
        });
    }

    public void rcVerifySelectedCheckbox(final boolean checked, int timeout) throws StepExecutionException {
        CheckWithTimeoutQueuer.invokeAndWait((String)"rcVerifySelectedCheckbox", (long)timeout, (Runnable)new Runnable(){

            public void run() {
                Boolean checkSelected = (Boolean)TreeTester.this.getEventThreadQueuer().invokeAndWait("rcVerifyTreeCheckbox", (IRunnable)new IRunnable<Boolean>(){

                    public Boolean run() {
                        AbstractTreeOperationContext context = ((ITreeComponent)TreeTester.this.getComponent()).getContext();
                        TreeItem node = (TreeItem)TreeTester.this.getSelectedNode(context);
                        return node.getChecked();
                    }
                });
                Verifier.equals((boolean)checked, (boolean)checkSelected);
            }
        });
    }

    private void verifyCheckBoxByPath(String pathType, int preAscend, INodePath objectPath, boolean checked) {
        ExpandCollapseTreeNodeOperation expOp = new ExpandCollapseTreeNodeOperation(false);
        TreeOperationContext context = new TreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.getTreeTable());
        VerifyCheckboxOperation checkboxOp = new VerifyCheckboxOperation(checked, context);
        INodePath subPath = objectPath.subPath(0, objectPath.getLength() - 1);
        this.traverseTreeByPath(subPath, pathType, preAscend, (TreeNodeOperation)expOp);
        this.traverseLastElementByPath(objectPath, pathType, preAscend, (TreeNodeOperation)checkboxOp);
    }

    private void toggleCheckBoxByPath(String pathType, int preAscend, INodePath objectPath) {
        ExpandCollapseTreeNodeOperation expOp = new ExpandCollapseTreeNodeOperation(false);
        TreeOperationContext context = new TreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.getTreeTable());
        ToggleCheckboxOperation selCheckboxOp = new ToggleCheckboxOperation(context);
        INodePath subPath = objectPath.subPath(0, objectPath.getLength() - 1);
        this.traverseTreeByPath(subPath, pathType, preAscend, (TreeNodeOperation)expOp);
        this.traverseLastElementByPath(objectPath, pathType, preAscend, (TreeNodeOperation)selCheckboxOp);
    }

    private void waitForDisplayUpdate() {
        ((Control)this.getComponent().getRealComponent()).getDisplay().syncExec(new Runnable(){

            public void run() {
                ((Control)TreeTester.this.getComponent().getRealComponent()).getDisplay().update();
            }
        });
    }

    protected void pressOrReleaseModifiers(String modifier, boolean press) {
        IRobot robot = this.getRobot();
        StringTokenizer modTok = new StringTokenizer(KeyStrokeUtil.getModifierString((String)modifier), " ");
        while (modTok.hasMoreTokens()) {
            String mod = modTok.nextToken();
            int keyCode = KeyCodeConverter.getKeyCode(mod);
            if (press) {
                robot.keyPress(null, keyCode);
                continue;
            }
            robot.keyRelease(null, keyCode);
        }
    }

    private TableTester getTableTester() {
        return new TableTester((IComponent)this.getTreeAdapter());
    }

    public String rcStorePropertyValueAtMousePosition(String variableName, String propertyName) {
        return this.getTableTester().rcStorePropertyValueAtMousePosition(variableName, propertyName);
    }

    public void rcSelectCell(String row, String rowOperator, String col, String colOperator, int clickCount, int xPos, String xUnits, int yPos, String yUnits, String extendSelection, int button) throws StepExecutionException {
        this.getTableTester().rcSelectCell(row, rowOperator, col, colOperator, clickCount, xPos, xUnits, yPos, yUnits, extendSelection, button);
    }

    public void rcVerifyEditable(boolean editable, String row, String rowOperator, String col, String colOperator, int timeout) {
        this.getTableTester().rcVerifyEditable(editable, row, rowOperator, col, colOperator, timeout);
    }

    public void rcVerifyEditableMousePosition(boolean editable, int timeout) {
        this.getTableTester().rcVerifyEditableMousePosition(editable, timeout);
    }

    public void rcVerifyText(String text, String operator, String row, String rowOperator, String col, String colOperator, int timeout) throws StepExecutionException {
        this.getTableTester().rcVerifyText(text, operator, row, rowOperator, col, colOperator, timeout);
    }

    public void rcVerifyValueInColumn(String col, String colOperator, String value, String operator, String searchType, boolean exists, int timeout) throws StepExecutionException {
        this.getTableTester().rcVerifyValueInColumn(col, colOperator, value, operator, searchType, exists, timeout);
    }

    public void rcVerifyValueInRow(String row, String rowOperator, String value, String operator, String searchType, boolean exists, int timeout) throws StepExecutionException {
        this.getTableTester().rcVerifyValueInRow(row, rowOperator, value, operator, searchType, exists, timeout);
    }

    public void rcSelectRowByValue(String col, String colOperator, String value, String regexOp, int clickCount, String extendSelection, String searchType, int button) {
        this.getTableTester().rcSelectRowByValue(col, colOperator, value, regexOp, clickCount, extendSelection, searchType, button);
    }

    public void rcSelectCellByColValue(String row, String rowOperator, String value, String regex, int clickCount, String extendSelection, String searchType, int button) {
        this.getTableTester().rcSelectCellByColValue(row, rowOperator, value, regex, clickCount, extendSelection, searchType, button);
    }

    public String rcReadValue(String variable, String row, String rowOperator, String col, String colOperator) {
        return this.getTableTester().rcReadValue(variable, row, rowOperator, col, colOperator);
    }

    public String rcReadValue(String row, String rowOperator, String col, String colOperator) {
        return this.getTableTester().rcReadValue(row, rowOperator, col, colOperator);
    }

    public void rcCheckExistenceOfColumn(String column, String columnOperator, boolean exists, int timeout) {
        this.getTableTester().rcCheckExistenceOfColumn(column, columnOperator, exists, timeout);
    }

    public String rcReadValueAtMousePosition(String variable) {
        return this.getTableTester().rcReadValueAtMousePosition(variable);
    }

    public String rcReadValueAtMousePosition() {
        return this.getTableTester().rcReadValueAtMousePosition();
    }

    private static final class ItemAtPointTreeNodeOperation
    extends AbstractTreeNodeOperation {
        private TreeItem m_itemAtPoint;
        private Point m_absPoint;
        private org.eclipse.swt.graphics.Rectangle m_absTreeBounds;

        public ItemAtPointTreeNodeOperation(Point absPoint, org.eclipse.swt.graphics.Rectangle absTreeBounds) {
            this.m_absPoint = absPoint;
            this.m_absTreeBounds = absTreeBounds;
        }

        public boolean operate(Object node) throws StepExecutionException {
            if (this.getContext().isVisible(node) && node instanceof TreeItem) {
                TreeItem currentItem = (TreeItem)node;
                org.eclipse.swt.graphics.Rectangle absItemBounds = SwtUtils.getBounds(currentItem);
                absItemBounds.x = this.m_absTreeBounds.x;
                absItemBounds.width = this.m_absTreeBounds.width;
                if (SwtUtils.containsInclusive(absItemBounds, this.m_absPoint)) {
                    this.m_itemAtPoint = currentItem;
                    return false;
                }
            }
            return true;
        }

        public TreeItem getItemAtPoint() {
            return this.m_itemAtPoint;
        }
    }
}

