/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.makefile.posix;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.makefile.IAutomaticVariable;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.core.makefile.IMakefileReaderProvider;
import org.eclipse.cdt.make.internal.core.makefile.AbstractMakefile;
import org.eclipse.cdt.make.internal.core.makefile.BadDirective;
import org.eclipse.cdt.make.internal.core.makefile.Command;
import org.eclipse.cdt.make.internal.core.makefile.Comment;
import org.eclipse.cdt.make.internal.core.makefile.DefaultRule;
import org.eclipse.cdt.make.internal.core.makefile.Directive;
import org.eclipse.cdt.make.internal.core.makefile.EmptyLine;
import org.eclipse.cdt.make.internal.core.makefile.IgnoreRule;
import org.eclipse.cdt.make.internal.core.makefile.InferenceRule;
import org.eclipse.cdt.make.internal.core.makefile.MacroDefinition;
import org.eclipse.cdt.make.internal.core.makefile.MakefileReader;
import org.eclipse.cdt.make.internal.core.makefile.PosixRule;
import org.eclipse.cdt.make.internal.core.makefile.PreciousRule;
import org.eclipse.cdt.make.internal.core.makefile.Rule;
import org.eclipse.cdt.make.internal.core.makefile.SccsGetRule;
import org.eclipse.cdt.make.internal.core.makefile.SilentRule;
import org.eclipse.cdt.make.internal.core.makefile.SpecialRule;
import org.eclipse.cdt.make.internal.core.makefile.SuffixesRule;
import org.eclipse.cdt.make.internal.core.makefile.Target;
import org.eclipse.cdt.make.internal.core.makefile.TargetRule;
import org.eclipse.cdt.make.internal.core.makefile.Util;
import org.eclipse.cdt.make.internal.core.makefile.posix.PosixMakefileUtil;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.CoreException;

public class PosixMakefile
extends AbstractMakefile {
    private IDirective[] builtins = new IDirective[0];
    private IAutomaticVariable[] automaticVariables = new IAutomaticVariable[0];
    private IMakefileReaderProvider makefileReaderProvider;

    public PosixMakefile() {
        super(null);
    }

    @Override
    public IMakefileReaderProvider getMakefileReaderProvider() {
        return this.makefileReaderProvider;
    }

    @Override
    public void parse(String name, Reader reader) throws IOException {
        this.parse(URIUtil.toURI((String)name), new MakefileReader(reader));
    }

    @Override
    public void parse(URI fileURI, IMakefileReaderProvider makefileReaderProvider) throws IOException {
        MakefileReader reader;
        this.makefileReaderProvider = makefileReaderProvider;
        if (makefileReaderProvider == null) {
            try {
                reader = new MakefileReader(new InputStreamReader(EFS.getStore((URI)fileURI).openInputStream(0, null)));
            }
            catch (CoreException e) {
                MakeCorePlugin.log(e);
                throw new IOException(e.getMessage());
            }
        } else {
            reader = new MakefileReader(makefileReaderProvider.getReader(fileURI));
        }
        this.parse(fileURI, reader);
    }

    @Override
    public void parse(URI fileURI, Reader reader) throws IOException {
        this.parse(fileURI, new MakefileReader(reader));
    }

    /*
     * Unable to fully structure code
     */
    protected void parse(URI fileURI, MakefileReader reader) throws IOException {
        rules = null;
        startLine = 0;
        endLine = 0;
        this.clearDirectives();
        this.setFileURI(fileURI);
lbl6:
        // 3 sources

        try {
            while ((line = reader.readLine()) != null) {
                block17: {
                    block18: {
                        block16: {
                            startLine = endLine + 1;
                            endLine = reader.getLineNumber();
                            if (!PosixMakefileUtil.isCommand(line)) break block16;
                            cmd = new Command(this, line);
                            cmd.setLines(startLine, endLine);
                            if (rules == null) break block16;
                            var11_21 = rules;
                            var10_17 = rules.length;
                            var9_10 = 0;
                            while (var9_10 < var10_17) {
                                rule = var11_21[var9_10];
                                rule.addDirective(cmd);
                                rule.setEndLine(endLine);
                                ++var9_10;
                            }
                            ** GOTO lbl6
                        }
                        if ((pound = Util.indexOfComment(line)) != -1) {
                            cmt = new Comment(this, line.substring(pound + 1));
                            cmt.setLines(startLine, endLine);
                            if (rules != null) {
                                var12_25 = rules;
                                var11_22 = rules.length;
                                var10_18 = 0;
                                while (var10_18 < var11_22) {
                                    rule = var12_25[var10_18];
                                    rule.addDirective(cmt);
                                    rule.setEndLine(endLine);
                                    ++var10_18;
                                }
                            } else {
                                this.addDirective(cmt);
                            }
                            line = line.substring(0, pound);
                            if (Util.isEmptyLine(line)) continue;
                        }
                        if (!Util.isEmptyLine(line)) break block17;
                        empty = new EmptyLine(this);
                        empty.setLines(startLine, endLine);
                        if (rules == null) break block18;
                        var12_25 = rules;
                        var11_23 = rules.length;
                        var10_19 = 0;
                        while (var10_19 < var11_23) {
                            rule = var12_25[var10_19];
                            rule.addDirective(empty);
                            rule.setEndLine(endLine);
                            ++var10_19;
                        }
                        ** GOTO lbl6
                    }
                    this.addDirective(empty);
                    continue;
                }
                rules = null;
                special = this.processSpecialRule(line);
                if (special != null) {
                    rules = new Rule[]{special};
                    special.setLines(startLine, endLine);
                    this.addDirective(special);
                    continue;
                }
                if (PosixMakefileUtil.isInferenceRule(line)) {
                    irule = this.parseInferenceRule(line);
                    irule.setLines(startLine, endLine);
                    this.addDirective(irule);
                    rules = new Rule[]{irule};
                    continue;
                }
                if (PosixMakefileUtil.isMacroDefinition(line)) {
                    stmt = this.parseMacroDefinition(line);
                    stmt.setLines(startLine, endLine);
                    this.addDirective(stmt);
                    continue;
                }
                if (PosixMakefileUtil.isTargetRule(line)) {
                    var13_27 = trules = this.parseTargetRule(line);
                    var12_26 = trules.length;
                    var11_24 = 0;
                    while (var11_24 < var12_26) {
                        trule = var13_27[var11_24];
                        trule.setLines(startLine, endLine);
                        this.addDirective(trule);
                        ++var11_24;
                    }
                    rules = trules;
                    continue;
                }
                stmt = new BadDirective(this, line);
                stmt.setLines(startLine, endLine);
                this.addDirective(stmt);
            }
            this.setLines(1, endLine);
        }
        finally {
            reader.close();
        }
    }

    @Override
    public IDirective[] getBuiltins() {
        return this.builtins;
    }

    @Override
    public IAutomaticVariable[] getAutomaticVariables() {
        return this.automaticVariables;
    }

    protected SpecialRule processSpecialRule(String line) {
        line = line.trim();
        String keyword = null;
        String[] reqs = null;
        SpecialRule special = null;
        int index = Util.indexOf(line, ':');
        if (index != -1) {
            keyword = line.substring(0, index).trim();
            String req = line.substring(index + 1);
            reqs = PosixMakefileUtil.findPrerequisites(req);
        } else {
            keyword = line;
            reqs = new String[]{};
        }
        if (keyword.equals(".IGNORE")) {
            special = new IgnoreRule((Directive)this, reqs);
        } else if (keyword.equals(".POSIX")) {
            special = new PosixRule(this);
        } else if (keyword.equals(".PRECIOUS")) {
            special = new PreciousRule((Directive)this, reqs);
        } else if (keyword.equals(".SILENT")) {
            special = new SilentRule((Directive)this, reqs);
        } else if (keyword.equals(".SUFFIXES")) {
            special = new SuffixesRule((Directive)this, reqs);
        } else if (keyword.equals(".DEFAULT")) {
            special = new DefaultRule((Directive)this, new Command[0]);
        } else if (keyword.equals(".SCCS_GET")) {
            special = new SccsGetRule((Directive)this, new Command[0]);
        }
        return special;
    }

    protected InferenceRule parseInferenceRule(String line) {
        int index = Util.indexOf(line, ':');
        String tgt = index != -1 ? line.substring(0, index) : line;
        return new InferenceRule(this, new Target(tgt));
    }

    protected MacroDefinition parseMacroDefinition(String line) {
        String value;
        String name;
        int index = Util.indexOf(line, '=');
        if (index != -1) {
            name = line.substring(0, index).trim();
            value = line.substring(index + 1).trim();
        } else {
            name = line;
            value = "";
        }
        return new MacroDefinition(this, name, new StringBuffer(value));
    }

    protected TargetRule[] parseTargetRule(String line) {
        String[] reqs;
        String[] targets;
        String cmd = null;
        int index = Util.indexOf(line, ':');
        if (index != -1) {
            String target = line.substring(0, index);
            targets = PosixMakefileUtil.findTargets(target);
            String req = line.substring(index + 1);
            int semicolon = Util.indexOf(req, ';');
            if (semicolon != -1) {
                String c = req.substring(semicolon + 1).trim();
                if (c.length() > 0) {
                    cmd = c;
                }
                req = req.substring(0, semicolon);
            }
            reqs = PosixMakefileUtil.findPrerequisites(req);
        } else {
            targets = PosixMakefileUtil.findTargets(line);
            reqs = new String[]{};
        }
        TargetRule[] targetRules = new TargetRule[targets.length];
        int i = 0;
        while (i < targets.length) {
            targetRules[i] = new TargetRule((Directive)this, new Target(targets[i]), reqs);
            if (cmd != null) {
                Command command = new Command(this, cmd);
                targetRules[i].addDirective(command);
            }
            ++i;
        }
        return targetRules;
    }
}

