/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.IActionEvaluator;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.IChartObject;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.MarkerLine;
import org.eclipse.birt.chart.model.component.MarkerRange;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.type.AreaSeries;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.util.ChartDefaultValueUtil;
import org.eclipse.birt.chart.model.util.ChartValueUpdater;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartCheckbox;
import org.eclipse.birt.chart.ui.swt.ChartCombo;
import org.eclipse.birt.chart.ui.swt.ChartPreviewPainter;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartPreviewPainter;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartSubType;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartType;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.ISeriesUIProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.ITaskChangeListener;
import org.eclipse.birt.chart.ui.swt.interfaces.ITaskPreviewable;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartUIExtensionsImpl;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizard;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.preview.ChartLivePreviewThread;
import org.eclipse.birt.chart.ui.swt.wizard.preview.LivePreviewTask;
import org.eclipse.birt.chart.ui.util.ChartCacheManager;
import org.eclipse.birt.chart.ui.util.ChartUIExtensionUtil;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.core.ui.frameworks.taskwizard.SimpleTask;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.IWizardContext;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TaskSelectType
extends SimpleTask
implements SelectionListener,
ITaskChangeListener,
ITaskPreviewable {
    protected Chart chartModel = null;
    protected ChartAdapter adapter = null;
    protected Composite cmpType = null;
    protected Composite cmpMisc = null;
    private Composite cmpRight = null;
    protected Composite cmpLeft = null;
    private Composite cmpTypeButtons = null;
    private Composite cmpSubTypes = null;
    protected IChartPreviewPainter previewPainter = null;
    private Canvas previewCanvas = null;
    protected String sSubType = null;
    protected String sType = null;
    protected String sOldType = null;
    protected String sDimension = null;
    protected Table table = null;
    private Vector<String> vSubTypeNames = null;
    protected Orientation orientation = null;
    protected Label lblOrientation = null;
    protected ChartCheckbox btnOrientation = null;
    protected Label lblMultipleY = null;
    protected Combo cbMultipleY = null;
    protected Label lblSeriesType = null;
    protected Combo cbSeriesType = null;
    protected Label lblDimension;
    protected ChartCombo cbDimension = null;
    protected Label lblOutput;
    protected Combo cbOutput;
    protected SashForm foSashForm;
    protected int pageMargin = 80;
    protected static final String LEADING_BLANKS = "  ";
    protected static Hashtable<String, Series> htSeriesNames = null;
    protected static String[] outputFormats;
    protected static String[] outputDisplayNames;
    protected static final ILogger logger;
    protected List<TaskSelectTypeUIDescriptor> lstDescriptor = new LinkedList<TaskSelectTypeUIDescriptor>();

    static {
        logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui.extension/trace");
        try {
            outputFormats = ChartUtil.getSupportedOutputFormats();
            outputDisplayNames = ChartUtil.getSupportedOutputDisplayNames();
        }
        catch (ChartException e) {
            WizardBase.displayException((Throwable)e);
            outputFormats = new String[0];
            outputDisplayNames = new String[0];
        }
    }

    public TaskSelectType() {
        super(Messages.getString("TaskSelectType.TaskExp"));
        this.setDescription(Messages.getString("TaskSelectType.Task.Description"));
        if (this.chartModel != null) {
            this.sOldType = this.sType = this.chartModel.getType();
            this.sSubType = this.chartModel.getSubType();
            if (this.chartModel.isSetDimension()) {
                this.sDimension = this.translateDimensionString(this.chartModel.getDimension().getName());
                ChartCacheManager.getInstance().cacheDimension(this.sType, this.sDimension);
            }
            if (this.chartModel instanceof ChartWithAxes) {
                this.orientation = ((ChartWithAxes)this.chartModel).isSetOrientation() ? ((ChartWithAxes)this.chartModel).getOrientation() : null;
                ChartCacheManager.getInstance().cacheOrientation(this.sType, this.orientation);
            }
        }
    }

    public void createControl(Composite parent) {
        if (this.topControl == null || this.topControl.isDisposed()) {
            if (this.context != null) {
                this.chartModel = ((ChartWizardContext)this.context).getModel();
            }
            this.topControl = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = this.pageMargin;
            this.topControl.setLayout((Layout)gridLayout);
            this.topControl.setLayoutData((Object)new GridData(1536));
            this.placeComponents();
            this.updateAdapters();
            this.updateComponentsState(false);
        } else {
            this.updateComponentsState(true);
        }
        this.updateDimensionCombo(this.sType);
        if (this.getContext().isMoreAxesSupported()) {
            this.createAndDisplayTypesSheet(this.sType);
            this.setDefaultSubtypeSelection();
            this.cmpMisc.layout();
        }
        this.updateSelection();
        this.doPreview();
        this.bindHelp();
    }

    protected void updateComponentsState(boolean isUpdateUI) {
    }

    protected void bindHelp() {
        ChartUIUtil.bindHelp((Control)this.getControl(), (String)"org.eclipse.birt.chart.cshelp.SelectChartType_ID");
    }

    protected void placeComponents() {
        this.foSashForm = new SashForm(this.topControl, 512);
        GridLayout layout = new GridLayout();
        this.foSashForm.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 680;
        this.foSashForm.setLayoutData((Object)gridData);
        this.createTopPreviewArea((Composite)this.foSashForm);
        this.createBottomTypeArea((Composite)this.foSashForm);
        this.initUIPropertiesAndData();
    }

    protected void initUIPropertiesAndData() {
        this.setDefaultTypeSelection();
        if (this.chartModel == null) {
            this.createChartModel();
        }
        this.populateSeriesTypesList();
        if (this.btnOrientation != null) {
            Orientation defOrientation = ChartDefaultValueUtil.getDefaultOrientation((Chart)this.getContext().getModel());
            this.btnOrientation.setDefaultSelection(defOrientation == null ? false : defOrientation == Orientation.VERTICAL_LITERAL);
        }
    }

    protected void createChartModel() {
        this.refreshChart(this.sType, this.sSubType);
    }

    protected void createTopPreviewArea(Composite parent) {
        Composite cmpPreview = new Composite(parent, 0);
        cmpPreview.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 270;
        cmpPreview.setLayoutData((Object)gridData);
        Label label = new Label(cmpPreview, 0);
        label.setText(this.getChartPreviewTitle());
        this.previewCanvas = new Canvas(cmpPreview, 2048);
        this.previewCanvas.setLayoutData((Object)new GridData(1808));
        this.previewCanvas.setBackground(Display.getDefault().getSystemColor(22));
        this.previewPainter = this.createPreviewPainter();
    }

    protected String getChartPreviewTitle() {
        return Messages.getString("TaskSelectType.Label.Preview");
    }

    protected void createBottomTypeArea(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout();
        sc.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        sc.setLayoutData((Object)gridData);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        this.cmpType = new Composite((Composite)sc, 0);
        this.cmpType.setLayout((Layout)new GridLayout(2, false));
        this.cmpType.setLayoutData((Object)new GridData(768));
        sc.setContent((Control)this.cmpType);
        this.createLeftTypeTable(this.cmpType);
        this.populateChartTypes();
        this.createRightDetails(this.cmpType);
        Point size = this.cmpType.computeSize(-1, -1);
        sc.setMinSize(size);
    }

    private void createRightDetails(Composite parent) {
        this.cmpRight = new Composite(parent, 0);
        this.cmpRight.setLayout((Layout)new GridLayout());
        this.cmpRight.setLayoutData((Object)new GridData(1808));
        this.createComposite(new Vector<IChartSubType>());
        this.createMiscArea(this.cmpRight);
    }

    private void createMiscArea(Composite parent) {
        this.cmpMisc = new Composite(parent, 0);
        this.cmpMisc.setLayout((Layout)new GridLayout(4, false));
        this.cmpMisc.setLayoutData((Object)new GridData(1808));
        this.addDimensionUI();
        this.addMultipleAxesUI();
        this.addSeriesTypeUI();
        this.addOrientationUI();
        this.addOptionalUIDescriptor();
        this.createUIDescriptors(this.cmpMisc);
    }

    protected void addSeriesTypeUI() {
        this.addTypeUIDescriptor(new TaskSelectTypeUIDescriptor(this){

            @Override
            public int getIndex() {
                return 40;
            }

            @Override
            public void createControl(Composite parent) {
                lblSeriesType = new Label(parent, 64);
                GridData gd = new GridData(768);
                gd.horizontalIndent = 10;
                lblSeriesType.setLayoutData((Object)gd);
                lblSeriesType.setText(Messages.getString("TaskSelectType.Label.SeriesType"));
                lblSeriesType.setEnabled(false);
                cbSeriesType = new Combo(parent, 12);
                gd = new GridData(768);
                cbSeriesType.setLayoutData((Object)gd);
                cbSeriesType.setEnabled(false);
                cbSeriesType.addSelectionListener((SelectionListener)this);
            }
        });
    }

    protected void addMultipleAxesUI() {
        this.addTypeUIDescriptor(new TaskSelectTypeUIDescriptor(this){

            @Override
            public int getIndex() {
                return 30;
            }

            @Override
            public void createControl(Composite parent) {
                lblMultipleY = new Label(parent, 64);
                GridData gd = new GridData(768);
                lblMultipleY.setLayoutData((Object)gd);
                lblMultipleY.setText(Messages.getString("TaskSelectType.Label.MultipleYAxis"));
                cbMultipleY = new Combo(parent, 12);
                cbMultipleY.setItems(this.getMultipleYComboItems());
                gd = new GridData(768);
                cbMultipleY.setLayoutData((Object)gd);
                cbMultipleY.addSelectionListener((SelectionListener)this);
                int axisNum = ChartUIUtil.getOrthogonalAxisNumber((Chart)chartModel);
                this.selectMultipleAxis(axisNum);
            }
        });
    }

    protected String[] getMultipleYComboItems() {
        return new String[]{Messages.getString("TaskSelectType.Selection.None"), Messages.getString("TaskSelectType.Selection.SecondaryAxis"), Messages.getString("TaskSelectType.Selection.MoreAxes")};
    }

    protected void addDimensionUI() {
        this.addTypeUIDescriptor(new TaskSelectTypeUIDescriptor(this){

            @Override
            public int getIndex() {
                return 10;
            }

            @Override
            public void createControl(Composite parent) {
                lblDimension = new Label(parent, 64);
                GridData gd = new GridData(768);
                lblDimension.setLayoutData((Object)gd);
                lblDimension.setText(Messages.getString("TaskSelectType.Label.Dimension"));
                cbDimension = this.getContext().getUIFactory().createChartCombo(parent, 12, (EObject)this.getContext().getModel(), "dimension", null);
                gd = new GridData(768);
                cbDimension.setLayoutData((Object)gd);
                cbDimension.addSelectionListener((SelectionListener)this);
            }
        });
    }

    protected void addOrientationUI() {
        this.addTypeUIDescriptor(new TaskSelectTypeUIDescriptor(this){

            @Override
            public int getIndex() {
                return 50;
            }

            @Override
            public void createControl(Composite parent) {
                lblOrientation = new Label(parent, 64);
                GridData gd = new GridData(768);
                lblOrientation.setLayoutData((Object)gd);
                lblOrientation.setText(Messages.getString("TaskSelectType.Label.Oritention"));
                btnOrientation = this.getContext().getUIFactory().createChartCheckbox(parent, 0, false);
                btnOrientation.setText(Messages.getString("TaskSelectType.Label.FlipAxis"));
                gd = new GridData();
                btnOrientation.setLayoutData((Object)gd);
                btnOrientation.addSelectionListener((SelectionListener)this);
                this.updateOrientationUIState();
            }
        });
    }

    protected void updateOrientationUIState() {
        if (this.btnOrientation == null) {
            return;
        }
        if (this.orientation == null) {
            this.btnOrientation.setSelectionState(0);
        } else if (this.orientation == Orientation.HORIZONTAL_LITERAL) {
            this.btnOrientation.setSelectionState(1);
        } else {
            this.btnOrientation.setSelectionState(2);
        }
    }

    protected void createLeftTypeTable(Composite parent) {
        this.cmpLeft = new Composite(parent, 0);
        this.cmpLeft.setLayout((Layout)new GridLayout());
        this.cmpLeft.setLayoutData((Object)new GridData(1808));
        Label lblTypes = new Label(this.cmpLeft, 64);
        GridData gd = new GridData(768);
        lblTypes.setLayoutData((Object)gd);
        lblTypes.setText(Messages.getString("TaskSelectType.Label.SelectChartType"));
        this.table = new Table(this.cmpLeft, 2048);
        gd = new GridData(1808);
        this.table.setLayoutData((Object)gd);
        this.table.setToolTipText(Messages.getString("TaskSelectType.Label.ChartTypes"));
        this.table.addSelectionListener((SelectionListener)this);
    }

    protected void populateChartTypes() {
        ChartUIUtil.populateTypeTable((IWizardContext)this.getContext());
        Iterator iter = ChartUIUtil.getChartTypeNameIterator();
        while (iter.hasNext()) {
            String sTypeTmp = (String)iter.next();
            TableItem tItem = new TableItem(this.table, 0);
            tItem.setText(LEADING_BLANKS + ChartUIUtil.getChartType((String)sTypeTmp).getDisplayName());
            tItem.setData((Object)ChartUIUtil.getChartType((String)sTypeTmp).getName());
            tItem.setImage(ChartUIUtil.getChartType((String)sTypeTmp).getImage());
        }
    }

    protected Chart getChartModel() {
        return this.chartModel;
    }

    protected void createComposite(Vector<IChartSubType> vSubTypes) {
        Label lblSubtypes = new Label(this.cmpRight, 524288);
        lblSubtypes.setText(Messages.getString("TaskSelectType.Label.SelectSubtype"));
        GridData gd = new GridData(768);
        gd.horizontalIndent = 5;
        lblSubtypes.setLayoutData((Object)gd);
        GridData gdTypes = new GridData(784);
        this.cmpSubTypes = new Composite(this.cmpRight, 0);
        this.createSubtypeBtnGroups(vSubTypes);
        this.cmpSubTypes.setLayoutData((Object)gdTypes);
        this.cmpSubTypes.setToolTipText(Messages.getString("TaskSelectType.Label.ChartSubtypes"));
        this.cmpSubTypes.setLayout((Layout)new GridLayout());
        this.cmpSubTypes.setVisible(true);
    }

    protected void createSubtypeBtnGroups(Vector<IChartSubType> vSubTypes) {
        this.vSubTypeNames = new Vector();
        if (this.cmpTypeButtons != null && !this.cmpTypeButtons.isDisposed()) {
            this.cmpTypeButtons.dispose();
        }
        this.cmpTypeButtons = new Composite(this.cmpSubTypes, 0);
        this.cmpTypeButtons.setLayoutData((Object)new GridData(1808));
        GridLayout rowLayout = new GridLayout(vSubTypes.size(), false);
        rowLayout.marginTop = 0;
        rowLayout.marginLeft = 0;
        rowLayout.marginBottom = 12;
        rowLayout.marginRight = 12;
        rowLayout.horizontalSpacing = 4;
        this.cmpTypeButtons.setLayout((Layout)rowLayout);
        int iC = 0;
        while (iC < vSubTypes.size()) {
            IChartSubType subType = vSubTypes.get(iC);
            this.vSubTypeNames.add(subType.getName());
            Button btnType = new Button(this.cmpTypeButtons, 0x800002);
            ChartUIUtil.addScreenReaderAccessbility((Control)btnType, (String)subType.getName());
            btnType.setData((Object)subType.getName());
            btnType.setImage(subType.getImage());
            GridData gd = new GridData();
            gd.widthHint = 80;
            gd.heightHint = 80;
            btnType.setLayoutData((Object)gd);
            btnType.addSelectionListener((SelectionListener)this);
            btnType.setToolTipText(subType.getDescription());
            btnType.getImage().setBackground(btnType.getBackground());
            btnType.setVisible(true);
            this.cmpTypeButtons.layout(true);
            if (this.getDataServiceProvider().checkState(32)) break;
            ++iC;
        }
        this.cmpSubTypes.layout(true);
    }

    private String translateDimensionString(String sDimensionValue) {
        String dimensionName = "";
        if (sDimensionValue.equals(ChartDimension.TWO_DIMENSIONAL_LITERAL.getName())) {
            dimensionName = IChartType.TWO_DIMENSION_TYPE;
        } else if (sDimensionValue.equals(ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL.getName())) {
            dimensionName = IChartType.TWO_DIMENSION_WITH_DEPTH_TYPE;
        } else if (sDimensionValue.equals(ChartDimension.THREE_DIMENSIONAL_LITERAL.getName())) {
            dimensionName = IChartType.THREE_DIMENSION_TYPE;
        }
        return dimensionName;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        boolean needUpdateModel = false;
        Object oSelected = e.getSource();
        needUpdateModel = this.handleWidgetSelected(e);
        if (needUpdateModel) {
            this.refreshChartAndPreview(oSelected);
        }
    }

    protected boolean handleWidgetSelected(SelectionEvent e) {
        boolean needUpdateModel = false;
        Object oSelected = e.getSource();
        if (e.widget == this.btnOrientation) {
            needUpdateModel = true;
            this.handleOrientationBtnSelected();
        } else if (oSelected.getClass().equals(Button.class)) {
            needUpdateModel = true;
            this.handleSubtypeBtnSelected(e);
        } else if (oSelected.getClass().equals(Table.class)) {
            needUpdateModel = this.handleTableItemSelected(e);
        } else if (oSelected.equals(this.cbMultipleY)) {
            needUpdateModel = this.handleMultipleAxesComboSelected();
        } else if (oSelected.equals(this.cbDimension)) {
            needUpdateModel = this.handleDimensionComboSelected();
        } else if (oSelected.equals(this.cbSeriesType)) {
            needUpdateModel = this.handleSeriesTypeComboSelected();
        }
        return needUpdateModel;
    }

    protected boolean handleSeriesTypeComboSelected() {
        boolean needUpdateModel = true;
        this.changeOverlaySeriesType();
        this.updateDimensionCombo(this.sType);
        return needUpdateModel;
    }

    protected boolean handleDimensionComboSelected() {
        String newDimension = null;
        newDimension = this.cbDimension.getSelectedItemData();
        if (newDimension == null && this.sDimension == null) {
            return false;
        }
        if (newDimension != null && !newDimension.equals(this.sDimension) || this.sDimension != null && !this.sDimension.equals(newDimension)) {
            this.handleDimensionBtnSelected(newDimension);
            return true;
        }
        return false;
    }

    protected boolean handleMultipleAxesComboSelected() {
        boolean needUpdateModel = true;
        this.lblSeriesType.setEnabled(this.isTwoAxesEnabled());
        Axis xAxis = (Axis)((ChartWithAxes)this.chartModel).getAxes().get(0);
        this.getContext().setMoreAxesSupported(this.cbMultipleY.getSelectionIndex() == 2);
        if (this.chartModel instanceof ChartWithoutAxes) {
            throw new IllegalArgumentException(Messages.getString("TaskSelectType.Exception.CannotSupportAxes"));
        }
        ChartAdapter.beginIgnoreNotifications();
        int iAxisNumber = ChartUIUtil.getOrthogonalAxisNumber((Chart)this.chartModel);
        if (this.cbMultipleY.getSelectionIndex() == 0) {
            ChartCacheManager.getInstance().cacheSeriesType(null);
            if (iAxisNumber > 1) {
                ChartUIUtil.removeLastAxes((ChartWithAxes)((ChartWithAxes)this.chartModel), (int)(iAxisNumber - 1));
            }
        } else if (this.cbMultipleY.getSelectionIndex() == 1) {
            if (iAxisNumber == 1) {
                ChartUIUtil.addAxis((ChartWithAxes)((ChartWithAxes)this.chartModel));
            } else if (iAxisNumber > 2) {
                ChartUIUtil.removeLastAxes((ChartWithAxes)((ChartWithAxes)this.chartModel), (int)(iAxisNumber - 2));
            }
        }
        ChartAdapter.endIgnoreNotifications();
        if (xAxis.getAssociatedAxes().size() > 1) {
            String lastSeriesType = ChartCacheManager.getInstance().findSeriesType();
            if (lastSeriesType != null) {
                this.cbSeriesType.setText(lastSeriesType);
            } else {
                Axis overlayAxis = (Axis)xAxis.getAssociatedAxes().get(1);
                String sDisplayName = ((SeriesDefinition)overlayAxis.getSeriesDefinitions().get(0)).getDesignTimeSeries().getDisplayName();
                this.cbSeriesType.setText(sDisplayName);
            }
            this.changeOverlaySeriesType();
        }
        this.cbSeriesType.setEnabled(this.isTwoAxesEnabled());
        if (this.updateDimensionCombo(this.sType)) {
            this.createAndDisplayTypesSheet(this.sType);
            this.setDefaultSubtypeSelection();
        }
        this.cmpMisc.layout();
        return needUpdateModel;
    }

    protected boolean handleTableItemSelected(SelectionEvent e) {
        this.sType = ((String)((TableItem)e.item).getData()).trim();
        if (!this.sOldType.equals(this.sType)) {
            this.handleChartTypeSelected();
            ((ChartWizardContext)this.context).setChartType(ChartUIUtil.getChartType((String)this.sType));
            return true;
        }
        return false;
    }

    protected void refreshChartAndPreview(Object oSelected) {
        ChartAdapter.notifyUpdateApply();
        this.refreshChart(this.sType, this.sSubType);
        if (oSelected.getClass().equals(Table.class)) {
            this.populateSeriesTypesList();
        } else if (oSelected.equals(this.btnOrientation) && this.chartModel instanceof ChartWithAxes) {
            IChartType chartType = ChartUIUtil.getChartType((String)this.sType);
            Orientation lastOrientation = ChartCacheManager.getInstance().findOrientation(this.sType);
            lastOrientation = this.getAvailableOrientation(chartType, this.getAvailableDimension(chartType, this.sDimension), lastOrientation);
            if (lastOrientation != this.getAvailableOrientation(chartType, this.getAvailableDimension(chartType, this.sDimension), this.orientation)) {
                this.rotateAxisTitle((ChartWithAxes)this.chartModel);
            }
        }
        this.doPreview();
    }

    protected void handleDimensionBtnSelected(String newDimension) {
        this.sDimension = newDimension;
        ChartCacheManager.getInstance().cacheDimension(this.sType, this.sDimension);
        this.createAndDisplayTypesSheet(this.sType);
        this.setDefaultSubtypeSelection();
        this.populateSeriesTypesList();
    }

    protected void handleChartTypeSelected() {
        if (!this.getDataServiceProvider().checkState(32) && this.chartModel != null && this.chartModel instanceof ChartWithAxes) {
            Orientation lastOrientation = ChartCacheManager.getInstance().findOrientation(this.sOldType);
            this.orientation = ChartCacheManager.getInstance().findOrientation(this.sType);
            if (this.getAvailableOrientation(ChartUIUtil.getChartType((String)this.sOldType), this.getAvailableDimension(ChartUIUtil.getChartType((String)this.sOldType), this.sDimension), lastOrientation) != this.getAvailableOrientation(ChartUIUtil.getChartType((String)this.sType), this.getAvailableDimension(ChartUIUtil.getChartType((String)this.sType), this.sDimension), this.orientation)) {
                this.rotateAxisTitle((ChartWithAxes)this.chartModel);
            }
        }
        if (this.chartModel != null && this.chartModel instanceof ChartWithAxes && ChartCacheManager.getInstance().findCategory(this.sType) != null) {
            boolean bCategory = ChartCacheManager.getInstance().findCategory(this.sType);
            if (((Axis)((ChartWithAxes)this.chartModel).getAxes().get(0)).isSetCategoryAxis()) {
                ((Axis)((ChartWithAxes)this.chartModel).getAxes().get(0)).setCategoryAxis(bCategory);
            }
        }
        this.sSubType = null;
        this.createAndDisplayTypesSheet(this.sType);
        this.setDefaultSubtypeSelection();
        this.sOldType = this.sType;
        this.cmpMisc.layout();
    }

    protected void handleSubtypeBtnSelected(SelectionEvent e) {
        Button btn = (Button)e.getSource();
        if (btn.getSelection()) {
            int iTypeIndex;
            if (this.sSubType != null && !this.getSubtypeFromButton((Control)btn).equals(this.sSubType) && (iTypeIndex = this.vSubTypeNames.indexOf(this.sSubType)) >= 0) {
                ((Button)this.cmpTypeButtons.getChildren()[iTypeIndex]).setSelection(false);
                this.cmpTypeButtons.redraw();
            }
            ChartUIUtil.saveLabelPositionIntoCache((SeriesDefinition)this.getSeriesDefinitionForProcessing());
            this.sSubType = this.getSubtypeFromButton((Control)btn);
            ChartCacheManager.getInstance().cacheSubtype(this.sType, this.sSubType);
        } else if (this.sSubType != null && this.getSubtypeFromButton((Control)btn).equals(this.sSubType)) {
            btn.setSelection(true);
        }
    }

    protected void handleOrientationBtnSelected() {
        int state = this.btnOrientation.getSelectionState();
        this.orientation = state == 0 ? null : (state == 1 ? Orientation.HORIZONTAL_LITERAL : Orientation.VERTICAL_LITERAL);
        this.createAndDisplayTypesSheet(this.sType);
        this.setDefaultSubtypeSelection();
        this.populateSeriesTypesList();
        ChartCacheManager.getInstance().cacheOrientation(this.sType, this.orientation);
    }

    private boolean isAreaSeriesMixed() {
        boolean hasAreaSeries = false;
        boolean hasNonAreaSeries = false;
        for (SeriesDefinition sd : ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)this.chartModel)) {
            if (sd.getDesignTimeSeries() instanceof AreaSeries) {
                hasAreaSeries = true;
            } else {
                hasNonAreaSeries = true;
            }
            if (!hasAreaSeries || !hasNonAreaSeries) continue;
            return true;
        }
        return false;
    }

    protected boolean updateDimensionCombo(String sSelectedType) {
        this.cbDimension.setEObjectParent((EObject)this.getContext().getModel());
        boolean isOldExist = false;
        IChartType chartType = ChartUIUtil.getChartType((String)sSelectedType);
        String[] dimensionArray = chartType.getSupportedDimensions();
        int axesNum = ChartUIUtil.getOrthogonalAxisNumber((Chart)this.chartModel);
        this.cbDimension.removeAll();
        boolean bAreaSeriesMixed = this.isAreaSeriesMixed();
        int i = 0;
        while (i < dimensionArray.length) {
            boolean isSupported = chartType.isDimensionSupported(dimensionArray[i], (ChartWizardContext)this.context, axesNum, 0);
            if (!(!isSupported || bAreaSeriesMixed && dimensionArray[i].equals(IChartType.TWO_DIMENSION_WITH_DEPTH_TYPE))) {
                this.cbDimension.add(dimensionArray[i]);
            }
            ++i;
        }
        this.cbDimension.setDefaultItem(chartType.getDefaultDimension());
        this.cbDimension.setItemData(this.cbDimension.getItems());
        String cache = ChartCacheManager.getInstance().getDimension(sSelectedType);
        String availableCache = this.getAvailableDimension(chartType, cache);
        String thisDimension = this.getAvailableDimension(chartType, this.sDimension);
        if (availableCache != thisDimension) {
            isOldExist = true;
        }
        this.sDimension = cache;
        this.cbDimension.setText(this.sDimension);
        return !isOldExist;
    }

    protected boolean isTwoAxesEnabled() {
        return this.cbMultipleY.getSelectionIndex() == 1;
    }

    protected EObject getChartModelObject() {
        return ((ChartWizardContext)this.context).getModel();
    }

    protected void updateAdapters() {
        EObject model = this.getChartModelObject();
        if (this.container instanceof ChartWizard) {
            EContentAdapter adapter = ((ChartWizard)this.container).getAdapter();
            model.eAdapters().remove((Object)adapter);
            TreeIterator iterator = model.eAllContents();
            while (iterator.hasNext()) {
                EObject oModel = (EObject)iterator.next();
                oModel.eAdapters().remove((Object)adapter);
            }
            model.eAdapters().add((Object)adapter);
        } else {
            EList adapters = model.eAdapters();
            if (adapters.isEmpty()) {
                if (this.adapter == null) {
                    this.adapter = new ChartAdapter(this.container);
                    this.adapter.addListener((ITaskChangeListener)this);
                }
                adapters.add((Object)this.adapter);
            } else if (adapters.get(0) instanceof ChartAdapter) {
                ((ChartAdapter)adapters.get(0)).addListener((ITaskChangeListener)this);
            }
        }
    }

    protected boolean is3D() {
        return IChartType.THREE_DIMENSION_TYPE.equals(this.getAvailableDimension(ChartUIUtil.getChartType((String)this.sType), this.sDimension));
    }

    private boolean isMultiAxisSupported() {
        boolean bOutXtab;
        boolean bl = bOutXtab = !this.getDataServiceProvider().checkState(32);
        return bOutXtab && !this.is3D() && (!IChartType.TWO_DIMENSION_WITH_DEPTH_TYPE.equals(this.getAvailableDimension(ChartUIUtil.getChartType((String)this.sType), this.sDimension)) || !"Area Chart".equals(this.sType));
    }

    protected void changeOverlaySeriesType() {
        if (this.getCurrentChartType().canCombine()) {
            ChartCacheManager.getInstance().cacheSeriesType(this.cbSeriesType.getText());
        }
        try {
            try {
                Axis XAxis = (Axis)((ChartWithAxes)this.chartModel).getAxes().get(0);
                int iSeriesDefinitionIndex = ((Axis)XAxis.getAssociatedAxes().get(0)).getSeriesDefinitions().size();
                int iOverlaySeriesCount = ((Axis)XAxis.getAssociatedAxes().get(1)).getSeriesDefinitions().size();
                ChartAdapter.beginIgnoreNotifications();
                int i = 0;
                while (i < iOverlaySeriesCount) {
                    Series lastSeries = ((SeriesDefinition)((Axis)XAxis.getAssociatedAxes().get(1)).getSeriesDefinitions().get(i)).getDesignTimeSeries();
                    if (!lastSeries.getDisplayName().equals(this.cbSeriesType.getText())) {
                        String name = htSeriesNames.get(this.cbSeriesType.getText()).getClass().getName();
                        Series newSeries = ChartCacheManager.getInstance().findSeries(name, iSeriesDefinitionIndex + i);
                        if (newSeries == null || newSeries instanceof BarSeries) {
                            newSeries = htSeriesNames.get(this.cbSeriesType.getText()).copyInstance();
                            newSeries.translateFrom(lastSeries, iSeriesDefinitionIndex, this.chartModel);
                        }
                        newSeries.eAdapters().addAll((Collection)this.chartModel.eAdapters());
                        ((SeriesDefinition)((Axis)XAxis.getAssociatedAxes().get(1)).getSeriesDefinitions().get(i)).getSeries().clear();
                        ((SeriesDefinition)((Axis)XAxis.getAssociatedAxes().get(1)).getSeriesDefinitions().get(i)).getSeries().add((Object)newSeries);
                        ChartUIUtil.setSeriesName((Chart)this.chartModel);
                    }
                    ++i;
                }
                ChartWizard.removeException((String)"TaskSelectType.changeOverlaySeriesType");
            }
            catch (Exception e) {
                ChartWizard.showException((String)"TaskSelectType.changeOverlaySeriesType", (String)e.getLocalizedMessage());
                ChartAdapter.endIgnoreNotifications();
            }
        }
        finally {
            ChartAdapter.endIgnoreNotifications();
        }
    }

    protected void populateSeriesTypesList() {
        if (this.cbSeriesType == null) {
            return;
        }
        if (htSeriesNames == null) {
            htSeriesNames = new Hashtable(20);
        }
        Series series = this.getSeriesDefinitionForProcessing().getDesignTimeSeries();
        ChartUIExtensionUtil.populateSeriesTypesList(htSeriesNames, this.cbSeriesType, this.getContext(), ChartUIExtensionsImpl.instance().getUIChartTypeExtensions(this.getContext().getIdentifier()), series);
        this.updateOverlaySeriesType();
    }

    protected void createAndDisplayTypesSheet(String sSelectedType) {
        IChartType chartType = ChartUIUtil.getChartType((String)sSelectedType);
        if (this.btnOrientation != null) {
            this.lblOrientation.setEnabled(chartType.supportsTransposition() && !this.is3D());
            this.btnOrientation.setEnabled(chartType.supportsTransposition() && !this.is3D());
        }
        this.updateDimensionCombo(sSelectedType);
        Vector<IChartSubType> vSubTypes = this.getAvailableChartSubtypes(chartType);
        if (this.btnOrientation == null || !this.btnOrientation.isEnabled()) {
            this.orientation = null;
        }
        ChartCacheManager.getInstance().cacheOrientation(this.sType, this.orientation);
        if (this.chartModel == null) {
            ChartCacheManager.getInstance().cacheCategory(this.sType, true);
        } else if (this.chartModel instanceof ChartWithAxes) {
            ChartCacheManager.getInstance().cacheCategory(this.sType, ((Axis)((ChartWithAxes)this.chartModel).getAxes().get(0)).isCategoryAxis());
        }
        this.createSubtypeBtnGroups(vSubTypes);
        this.updateOrientationUIState();
        this.cmpRight.layout();
    }

    protected Vector<IChartSubType> getAvailableChartSubtypes(IChartType chartType) {
        String availDim = this.getAvailableDimension(chartType, this.sDimension);
        Vector<Object> vSubTypes = new Vector<IChartSubType>(chartType.getChartSubtypes(availDim, this.getAvailableOrientation(chartType, availDim, this.orientation)));
        if (vSubTypes.size() == 0) {
            vSubTypes = new Vector(chartType.getChartSubtypes(chartType.getDefaultDimension(), chartType.getDefaultOrientation()));
            this.sDimension = null;
            this.orientation = null;
        }
        return vSubTypes;
    }

    protected void setDefaultSubtypeSelection() {
        if (this.sSubType == null) {
            this.sSubType = ChartCacheManager.getInstance().findSubtype(this.sType);
        }
        if (this.sSubType == null) {
            ((Button)this.cmpTypeButtons.getChildren()[0]).setSelection(true);
            this.sSubType = this.getSubtypeFromButton(this.cmpTypeButtons.getChildren()[0]);
            ChartCacheManager.getInstance().cacheSubtype(this.sType, this.sSubType);
        } else {
            Control[] buttons = this.cmpTypeButtons.getChildren();
            boolean bSelected = false;
            int iB = 0;
            while (iB < buttons.length) {
                if (this.getSubtypeFromButton(buttons[iB]).equals(this.sSubType)) {
                    ((Button)buttons[iB]).setSelection(true);
                    bSelected = true;
                    break;
                }
                ++iB;
            }
            if (!bSelected) {
                ((Button)this.cmpTypeButtons.getChildren()[0]).setSelection(true);
                this.sSubType = this.getSubtypeFromButton(this.cmpTypeButtons.getChildren()[0]);
                ChartCacheManager.getInstance().cacheSubtype(this.sType, this.sSubType);
            }
        }
        this.cmpTypeButtons.redraw();
    }

    private void setDefaultTypeSelection() {
        if (this.table.getItems().length > 0) {
            if (this.sType == null) {
                this.table.select(0);
                this.sType = (String)this.table.getSelection()[0].getData();
            } else {
                TableItem[] tiAll = this.table.getItems();
                int iTI = 0;
                while (iTI < tiAll.length) {
                    if (tiAll[iTI].getData().equals(this.sType)) {
                        this.table.select(iTI);
                        break;
                    }
                    ++iTI;
                }
            }
            this.sOldType = this.sType;
            this.createAndDisplayTypesSheet(this.sType);
            this.setDefaultSubtypeSelection();
        }
    }

    public void dispose() {
        super.dispose();
        this.lstDescriptor.clear();
        this.chartModel = null;
        this.adapter = null;
        if (this.previewPainter != null) {
            this.previewPainter.dispose();
        }
        this.previewPainter = null;
        this.sSubType = null;
        this.sType = null;
        this.sDimension = null;
        this.vSubTypeNames = null;
        this.orientation = null;
    }

    protected void refreshChart(String type, String subType) {
        ChartAdapter.beginIgnoreNotifications();
        IChartType chartType = ChartUIUtil.getChartType((String)type);
        try {
            this.chartModel = this.adapteChartModel(this.chartModel, chartType, subType);
            if (this.getDataServiceProvider().checkState(32)) {
                ChartWithAxes cwa = (ChartWithAxes)this.chartModel;
                ((Axis)cwa.getAxes().get(0)).setCategoryAxis(true);
                if (cwa.isTransposed()) {
                    cwa.setReverseCategory(true);
                }
            }
            this.updateAdapters();
            ChartWizard.removeException((String)"TaskSelectType.refreshChart");
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                logger.log(e);
            }
            ChartWizard.showException((String)"TaskSelectType.refreshChart", (String)e.getLocalizedMessage());
        }
        ChartAdapter.endIgnoreNotifications();
        this.updateSelection();
        ((ChartWizardContext)this.context).setModel(this.chartModel);
        ((ChartWizardContext)this.context).setChartType(chartType);
        this.setContext(this.context);
    }

    protected Chart adapteChartModel(Chart chartModel, IChartType chartType, String subType) {
        Chart cm = chartType.getModel(subType, this.orientation, this.sDimension, chartModel);
        new ChartValueUpdater().update(cm, null, false);
        return cm;
    }

    private SeriesDefinition getSeriesDefinitionForProcessing() {
        SeriesDefinition sd = null;
        if (this.chartModel instanceof ChartWithAxes) {
            sd = (SeriesDefinition)((Axis)((Axis)((ChartWithAxes)this.chartModel).getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().get(0);
        } else if (this.chartModel instanceof ChartWithoutAxes) {
            sd = (SeriesDefinition)((SeriesDefinition)((ChartWithoutAxes)this.chartModel).getSeriesDefinitions().get(0)).getSeriesDefinitions().get(0);
        }
        return sd;
    }

    protected void updateSelection() {
        boolean bOutXtab;
        boolean bl = bOutXtab = !this.getDataServiceProvider().checkState(32);
        if (this.getCurrentChartType().isChartWithAxes()) {
            if (this.cbMultipleY != null) {
                this.lblMultipleY.setEnabled(this.isMultiAxisSupported());
                this.cbMultipleY.setEnabled(this.isMultiAxisSupported());
            }
            if (this.cbSeriesType != null) {
                this.lblSeriesType.setEnabled(bOutXtab && this.isTwoAxesEnabled());
                this.cbSeriesType.setEnabled(bOutXtab && this.isTwoAxesEnabled());
            }
        } else {
            if (this.cbMultipleY != null) {
                this.cbMultipleY.select(0);
                this.getContext().setMoreAxesSupported(false);
                this.lblMultipleY.setEnabled(false);
                this.cbMultipleY.setEnabled(false);
            }
            if (this.cbSeriesType != null) {
                this.lblSeriesType.setEnabled(false);
                this.cbSeriesType.setEnabled(false);
            }
        }
        if (this.btnOrientation != null) {
            this.lblOrientation.setEnabled(bOutXtab && this.lblOrientation.isEnabled());
            this.btnOrientation.setEnabled(bOutXtab && this.btnOrientation.isEnabled());
        }
    }

    public ChartWizardContext getContext() {
        ChartWizardContext context = (ChartWizardContext)super.getContext();
        context.setModel(this.chartModel);
        return context;
    }

    public void setContext(IWizardContext context) {
        super.setContext(context);
        this.chartModel = ((ChartWizardContext)context).getModel();
        if (this.chartModel != null) {
            this.sType = ((ChartWizardContext)context).getChartType().getName();
            this.sSubType = this.chartModel.getSubType();
            if (this.chartModel.isSetDimension()) {
                this.sDimension = this.translateDimensionString(this.chartModel.getDimension().getName());
                ChartCacheManager.getInstance().cacheDimension(this.sType, this.sDimension);
            }
            if (this.chartModel instanceof ChartWithAxes) {
                this.orientation = ((ChartWithAxes)this.chartModel).isSetOrientation() ? ((ChartWithAxes)this.chartModel).getOrientation() : null;
                ChartCacheManager.getInstance().cacheOrientation(this.sType, this.orientation);
                int iYAxesCount = ChartUIUtil.getOrthogonalAxisNumber((Chart)this.chartModel);
                if (iYAxesCount > 1 && this.lblMultipleY != null && !this.lblMultipleY.isDisposed()) {
                    this.lblMultipleY.setEnabled(!this.is3D());
                    this.cbMultipleY.setEnabled(!this.is3D());
                    this.lblSeriesType.setEnabled(!this.is3D() && this.isTwoAxesEnabled());
                    this.cbSeriesType.setEnabled(!this.is3D() && this.isTwoAxesEnabled());
                    this.selectMultipleAxis(iYAxesCount);
                }
            }
        }
    }

    private void selectMultipleAxis(int yAxisNum) {
        if (this.getContext().isMoreAxesSupported()) {
            this.cbMultipleY.select(2);
        } else if (yAxisNum > 2) {
            this.cbMultipleY.select(2);
            this.getContext().setMoreAxesSupported(true);
        } else {
            this.cbMultipleY.select(yAxisNum > 0 ? yAxisNum - 1 : 0);
        }
    }

    public void changeTask(Notification notification) {
        if (this.previewPainter != null) {
            this.doPreview();
        }
    }

    private void checkDataTypeForChartWithAxes() {
        Series series;
        SeriesDefinition sd;
        ArrayList sdList = new ArrayList();
        sdList.addAll(ChartUIUtil.getBaseSeriesDefinitions((Chart)this.getChartModel()));
        int i = 0;
        while (i < sdList.size()) {
            sd = (SeriesDefinition)sdList.get(i);
            series = sd.getDesignTimeSeries();
            this.checkDataTypeForBaseSeries(ChartUIUtil.getDataQuery((SeriesDefinition)sd, (int)0), series);
            ++i;
        }
        sdList.clear();
        sdList.addAll(ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)this.getChartModel()));
        i = 0;
        while (i < sdList.size()) {
            sd = (SeriesDefinition)sdList.get(i);
            series = sd.getDesignTimeSeries();
            this.checkDataTypeForOrthoSeries(ChartUIUtil.getDataQuery((SeriesDefinition)sd, (int)0), series);
            ++i;
        }
    }

    protected IDataServiceProvider getDataServiceProvider() {
        return this.getContext().getDataServiceProvider();
    }

    private String getSubtypeFromButton(Control button) {
        return (String)button.getData();
    }

    private void checkDataTypeForBaseSeries(Query query, Series series) {
        this.checkDataTypeImpl(query, series, true);
    }

    private void checkDataTypeForOrthoSeries(Query query, Series series) {
        this.checkDataTypeImpl(query, series, false);
    }

    private void checkDataTypeImpl(Query query, Series series, boolean isBaseSeries) {
        String expression = query.getDefinition();
        Axis axis = null;
        Query o = query;
        while (o != null) {
            if (!((o = o.eContainer()) instanceof Axis)) continue;
            axis = (Axis)o;
            break;
        }
        Collection cRegisteredEntries = ChartUIExtensionsImpl.instance().getSeriesUIComponents(this.getContext().getIdentifier());
        Iterator iterEntries = cRegisteredEntries.iterator();
        String sSeries = null;
        while (iterEntries.hasNext()) {
            ISeriesUIProvider provider = (ISeriesUIProvider)iterEntries.next();
            sSeries = provider.getSeriesClass();
            if (!sSeries.equals(series.getClass().getName())) continue;
            if (this.chartModel instanceof ChartWithAxes) {
                DataType dataType = this.getDataServiceProvider().getDataType(expression);
                SeriesDefinition baseSD = (SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)this.chartModel).get(0);
                SeriesDefinition orthSD = null;
                orthSD = (SeriesDefinition)series.eContainer();
                String aggFunc = null;
                try {
                    aggFunc = ChartUtil.getAggregateFuncExpr((SeriesDefinition)orthSD, (SeriesDefinition)baseSD, (Query)query);
                    ChartWizard.removeException((String)"PluginSettings.getAggregateFunc");
                }
                catch (ChartException e) {
                    ChartWizard.showException((String)"PluginSettings.getAggregateFunc", (String)e.getLocalizedMessage());
                }
                if (baseSD != null && !isBaseSeries && baseSD != orthSD && ChartUtil.isMagicAggregate((String)aggFunc)) {
                    dataType = DataType.NUMERIC_LITERAL;
                }
                if (this.isValidatedAxis(dataType, axis.getType())) {
                    ChartWizard.removeException((String)("CheckSeriesBindingType_" + series.eContainer().hashCode()));
                    break;
                }
                AxisType[] axisTypes = provider.getCompatibleAxisType(series);
                int i = 0;
                while (i < axisTypes.length) {
                    if (this.isValidatedAxis(dataType, axisTypes[i])) {
                        this.axisNotification(axis, axisTypes[i]);
                        ChartAdapter.beginIgnoreNotifications();
                        axis.setType(axisTypes[i]);
                        ChartAdapter.endIgnoreNotifications();
                        break;
                    }
                    ++i;
                }
            }
            try {
                provider.validateSeriesBindingType(series, this.getDataServiceProvider());
                ChartWizard.removeException((String)("CheckSeriesBindingType_" + series.eContainer().hashCode()));
            }
            catch (ChartException ce) {
                ChartWizard.showException((String)("CheckSeriesBindingType_" + series.eContainer().hashCode()), (String)Messages.getFormattedString("TaskSelectData.Warning.TypeCheck", new String[]{ce.getLocalizedMessage(), series.getDisplayName()}));
            }
            break;
        }
    }

    private boolean isValidatedAxis(DataType dataType, AxisType axisType) {
        if (dataType == null) {
            return true;
        }
        if (dataType == DataType.DATE_TIME_LITERAL && axisType == AxisType.DATE_TIME_LITERAL) {
            return true;
        }
        if (dataType == DataType.NUMERIC_LITERAL && (axisType == AxisType.LINEAR_LITERAL || axisType == AxisType.LOGARITHMIC_LITERAL)) {
            return true;
        }
        return dataType == DataType.TEXT_LITERAL && axisType == AxisType.TEXT_LITERAL;
    }

    private void axisNotification(Axis axis, AxisType type) {
        ChartAdapter.beginIgnoreNotifications();
        this.convertSampleData(axis, type);
        axis.setFormatSpecifier(null);
        EList markerLines = axis.getMarkerLines();
        int i = 0;
        while (i < markerLines.size()) {
            ((MarkerLine)markerLines.get(i)).setFormatSpecifier(null);
            ++i;
        }
        EList markerRanges = axis.getMarkerRanges();
        int i2 = 0;
        while (i2 < markerRanges.size()) {
            ((MarkerRange)markerRanges.get(i2)).setFormatSpecifier(null);
            ++i2;
        }
        ChartAdapter.endIgnoreNotifications();
    }

    private void convertSampleData(Axis axis, AxisType axisType) {
        if (this.chartModel.getSampleData() == null) {
            return;
        }
        if (axis.getAssociatedAxes() != null && axis.getAssociatedAxes().size() != 0) {
            BaseSampleData bsd = (BaseSampleData)this.chartModel.getSampleData().getBaseSampleData().get(0);
            bsd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)axisType, (String)bsd.getDataSetRepresentation(), (int)0));
        } else {
            int iStartIndex = this.getFirstSeriesDefinitionIndexForAxis(axis);
            int iEndIndex = iStartIndex + axis.getSeriesDefinitions().size();
            int iOSDSize = this.chartModel.getSampleData().getOrthogonalSampleData().size();
            int i = 0;
            while (i < iOSDSize) {
                OrthogonalSampleData osd = (OrthogonalSampleData)this.chartModel.getSampleData().getOrthogonalSampleData().get(i);
                if (osd.getSeriesDefinitionIndex() >= iStartIndex && osd.getSeriesDefinitionIndex() < iEndIndex) {
                    osd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)axisType, (String)osd.getDataSetRepresentation(), (int)i));
                }
                ++i;
            }
        }
    }

    private int getFirstSeriesDefinitionIndexForAxis(Axis axis) {
        EList axisList = ((Axis)((ChartWithAxes)this.chartModel).getAxes().get(0)).getAssociatedAxes();
        int index = 0;
        int i = 0;
        while (i < axisList.size()) {
            if (axis.equals(axisList.get(i))) {
                index = i;
                break;
            }
            ++i;
        }
        int iTmp = 0;
        int i2 = 0;
        while (i2 < index) {
            iTmp += ChartUIUtil.getAxisYForProcessing((ChartWithAxes)((ChartWithAxes)this.chartModel), (int)i2).getSeriesDefinitions().size();
            ++i2;
        }
        return iTmp;
    }

    public Image getImage() {
        return UIHelper.getImage((String)"icons/obj16/selecttype.gif");
    }

    private void rotateAxisTitle(ChartWithAxes cwa) {
        boolean bRender = true;
        ChartAdapter.beginIgnoreNotifications();
        Axis aX = ChartUIUtil.getAxisXForProcessing((ChartWithAxes)cwa);
        if (aX.getTitle().getCaption().getFont().isSetRotation()) {
            double curRotation = aX.getTitle().getCaption().getFont().getRotation();
            aX.getTitle().getCaption().getFont().setRotation(curRotation >= 0.0 ? 90.0 - curRotation : -90.0 - curRotation);
        }
        EList aYs = aX.getAssociatedAxes();
        int i = 0;
        while (i < aYs.size()) {
            Axis aY = (Axis)aYs.get(i);
            if (aY.getTitle().getCaption().getFont().isSetRotation()) {
                double curRotation = aY.getTitle().getCaption().getFont().getRotation();
                aY.getTitle().getCaption().getFont().setRotation(curRotation >= 0.0 ? 90.0 - curRotation : -90.0 - curRotation);
            }
            ++i;
        }
        ChartAdapter.endIgnoreNotifications();
        if (bRender) {
            this.doPreview();
        }
    }

    public IChartPreviewPainter createPreviewPainter() {
        ChartPreviewPainter painter = new ChartPreviewPainter(this.getContext());
        this.getPreviewCanvas().addPaintListener((PaintListener)painter);
        this.getPreviewCanvas().addControlListener((ControlListener)painter);
        painter.setPreview(this.getPreviewCanvas());
        return painter;
    }

    protected Chart getPreviewChartModel() throws ChartException {
        if (this.getContext() == null) {
            return null;
        }
        return this.getContext().getModel();
    }

    public void doPreview() {
        try {
            final Chart chart = this.getPreviewChartModel();
            if (chart instanceof ChartWithAxes) {
                ChartAdapter.beginIgnoreNotifications();
                this.checkDataTypeForChartWithAxes();
                ChartAdapter.endIgnoreNotifications();
            } else {
                ChartWizard.removeAllExceptions((String)"CheckSeriesBindingType_");
            }
            LivePreviewTask lpt = new LivePreviewTask(Messages.getString("TaskFormatChart.LivePreviewTask.BindData"), null);
            lpt.addTask(new LivePreviewTask(){

                @Override
                public void run() {
                    if (TaskSelectType.this.previewPainter != null) {
                        this.setParameter("Chart Model", ChartUIUtil.prepareLivePreview((Chart)chart, (IDataServiceProvider)TaskSelectType.this.getDataServiceProvider(), (IActionEvaluator)((ChartWizardContext)TaskSelectType.this.context).getActionEvaluator()));
                    }
                }
            });
            lpt.addTask(new LivePreviewTask(){

                @Override
                public void run() {
                    if (TaskSelectType.this.previewCanvas != null && TaskSelectType.this.previewCanvas.getDisplay() != null && !TaskSelectType.this.previewCanvas.getDisplay().isDisposed()) {
                        TaskSelectType.this.previewCanvas.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if ((this).TaskSelectType.this.previewPainter != null) {
                                    Chart cm = (Chart)this.getParameter("Chart Model");
                                    (this).TaskSelectType.this.previewPainter.renderModel((IChartObject)cm);
                                }
                            }
                        });
                    }
                }
            });
            ((ChartLivePreviewThread)((ChartWizardContext)this.context).getLivePreviewThread()).setParentShell(this.getPreviewCanvas().getShell());
            ((ChartLivePreviewThread)((ChartWizardContext)this.context).getLivePreviewThread()).add(lpt);
        }
        catch (ChartException e) {
            WizardBase.showException((String)e.getMessage());
        }
    }

    public Canvas getPreviewCanvas() {
        return this.previewCanvas;
    }

    public boolean isPreviewable() {
        return true;
    }

    protected IChartType getCurrentChartType() {
        return ChartUIUtil.getChartType((String)this.sType);
    }

    protected void createUIDescriptors(Composite parent) {
        for (TaskSelectTypeUIDescriptor descriptor : this.lstDescriptor) {
            if (!descriptor.isVisible()) continue;
            descriptor.createControl(parent);
        }
    }

    protected final void addTypeUIDescriptor(TaskSelectTypeUIDescriptor newDescriptor) {
        if (newDescriptor.getIndex() < 0) {
            this.lstDescriptor.add(newDescriptor);
            return;
        }
        int lastIndex = -1;
        int i = 0;
        while (i < this.lstDescriptor.size()) {
            TaskSelectTypeUIDescriptor descriptor = this.lstDescriptor.get(i);
            if (newDescriptor.getIndex() > lastIndex && newDescriptor.getIndex() <= descriptor.getIndex()) {
                this.lstDescriptor.add(i, newDescriptor);
                return;
            }
            lastIndex = descriptor.getIndex();
            ++i;
        }
        this.lstDescriptor.add(newDescriptor);
    }

    protected void addOptionalUIDescriptor() {
        this.addTypeUIDescriptor(new TaskSelectTypeUIDescriptor(this){

            @Override
            public int getIndex() {
                return 20;
            }

            @Override
            public void createControl(Composite parent) {
                lblOutput = new Label(parent, 64);
                GridData gd = new GridData(768);
                gd.horizontalIndent = 10;
                lblOutput.setLayoutData((Object)gd);
                lblOutput.setText(Messages.getString("TaskSelectType.Label.OutputFormat"));
                cbOutput = new Combo(parent, 12);
                gd = new GridData(768);
                cbOutput.setLayoutData((Object)gd);
                cbOutput.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        String outputFormat = outputFormats[cbOutput.getSelectionIndex()];
                        this.getContext().setOutputFormat(outputFormat);
                        this.createAndDisplayTypesSheet(sType);
                        this.setDefaultSubtypeSelection();
                        if (container != null && container instanceof ChartWizard) {
                            ((ChartWizard)container).updateApplyButton();
                        }
                    }
                });
                cbOutput.setItems(outputDisplayNames);
                String sCurrentFormat = this.getContext().getOutputFormat();
                int index = 0;
                while (index < outputFormats.length) {
                    if (outputFormats[index].equals(sCurrentFormat)) {
                        cbOutput.select(index);
                        break;
                    }
                    ++index;
                }
            }
        });
    }

    protected Orientation getAvailableOrientation(IChartType chartType, String dimension, Orientation refOrientation) {
        if (refOrientation == null) {
            return chartType.getDefaultOrientation();
        }
        if (refOrientation == Orientation.HORIZONTAL_LITERAL && !chartType.supportsTransposition(dimension)) {
            return chartType.getDefaultOrientation();
        }
        return refOrientation;
    }

    protected String getAvailableDimension(IChartType ct, String refDimension) {
        if (refDimension == null) {
            return ct.getDefaultDimension();
        }
        return refDimension;
    }

    protected void updateOverlaySeriesType() {
        Axis xAxis;
        if (this.chartModel instanceof ChartWithAxes && (xAxis = (Axis)((ChartWithAxes)this.chartModel).getAxes().get(0)).getAssociatedAxes().size() > 1) {
            String lastType = ChartCacheManager.getInstance().findSeriesType();
            Axis overlayAxis = (Axis)xAxis.getAssociatedAxes().get(1);
            if (!overlayAxis.getSeriesDefinitions().isEmpty()) {
                Series oseries = ((SeriesDefinition)overlayAxis.getSeriesDefinitions().get(0)).getDesignTimeSeries();
                String sDisplayName = oseries.getDisplayName();
                if (lastType != null) {
                    this.cbSeriesType.setText(lastType);
                } else {
                    this.cbSeriesType.setText(sDisplayName);
                }
                String seriesName = ChartUtil.stringValue((Object)oseries.getSeriesIdentifier());
                if (seriesName != null && seriesName.trim().length() != 0) {
                    for (Map.Entry<String, Series> entry : htSeriesNames.entrySet()) {
                        entry.getValue().setSeriesIdentifier((Object)seriesName);
                    }
                }
            }
            this.changeOverlaySeriesType();
        }
    }

    public abstract class TaskSelectTypeUIDescriptor {
        private boolean bVisible = true;

        public boolean isVisible() {
            return this.bVisible;
        }

        public void setVisible(boolean bVisible) {
            this.bVisible = bVisible;
        }

        public abstract int getIndex();

        public abstract void createControl(Composite var1);
    }
}

