/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.type;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Text;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.GanttSeries;
import org.eclipse.birt.chart.model.type.impl.GanttSeriesImpl;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.DefaultChartSubTypeImpl;
import org.eclipse.birt.chart.ui.swt.DefaultChartTypeImpl;
import org.eclipse.birt.chart.ui.swt.HelpContentImpl;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartSubType;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartType;
import org.eclipse.birt.chart.ui.swt.interfaces.IHelpContent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataCustomizeUI;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.DefaultBaseSeriesComponent;
import org.eclipse.birt.chart.ui.util.ChartCacheManager;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;

public class GanttChart
extends DefaultChartTypeImpl {
    public static final String TYPE_LITERAL = "Gantt Chart";
    protected static final String STANDARD_SUBTYPE_LITERAL = "Standard Gantt Chart";
    private static final String sStandardDescription = Messages.getString("GanttChart.Txt.Description");
    private transient Image imgIcon = UIHelper.getImage((String)"icons/obj16/ganttcharticon.gif");
    private transient Image img2D = null;

    public GanttChart() {
        this.chartTitle = Messages.getString("GanttChart.Txt.DefaultGanttChartTitle");
    }

    public String getName() {
        return TYPE_LITERAL;
    }

    public Image getImage() {
        return this.imgIcon;
    }

    public IHelpContent getHelp() {
        return new HelpContentImpl(TYPE_LITERAL, Messages.getString("GanttChart.Txt.HelpText"));
    }

    public Collection<IChartSubType> getChartSubtypes(String sDimension, Orientation orientation) {
        Vector<IChartSubType> vSubTypes = new Vector<IChartSubType>();
        if (sDimension.equals(TWO_DIMENSION_TYPE) || sDimension.equals(ChartDimension.TWO_DIMENSIONAL_LITERAL.getName())) {
            this.img2D = UIHelper.getImage((String)"icons/wizban/horizontalganttchartimage.gif");
            vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(STANDARD_SUBTYPE_LITERAL, this.img2D, sStandardDescription, Messages.getString("GanttChart.SubType.Standard")));
        }
        return vSubTypes;
    }

    public Chart getModel(String sSubType, Orientation orientation, String sDimension, Chart currentChart) {
        ChartWithAxes newChart = null;
        if (currentChart != null && (newChart = (ChartWithAxes)this.getConvertedChart(currentChart, sSubType, orientation, sDimension)) != null) {
            return newChart;
        }
        newChart = ChartWithAxesImpl.createDefault();
        newChart.setType(TYPE_LITERAL);
        newChart.setSubType(sSubType);
        ChartElementUtil.setEObjectAttribute((EObject)newChart, (String)"dimension", (Object)this.getDimensionFor(sDimension), (sDimension == null ? 1 : 0) != 0);
        ChartElementUtil.setEObjectAttribute((EObject)newChart, (String)"orientation", (Object)orientation, (orientation == null ? 1 : 0) != 0);
        try {
            ChartElementUtil.setDefaultValue((Object)newChart, (String)"orientation", (Object)Orientation.HORIZONTAL_LITERAL);
            ChartElementUtil.setDefaultValue((Object)newChart.getAxes().get(0), (String)"categoryAxis", (Object)true);
        }
        catch (ChartException chartException) {}
        Axis xAxis = (Axis)newChart.getAxes().get(0);
        xAxis.getLabel().setVisible(false);
        SeriesDefinition sdX = SeriesDefinitionImpl.createDefault();
        Series categorySeries = SeriesImpl.createDefault();
        sdX.getSeries().add((Object)categorySeries);
        xAxis.getSeriesDefinitions().add((Object)sdX);
        Axis yAxis = (Axis)xAxis.getAssociatedAxes().get(0);
        SeriesDefinition sdY = SeriesDefinitionImpl.createDefault();
        Series valueSeries = GanttSeriesImpl.createDefault();
        sdY.getSeries().add((Object)valueSeries);
        yAxis.getSeriesDefinitions().add((Object)sdY);
        this.addSampleData((Chart)newChart);
        return newChart;
    }

    private void addSampleData(Chart newChart) {
        SampleData sd = DataFactory.eINSTANCE.createSampleData();
        sd.getBaseSampleData().clear();
        sd.getOrthogonalSampleData().clear();
        BaseSampleData sdBase = DataFactory.eINSTANCE.createBaseSampleData();
        sdBase.setDataSetRepresentation("5,15,25");
        sd.getBaseSampleData().add((Object)sdBase);
        OrthogonalSampleData oSample = DataFactory.eINSTANCE.createOrthogonalSampleData();
        oSample.setDataSetRepresentation("S01/01/2005 E02/01/2005 Label1,S01/15/2005 E02/15/2005 Label2,S02/01/2005 E03/01/2005 Label3");
        oSample.setSeriesDefinitionIndex(0);
        sd.getOrthogonalSampleData().add((Object)oSample);
        newChart.setSampleData(sd);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Chart getConvertedChart(Chart currentChart, String sNewSubType, Orientation newOrientation, String sNewDimension) {
        Chart helperModel = currentChart.copyInstance();
        helperModel.eAdapters().addAll((Collection)currentChart.eAdapters());
        ChartCacheManager.getInstance().cacheSeries(ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)helperModel));
        IChartType oldType = ChartUIUtil.getChartType((String)currentChart.getType());
        if (currentChart instanceof ChartWithAxes) {
            if (currentChart.getType().equals(TYPE_LITERAL)) {
                if (!currentChart.getSubType().equals(sNewSubType)) {
                    currentChart.setSubType(sNewSubType);
                    EList axes = ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes();
                    int i = 0;
                    while (i < axes.size()) {
                        ((Axis)axes.get(i)).setPercent(false);
                        EList seriesdefinitions = ((Axis)axes.get(i)).getSeriesDefinitions();
                        int j = 0;
                        while (j < seriesdefinitions.size()) {
                            Series series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                            series.unsetStacked();
                            ++j;
                        }
                        ++i;
                    }
                }
                ChartElementUtil.setEObjectAttribute((EObject)currentChart, (String)"orientation", (Object)newOrientation, (newOrientation == null ? 1 : 0) != 0);
                try {
                    ChartElementUtil.setDefaultValue((Object)currentChart, (String)"orientation", (Object)Orientation.HORIZONTAL_LITERAL);
                }
                catch (ChartException chartException) {}
                ChartElementUtil.setEObjectAttribute((EObject)currentChart, (String)"dimension", (Object)this.getDimensionFor(sNewDimension), (sNewDimension == null ? 1 : 0) != 0);
                return currentChart;
            }
            if (!currentChart.getType().equals("Line Chart") && !currentChart.getType().equals("Area Chart") && !currentChart.getType().equals("Bar Chart") && !currentChart.getType().equals("Tube Chart") && !currentChart.getType().equals("Cone Chart") && !currentChart.getType().equals("Pyramid Chart") && !currentChart.getType().equals("Scatter Chart") && !currentChart.getType().equals("Stock Chart") && !currentChart.getType().equals("Bubble Chart") && !currentChart.getType().equals("Difference Chart")) return null;
            currentChart.setType(TYPE_LITERAL);
            currentChart.setSubType(sNewSubType);
            Text title = currentChart.getTitle().getLabel().getCaption();
            if (title.getValue() != null && (title.getValue().trim().length() == 0 || title.getValue().trim().equals(oldType.getDefaultTitle().trim()))) {
                title.setValue(this.getDefaultTitle());
            }
            EList axes = ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes();
            int i = 0;
            int seriesIndex = 0;
            while (i < axes.size()) {
                ((Axis)axes.get(i)).setPercent(false);
                ((Axis)axes.get(i)).setType(AxisType.DATE_TIME_LITERAL);
                EList seriesdefinitions = ((Axis)axes.get(i)).getSeriesDefinitions();
                int j = 0;
                while (j < seriesdefinitions.size()) {
                    Series series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                    series = this.getConvertedSeries(series, seriesIndex++);
                    series.unsetStacked();
                    ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().clear();
                    ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().add((Object)series);
                    ++j;
                }
                ++i;
            }
            currentChart.setSampleData(this.getConvertedSampleData(currentChart.getSampleData(), ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getType(), AxisType.DATE_TIME_LITERAL));
        } else {
            currentChart = ChartWithAxesImpl.createDefault();
            this.copyChartProperties(helperModel, currentChart);
            currentChart.setType(TYPE_LITERAL);
            currentChart.setSubType(sNewSubType);
            ChartElementUtil.setEObjectAttribute((EObject)currentChart, (String)"orientation", (Object)newOrientation, (newOrientation == null ? 1 : 0) != 0);
            ChartElementUtil.setEObjectAttribute((EObject)currentChart, (String)"dimension", (Object)this.getDimensionFor(sNewDimension), (sNewDimension == null ? 1 : 0) != 0);
            try {
                ChartElementUtil.setDefaultValue((Object)currentChart, (String)"orientation", (Object)Orientation.HORIZONTAL_LITERAL);
                ChartElementUtil.setDefaultValue((Object)((ChartWithAxes)currentChart).getAxes().get(0), (String)"categoryAxis", (Object)true);
            }
            catch (ChartException chartException) {}
            Axis xAxis = (Axis)((ChartWithAxes)currentChart).getAxes().get(0);
            Axis yAxis = (Axis)xAxis.getAssociatedAxes().get(0);
            currentChart.setSampleData(this.getConvertedSampleData(currentChart.getSampleData(), ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getType(), AxisType.DATE_TIME_LITERAL));
            xAxis.getSeriesDefinitions().clear();
            xAxis.getSeriesDefinitions().add((Object)((SeriesDefinition)((ChartWithoutAxes)helperModel).getSeriesDefinitions().get(0)));
            yAxis.getSeriesDefinitions().clear();
            yAxis.getSeriesDefinitions().addAll((Collection)((SeriesDefinition)xAxis.getSeriesDefinitions().get(0)).getSeriesDefinitions());
            yAxis.setType(AxisType.DATE_TIME_LITERAL);
            Series series = ((SeriesDefinition)xAxis.getSeriesDefinitions().get(0)).getDesignTimeSeries();
            ((SeriesDefinition)xAxis.getSeriesDefinitions().get(0)).getSeries().clear();
            ((SeriesDefinition)xAxis.getSeriesDefinitions().get(0)).getSeries().add((Object)series);
            EList seriesdefinitions = yAxis.getSeriesDefinitions();
            int j = 0;
            while (j < seriesdefinitions.size()) {
                series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                series = this.getConvertedSeries(series, j);
                series.getLabel().unsetVisible();
                series.unsetStacked();
                ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().clear();
                ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().add((Object)series);
                ++j;
            }
            Text title = currentChart.getTitle().getLabel().getCaption();
            if (title.getValue() != null && (title.getValue().trim().length() == 0 || title.getValue().trim().equals(oldType.getDefaultTitle().trim()))) {
                title.setValue(this.getDefaultTitle());
            }
        }
        ChartElementUtil.setEObjectAttribute((EObject)currentChart, (String)"orientation", (Object)newOrientation, (newOrientation == null ? 1 : 0) != 0);
        try {
            ChartElementUtil.setDefaultValue((Object)currentChart, (String)"orientation", (Object)Orientation.HORIZONTAL_LITERAL);
        }
        catch (ChartException chartException) {}
        ChartElementUtil.setEObjectAttribute((EObject)currentChart, (String)"dimension", (Object)this.getDimensionFor(sNewDimension), (sNewDimension == null ? 1 : 0) != 0);
        ChartUIUtil.updateDefaultAggregations((Chart)currentChart);
        return currentChart;
    }

    private Series getConvertedSeries(Series series, int seriesIndex) {
        if (series.getClass().getName().equals("org.eclipse.birt.chart.model.component.impl.SeriesImpl")) {
            return series;
        }
        GanttSeries ganttseries = (GanttSeries)ChartCacheManager.getInstance().findSeries(GanttSeriesImpl.class.getName(), seriesIndex);
        if (ganttseries == null) {
            ganttseries = (GanttSeries)GanttSeriesImpl.createDefault();
        }
        ChartUIUtil.copyGeneralSeriesAttributes((Series)series, (Series)ganttseries);
        return ganttseries;
    }

    public String[] getSupportedDimensions() {
        return new String[]{TWO_DIMENSION_TYPE};
    }

    public String getDefaultDimension() {
        return TWO_DIMENSION_TYPE;
    }

    public boolean supportsTransposition() {
        return false;
    }

    private ChartDimension getDimensionFor(String sDimension) {
        return ChartDimension.TWO_DIMENSIONAL_LITERAL;
    }

    public Orientation getDefaultOrientation() {
        return Orientation.HORIZONTAL_LITERAL;
    }

    public ISelectDataComponent getBaseUI(Chart chart, ISelectDataCustomizeUI selectDataUI, ChartWizardContext context, String sTitle) {
        return new DefaultBaseSeriesComponent((SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)chart).get(0), context, sTitle);
    }

    public String getDisplayName() {
        return Messages.getString("GanttChart.Txt.DisplayName");
    }

    public Series getSeries() {
        return this.getSeries(true);
    }

    public Series getSeries(boolean needInitialing) {
        if (needInitialing) {
            return GanttSeriesImpl.create();
        }
        return GanttSeriesImpl.createDefault();
    }
}

