/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.jdbc.gen;

import com.google.gwtorm.client.OrmException;
import com.google.gwtorm.jdbc.Database;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.jdbc.gen.AccessGen;
import com.google.gwtorm.jdbc.gen.GeneratedClassLoader;
import com.google.gwtorm.schema.RelationModel;
import com.google.gwtorm.schema.SequenceModel;
import com.google.gwtorm.schema.Util;
import com.google.gwtorm.schema.java.JavaSchemaModel;
import com.google.gwtorm.schema.sql.SqlDialect;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class SchemaGen
implements Opcodes {
    private final GeneratedClassLoader classLoader;
    private final JavaSchemaModel schema;
    private final SqlDialect dialect;
    private List<RelationGen> relations;
    private ClassWriter cw;
    private String superTypeName;
    private String implClassName;
    private String implTypeName;

    public SchemaGen(GeneratedClassLoader loader, JavaSchemaModel schemaModel, SqlDialect sqlDialect) {
        this.classLoader = loader;
        this.schema = schemaModel;
        this.dialect = sqlDialect;
    }

    public void defineClass() throws OrmException {
        this.defineRelationClasses();
        this.init();
        this.implementRelationFields();
        this.implementConstructor();
        this.implementSequenceMethods();
        this.implementRelationMethods();
        this.cw.visitEnd();
        this.classLoader.defineClass(this.getImplClassName(), this.cw.toByteArray());
    }

    String getSchemaClassName() {
        return this.schema.getSchemaClassName();
    }

    String getImplClassName() {
        return this.implClassName;
    }

    String getImplTypeName() {
        return this.implTypeName;
    }

    private void defineRelationClasses() throws OrmException {
        this.relations = new ArrayList<RelationGen>();
        for (RelationModel rel : this.schema.getRelations()) {
            RelationGen g = new RelationGen(rel);
            this.relations.add(g);
            new AccessGen(this.classLoader, g).defineClass();
        }
    }

    private void init() {
        this.superTypeName = Type.getInternalName(JdbcSchema.class);
        this.implClassName = this.getSchemaClassName() + "_Schema_" + Util.createRandomName();
        this.implTypeName = this.implClassName.replace('.', '/');
        this.cw = new ClassWriter(1);
        this.cw.visit(47, 49, this.implTypeName, null, this.superTypeName, new String[]{this.getSchemaClassName().replace('.', '/')});
    }

    private void implementRelationFields() {
        for (RelationGen info : this.relations) {
            info.implementField();
        }
    }

    private void implementConstructor() {
        String consName = "<init>";
        String consDesc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Database.class), Type.getType(Connection.class)});
        MethodVisitor mv = this.cw.visitMethod(1, "<init>", consDesc, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(183, this.superTypeName, "<init>", consDesc);
        for (RelationGen info : this.relations) {
            mv.visitVarInsn(25, 0);
            mv.visitTypeInsn(187, info.accessType.getInternalName());
            mv.visitInsn(89);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, info.accessType.getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(JdbcSchema.class)}));
            mv.visitFieldInsn(181, this.implTypeName, info.getAccessInstanceFieldName(), info.accessType.getDescriptor());
        }
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementSequenceMethods() {
        for (SequenceModel seq : this.schema.getSequences()) {
            Type retType = Type.getType(seq.getResultType());
            MethodVisitor mv = this.cw.visitMethod(1, seq.getMethodName(), Type.getMethodDescriptor((Type)retType, (Type[])new Type[0]), null, new String[]{Type.getType(OrmException.class).getInternalName()});
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn((Object)this.dialect.getNextSequenceValueSql(seq.getSequenceName()));
            mv.visitMethodInsn(182, this.superTypeName, "nextLong", Type.getMethodDescriptor((Type)Type.getType(Long.TYPE), (Type[])new Type[]{Type.getType(String.class)}));
            if (retType.getSize() == 1) {
                mv.visitInsn(136);
                mv.visitInsn(172);
            } else {
                mv.visitInsn(173);
            }
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
        }
    }

    private void implementRelationMethods() {
        for (RelationGen info : this.relations) {
            info.implementMethod();
        }
    }

    class RelationGen {
        final RelationModel model;
        String accessClassName;
        Type accessType;

        RelationGen(RelationModel model) {
            this.model = model;
        }

        SqlDialect getDialect() {
            return SchemaGen.this.dialect;
        }

        void implementField() {
            this.accessType = Type.getObjectType((String)this.accessClassName.replace('.', '/'));
            SchemaGen.this.cw.visitField(18, this.getAccessInstanceFieldName(), this.accessType.getDescriptor(), null, null).visitEnd();
        }

        String getAccessInstanceFieldName() {
            return "access_" + this.model.getMethodName();
        }

        void implementMethod() {
            MethodVisitor mv = SchemaGen.this.cw.visitMethod(17, this.model.getMethodName(), Type.getMethodDescriptor((Type)Type.getObjectType((String)this.model.getAccessInterfaceName().replace('.', '/')), (Type[])new Type[0]), null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, SchemaGen.this.implTypeName, this.getAccessInstanceFieldName(), this.accessType.getDescriptor());
            mv.visitInsn(176);
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
        }
    }
}

