/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.parts.processes;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.jwt.meta.model.core.Package;
import org.eclipse.jwt.meta.model.processes.Action;
import org.eclipse.jwt.meta.model.processes.Activity;
import org.eclipse.jwt.meta.model.processes.ActivityLinkNode;
import org.eclipse.jwt.meta.model.processes.ProcessesFactory;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.parts.processes.ExecutableNodeEditPart;
import org.eclipse.jwt.we.parts.processes.policies.ActionGraphicalNodeEditPolicy;

public class ActivityLinkNodeEditPart
extends ExecutableNodeEditPart {
    private static final int MAXIMUM_IN_EDGES = 1;
    private static final int MAXIMUM_OUT_EDGES = 1;

    public ActivityLinkNodeEditPart() {
        this.setMaximumInActivityEdges(1);
        this.setMaximumOutActivityEdges(1);
    }

    public Class getModelClass() {
        return ActivityLinkNode.class;
    }

    protected IFigure createFigure() {
        this.setDoDirectEdit(true);
        return super.createFigure();
    }

    public void performRequest(Request request) {
        super.performRequest(request);
        if (request.getType() == "open") {
            Activity linkedactivity = ((ActivityLinkNode)this.getModel()).getLinksto();
            WEEditor ape = this.getWEEditor();
            if (ape != null) {
                if (linkedactivity == null) {
                    EObject object = (EObject)this.getModel();
                    while (object.eContainer() != null && !(object instanceof Package)) {
                        object = object.eContainer();
                    }
                    Activity newActivity = ProcessesFactory.eINSTANCE.createActivity();
                    ((Package)object).getElements().add((Object)newActivity);
                    newActivity.setName(PluginProperties.wizards_ModelWizardActivity_std);
                    linkedactivity = newActivity;
                    ((ActivityLinkNode)this.getModel()).setLinksto(linkedactivity);
                }
                ape.openActivityInNewPage(linkedactivity);
            }
        }
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ActionGraphicalNodeEditPolicy(this.getMaximumInActivityEdges(), this.getMaximumOutActivityEdges()));
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        int featureId = notification.getFeatureID(Action.class);
        switch (featureId) {
            case 5: {
                this.refreshVisuals();
            }
        }
    }
}

