/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.interpreter;

import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xcore.XClass;
import org.eclipse.emf.ecore.xcore.XEnumLiteral;
import org.eclipse.emf.ecore.xcore.XNamedElement;
import org.eclipse.emf.ecore.xcore.XOperation;
import org.eclipse.emf.ecore.xcore.XStructuralFeature;
import org.eclipse.emf.ecore.xcore.mappings.ToXcoreMapping;
import org.eclipse.emf.ecore.xcore.mappings.XcoreMapper;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.interpreter.IEvaluationContext;
import org.eclipse.xtext.xbase.interpreter.impl.EvaluationException;
import org.eclipse.xtext.xbase.interpreter.impl.XbaseInterpreter;

public class XcoreInterpreter
extends XbaseInterpreter {
    @Inject
    private XcoreMapper mapper;

    protected Object invokeOperation(JvmOperation operation, Object receiver, List<Object> argumentValues) {
        ToXcoreMapping mapping;
        if (receiver instanceof EObject && (mapping = this.mapper.getToXcoreMapping((EObject)operation)) != null) {
            XNamedElement element = mapping.getXcoreElement();
            if (element instanceof XOperation) {
                EOperation op = this.mapper.getMapping((XOperation)element).getEOperation();
                try {
                    return ((EObject)receiver).eInvoke(op, (EList)new BasicEList(argumentValues));
                }
                catch (InvocationTargetException e) {
                    throw new EvaluationException((Throwable)e);
                }
            }
            if (element instanceof XStructuralFeature) {
                EStructuralFeature feature = this.mapper.getMapping((XStructuralFeature)element).getEStructuralFeature();
                String accessorName = operation.getSimpleName();
                if (accessorName.startsWith("get") || accessorName.startsWith("is")) {
                    try {
                        return ((EObject)receiver).eGet(feature);
                    }
                    catch (Throwable e) {
                        throw new EvaluationException(e);
                    }
                }
                if (accessorName.startsWith("set")) {
                    try {
                        ((EObject)receiver).eSet(feature, argumentValues.get(0));
                        return null;
                    }
                    catch (Throwable e) {
                        throw new EvaluationException(e);
                    }
                }
            }
        }
        return super.invokeOperation(operation, receiver, argumentValues);
    }

    protected Object featureCallField(JvmField jvmField, Object receiver) {
        EEnumLiteral literal;
        ToXcoreMapping mapping = this.mapper.getToXcoreMapping((EObject)jvmField);
        XNamedElement xcoreElement = mapping.getXcoreElement();
        if (xcoreElement instanceof XEnumLiteral && (literal = this.mapper.getMapping((XEnumLiteral)xcoreElement).getEEnumLiteral()) != null) {
            return literal;
        }
        return super.featureCallField(jvmField, receiver);
    }

    protected Object _doEvaluate(XInstanceOfExpression instanceOf, IEvaluationContext context, CancelIndicator indicator) {
        ToXcoreMapping mapping = this.mapper.getToXcoreMapping((EObject)instanceOf.getType().getType());
        XClass xClass = (XClass)mapping.getXcoreElement();
        if (xClass != null) {
            Object instance = this.internalEvaluate(instanceOf.getExpression(), context, indicator);
            EClass eClass = this.mapper.getMapping(xClass).getEClass();
            return eClass.isInstance(instance);
        }
        return super._doEvaluate(instanceOf, context, indicator);
    }

    protected Object _doEvaluate(XCastedExpression castedExpression, IEvaluationContext context, CancelIndicator indicator) {
        JvmType castType = castedExpression.getType().getType();
        ToXcoreMapping mapping = this.mapper.getToXcoreMapping((EObject)castType);
        XClass xClass = (XClass)mapping.getXcoreElement();
        if (xClass != null) {
            Object result = this.internalEvaluate(castedExpression.getTarget(), context, indicator);
            EClass eClass = this.mapper.getMapping(xClass).getEClass();
            if (eClass.isInstance(result)) {
                return result;
            }
            throw new EvaluationException((Throwable)new ClassCastException(castType.getQualifiedName()));
        }
        return super._doEvaluate(castedExpression, context, indicator);
    }
}

