/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.clad;

import java.lang.reflect.Constructor;
import java.util.Hashtable;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractBpmn2PropertySection;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDialogComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractListComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.IPropertiesCompositeFactory;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.Messages;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PropertiesCompositeFactory
implements IPropertiesCompositeFactory {
    protected static final Hashtable<TargetRuntime, Hashtable<Class, Class>> detailRegistry = new Hashtable();
    protected static final Hashtable<TargetRuntime, Hashtable<Class, Class>> listRegistry = new Hashtable();
    protected static final Hashtable<TargetRuntime, Hashtable<Class, Class>> dialogRegistry = new Hashtable();
    public static IPropertiesCompositeFactory INSTANCE = new PropertiesCompositeFactory();

    public static void register(Class eClass, Class composite, TargetRuntime targetRuntime) {
        Hashtable<Class<Object>, Class<Object>> map = null;
        if (AbstractListComposite.class.isAssignableFrom(composite)) {
            map = listRegistry.get(targetRuntime);
        } else if (AbstractDialogComposite.class.isAssignableFrom(composite)) {
            map = dialogRegistry.get(targetRuntime);
        } else if (AbstractDetailComposite.class.isAssignableFrom(composite)) {
            map = detailRegistry.get(targetRuntime);
        } else {
            throw new IllegalArgumentException(NLS.bind((String)Messages.PropertiesCompositeFactory_Unknown_Type, (Object)composite.getName()));
        }
        if (map == null) {
            map = new Hashtable();
            if (AbstractListComposite.class.isAssignableFrom(composite)) {
                listRegistry.put(targetRuntime, map);
            } else if (AbstractDialogComposite.class.isAssignableFrom(composite)) {
                dialogRegistry.put(targetRuntime, map);
            } else if (AbstractDetailComposite.class.isAssignableFrom(composite)) {
                detailRegistry.put(targetRuntime, map);
            }
        }
        map.put(eClass, composite);
        try {
            Class<?> ec = composite.getEnclosingClass();
            if (ec != null) {
                if (AbstractDialogComposite.class.isAssignableFrom(composite)) {
                    composite.getConstructor(ec, Composite.class, EClass.class, Integer.TYPE);
                } else {
                    composite.getConstructor(ec, AbstractBpmn2PropertySection.class);
                    composite.getConstructor(ec, Composite.class, Integer.TYPE);
                }
            } else if (AbstractDialogComposite.class.isAssignableFrom(composite)) {
                composite.getConstructor(Composite.class, EClass.class, Integer.TYPE);
            } else {
                composite.getConstructor(AbstractBpmn2PropertySection.class);
                composite.getConstructor(Composite.class, Integer.TYPE);
            }
        }
        catch (Exception e) {
            Activator.logError(e);
        }
    }

    public static Class findDetailCompositeClass(Class eClass, TargetRuntime targetRuntime) {
        Class composite = PropertiesCompositeFactory.findCompositeClass(detailRegistry.get(targetRuntime), eClass);
        if (composite == null && targetRuntime != TargetRuntime.getDefaultRuntime()) {
            targetRuntime = TargetRuntime.getDefaultRuntime();
            composite = PropertiesCompositeFactory.findCompositeClass(detailRegistry.get(targetRuntime), eClass);
        }
        return composite;
    }

    @Override
    public AbstractDetailComposite createDetailComposite(Class eClass, AbstractBpmn2PropertySection section, TargetRuntime targetRuntime) {
        Class clazz = PropertiesCompositeFactory.findDetailCompositeClass(eClass, targetRuntime);
        return (AbstractDetailComposite)PropertiesCompositeFactory.createComposite(clazz, eClass, section);
    }

    @Override
    public AbstractDetailComposite createDetailComposite(Class eClass, Composite parent, TargetRuntime targetRuntime, int style) {
        Class clazz = PropertiesCompositeFactory.findDetailCompositeClass(eClass, targetRuntime);
        return (AbstractDetailComposite)PropertiesCompositeFactory.createComposite(clazz, eClass, parent, style);
    }

    public static Class findListCompositeClass(Class eClass, TargetRuntime targetRuntime) {
        Class composite = PropertiesCompositeFactory.findCompositeClass(listRegistry.get(targetRuntime), eClass);
        if (composite == null && targetRuntime != TargetRuntime.getDefaultRuntime()) {
            targetRuntime = TargetRuntime.getDefaultRuntime();
            composite = PropertiesCompositeFactory.findCompositeClass(listRegistry.get(targetRuntime), eClass);
        }
        return composite;
    }

    @Override
    public AbstractListComposite createListComposite(Class eClass, AbstractBpmn2PropertySection section, TargetRuntime targetRuntime) {
        Class clazz = PropertiesCompositeFactory.findListCompositeClass(eClass, targetRuntime);
        return (AbstractListComposite)PropertiesCompositeFactory.createComposite(clazz, eClass, section);
    }

    @Override
    public AbstractListComposite createListComposite(Class eClass, Composite parent, TargetRuntime targetRuntime, int style) {
        Class clazz = PropertiesCompositeFactory.findListCompositeClass(eClass, targetRuntime);
        return (AbstractListComposite)PropertiesCompositeFactory.createComposite(clazz, eClass, parent, style);
    }

    public static Class findDialogCompositeClass(Class eClass, TargetRuntime targetRuntime) {
        Class composite = PropertiesCompositeFactory.findCompositeClass(dialogRegistry.get(targetRuntime), eClass);
        if (composite == null && targetRuntime != TargetRuntime.getDefaultRuntime()) {
            targetRuntime = TargetRuntime.getDefaultRuntime();
            composite = PropertiesCompositeFactory.findCompositeClass(dialogRegistry.get(targetRuntime), eClass);
        }
        return composite;
    }

    @Override
    public AbstractDialogComposite createDialogComposite(EClass eClass, Composite parent, TargetRuntime targetRuntime, int style) {
        Class clazz = PropertiesCompositeFactory.findDialogCompositeClass(eClass.getInstanceClass(), targetRuntime);
        Composite composite = null;
        int i = 0;
        while (i < 2 && composite == null) {
            try {
                Constructor ctor = null;
                Class<?> ec = clazz.getEnclosingClass();
                if (ec != null) {
                    ctor = clazz.getConstructor(ec, Composite.class, EClass.class, Integer.TYPE);
                    composite = (Composite)ctor.newInstance(null, parent, eClass, style);
                } else {
                    ctor = clazz.getConstructor(Composite.class, EClass.class, Integer.TYPE);
                    composite = (Composite)ctor.newInstance(parent, eClass, style);
                }
            }
            catch (Exception e) {
                if (i == 0) {
                    PropertiesCompositeFactory.logError(eClass.getInstanceClass(), e);
                }
                clazz = PropertiesCompositeFactory.findDialogCompositeClass(EObject.class, targetRuntime);
            }
            ++i;
        }
        return (AbstractDialogComposite)composite;
    }

    private static Class findCompositeClass(Hashtable<Class, Class> map, Class eClass) {
        if (map != null) {
            while (eClass != null && eClass != EObjectImpl.class) {
                Class composite;
                Class<?> iface;
                if (map.containsKey(eClass)) {
                    return map.get(eClass);
                }
                Class<?>[] classArray = eClass.getInterfaces();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    iface = classArray[n2];
                    if (map.containsKey(iface)) {
                        return map.get(iface);
                    }
                    composite = PropertiesCompositeFactory.findCompositeClass(map, iface);
                    if (composite != null) {
                        return composite;
                    }
                    ++n2;
                }
                if (eClass.isInterface()) {
                    classArray = eClass.getInterfaces();
                    n = classArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        iface = classArray[n2];
                        composite = PropertiesCompositeFactory.findCompositeClass(map, iface);
                        if (composite != null) {
                            return composite;
                        }
                        ++n2;
                    }
                }
                eClass = eClass.getSuperclass();
            }
        }
        return null;
    }

    private static Composite createComposite(Class clazz, Class eClass, AbstractBpmn2PropertySection section) {
        Composite composite = null;
        if (clazz != null) {
            try {
                Constructor ctor = null;
                Class<?> ec = clazz.getEnclosingClass();
                if (ec != null) {
                    ctor = clazz.getConstructor(ec, AbstractBpmn2PropertySection.class);
                    composite = (Composite)ctor.newInstance(null, section);
                } else {
                    ctor = clazz.getConstructor(AbstractBpmn2PropertySection.class);
                    composite = (Composite)ctor.newInstance(section);
                }
            }
            catch (Exception e) {
                PropertiesCompositeFactory.logError(eClass, e);
            }
        }
        return composite;
    }

    private static Composite createComposite(Class clazz, Class eClass, Composite parent, int style) {
        Composite composite = null;
        if (clazz != null) {
            try {
                Constructor ctor = null;
                Class<?> ec = clazz.getEnclosingClass();
                if (ec != null) {
                    ctor = clazz.getConstructor(ec, Composite.class, Integer.TYPE);
                    composite = (Composite)ctor.newInstance(null, parent, style);
                } else {
                    ctor = clazz.getConstructor(Composite.class, Integer.TYPE);
                    composite = (Composite)ctor.newInstance(parent, style);
                }
            }
            catch (Exception e) {
                PropertiesCompositeFactory.logError(eClass, e);
            }
        }
        if (composite != null && parent.getLayout() instanceof GridLayout) {
            GridLayout layout = (GridLayout)parent.getLayout();
            composite.setLayoutData((Object)new GridData(4, 4, true, true, layout.numColumns, 1));
        }
        return composite;
    }

    private static void logError(Class eClass, Exception e) {
        Activator.logError(e);
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.PropertiesCompositeFactory_Internal_Error_Title, (String)NLS.bind((String)Messages.PropertiesCompositeFactory_No_Property_Sheet, (Object)eClass, (Object)e.getMessage()));
    }
}

