/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.values;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.values.CollectionValueImpl;
import org.eclipse.ocl.pivot.internal.values.SparseSequenceValueImpl;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.OrderedCollectionValue;
import org.eclipse.ocl.pivot.values.OrderedSetValue;
import org.eclipse.ocl.pivot.values.SequenceValue;
import org.eclipse.ocl.pivot.values.ValuesPackage;

public abstract class SequenceValueImpl
extends CollectionValueImpl
implements SequenceValue {
    @Override
    protected EClass eStaticClass() {
        return ValuesPackage.Literals.SEQUENCE_VALUE;
    }

    public SequenceValueImpl(@NonNull CollectionTypeId typeId, @NonNull List<? extends Object> values) {
        super(typeId, values);
    }

    @Override
    public @NonNull OrderedCollectionValue append(@Nullable Object object) {
        if (object instanceof InvalidValueException) {
            throw new InvalidValueException(PivotMessages.InvalidSource, "append");
        }
        ArrayList<Object> result = new ArrayList<Object>(this.elements);
        result.add(object);
        return new SparseSequenceValueImpl(this.getTypeId(), (List<? extends Object>)result);
    }

    @Override
    public @NonNull OrderedCollectionValue appendAll(@NonNull OrderedCollectionValue objects) {
        ArrayList<? extends Object> result = new ArrayList<Object>(this.elements);
        result.addAll(objects.getElements());
        return new SparseSequenceValueImpl(this.getTypeId(), (List<? extends Object>)result);
    }

    @Override
    public @NonNull List<? extends Object> asList() {
        return this.getElements();
    }

    @Override
    public @NonNull OrderedCollectionValue asOrderedCollectionValue() {
        return this;
    }

    @Override
    public @NonNull SequenceValue asSequenceValue() {
        return this;
    }

    @Override
    public @NonNull List<Object> asUnboxedObject(@NonNull IdResolver idResolver) {
        ArrayList<Object> unboxedValues = new ArrayList<Object>();
        for (Object boxedValue : this.elements) {
            unboxedValues.add(idResolver.unboxedValueOf(boxedValue));
        }
        return unboxedValues;
    }

    @Override
    public @Nullable Object at(int index) {
        if (--index < 0 || this.elements.size() <= index) {
            throw new InvalidValueException(PivotMessages.IndexOutOfRange, index + 1, this.size());
        }
        return this.getElements().get(index);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SequenceValue) || obj instanceof OrderedSetValue) {
            return false;
        }
        Iterator<@Nullable Object> theseElements = this.iterator();
        Iterator<@Nullable Object> thoseElements = ((SequenceValue)obj).iterator();
        while (theseElements.hasNext() && thoseElements.hasNext()) {
            Object thatValue;
            Object thisValue = theseElements.next();
            if (ClassUtil.safeEquals(thisValue, thatValue = thoseElements.next())) continue;
            return false;
        }
        return !theseElements.hasNext() && !thoseElements.hasNext();
    }

    @Override
    public @NonNull SequenceValue excluding(@Nullable Object value) {
        ArrayList result = new ArrayList();
        if (value == null) {
            for (Object element : this.elements) {
                if (element == null) continue;
                result.add(element);
            }
        } else {
            for (Object element : this.elements) {
                if (value.equals(element)) continue;
                result.add(element);
            }
        }
        if (result.size() < this.elements.size()) {
            return new SparseSequenceValueImpl(this.getTypeId(), result);
        }
        return this;
    }

    @Override
    public @NonNull SequenceValue excludingAll(@NonNull CollectionValue values) {
        ArrayList result = new ArrayList();
        for (Object element : this.elements) {
            boolean reject = false;
            if (element == null) {
                for (Object value : values) {
                    if (value != null) continue;
                    reject = true;
                    break;
                }
            } else {
                for (Object value : values) {
                    if (value == null || !value.equals(element)) continue;
                    reject = true;
                    break;
                }
            }
            if (reject) continue;
            result.add(element);
        }
        if (result.size() < this.elements.size()) {
            return new SparseSequenceValueImpl(this.getTypeId(), result);
        }
        return this;
    }

    @Override
    public @Nullable Object first() {
        if (this.elements.size() <= 0) {
            throw new InvalidValueException(PivotMessages.EmptyCollection, "Sequence", "first");
        }
        return this.getElements().get(0);
    }

    @Override
    public @NonNull SequenceValue flatten() {
        ArrayList<Object> flattened = new ArrayList<Object>();
        if (this.flatten(flattened)) {
            return new SparseSequenceValueImpl(this.getTypeId(), (List<? extends Object>)flattened);
        }
        return this;
    }

    public @NonNull List<? extends Object> getElements() {
        return (List)this.elements;
    }

    @Override
    public @NonNull String getKind() {
        return "Sequence";
    }

    @Override
    public @NonNull SequenceValue including(@Nullable Object value) {
        if (value instanceof InvalidValueException) {
            throw new InvalidValueException(PivotMessages.InvalidSource, "including");
        }
        ArrayList<Object> result = new ArrayList<Object>(this.elements);
        result.add(value);
        return new SparseSequenceValueImpl(this.getTypeId(), (List<? extends Object>)result);
    }

    @Override
    public @NonNull SequenceValue includingAll(@NonNull CollectionValue values) {
        ArrayList<Object> result = new ArrayList<Object>(this.elements);
        for (Object value : values) {
            result.add(value);
        }
        return new SparseSequenceValueImpl(this.getTypeId(), (List<? extends Object>)result);
    }

    @Override
    public @NonNull IntegerValue indexOf(@Nullable Object object) {
        int index = this.getElements().indexOf(object);
        if (index < 0) {
            throw new InvalidValueException(PivotMessages.MissingValue, "indexOf");
        }
        return ValueUtil.integerValueOf(index + 1);
    }

    @Override
    public @NonNull SequenceValue insertAt(int index, @Nullable Object object) {
        if (object instanceof InvalidValueException) {
            throw new InvalidValueException(PivotMessages.InvalidSource, "insertAt");
        }
        if (--index < 0 || index > this.elements.size()) {
            throw new InvalidValueException(PivotMessages.IndexOutOfRange, index + 1, this.size());
        }
        ArrayList<Object> result = new ArrayList<Object>(this.elements);
        result.add(index, object);
        return new SparseSequenceValueImpl(this.getTypeId(), (List<? extends Object>)result);
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public @Nullable Object last() {
        int size = this.elements.size();
        if (size <= 0) {
            throw new InvalidValueException(PivotMessages.EmptyCollection, "Sequence", "last");
        }
        return this.getElements().get(size - 1);
    }

    @Override
    public @NonNull SequenceValue prepend(@Nullable Object object) {
        if (object instanceof InvalidValueException) {
            throw new InvalidValueException(PivotMessages.InvalidSource, "prepend");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(object);
        result.addAll(this.elements);
        return new SparseSequenceValueImpl(this.getTypeId(), (List<? extends Object>)result);
    }

    @Override
    public @NonNull SequenceValue prependAll(@NonNull OrderedCollectionValue objects) {
        ArrayList<? extends Object> result = new ArrayList<Object>(objects.getElements());
        result.addAll(this.elements);
        return new SparseSequenceValueImpl(this.getTypeId(), (List<? extends Object>)result);
    }

    @Override
    public @NonNull SequenceValue reverse() {
        ArrayList elements = new ArrayList(this.elements);
        Collections.reverse(elements);
        return new SparseSequenceValueImpl(this.getTypeId(), elements);
    }

    @Override
    public @NonNull SequenceValue sort(@NonNull Comparator<Object> comparator) {
        ArrayList values = new ArrayList(this.elements);
        Collections.sort(values, comparator);
        return new SparseSequenceValueImpl(this.getTypeId(), values);
    }

    @Override
    public @NonNull SequenceValue subSequence(int lower, int upper) {
        --upper;
        if (--lower < 0) {
            throw new InvalidValueException(new IndexOutOfBoundsException("lower: " + (lower + 1)));
        }
        if (upper >= this.elements.size()) {
            throw new InvalidValueException(new IndexOutOfBoundsException("upper: " + (upper + 1) + ", size: " + this.size()));
        }
        if (upper < lower) {
            throw new InvalidValueException(new IllegalArgumentException("lower: " + (lower + 1) + ", upper: " + (upper + 1)));
        }
        ArrayList<Object> result = new ArrayList<Object>();
        int curr = 0;
        for (Object object : this.iterable()) {
            if (curr >= lower && curr <= upper) {
                result.add(object);
            }
            ++curr;
        }
        return new SparseSequenceValueImpl(this.getTypeId(), (List<? extends Object>)result);
    }

    @Override
    public @NonNull SequenceValue toSequenceValue() {
        return this;
    }

    @Override
    public void toString(@NonNull StringBuilder s, int lengthLimit) {
        s.append("Sequence");
        super.toString(s, lengthLimit);
    }
}

