/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.ui.quickfix;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xcore.XAttribute;
import org.eclipse.emf.ecore.xcore.XGenericType;
import org.eclipse.emf.ecore.xcore.formatting.XcoreImportOrganizer;
import org.eclipse.emf.ecore.xcore.ui.quickfix.XcoreClasspathUpdater;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.ui.quickfix.XbaseQuickfixProvider;

public class XcoreQuickfixProvider
extends XbaseQuickfixProvider {
    @Inject
    protected Provider<XcoreImportOrganizer> xcoreImportOrganizerProvider;
    @Inject
    private IJavaProjectProvider projectProvider;
    @Inject
    private XcoreClasspathUpdater classpathUpdater;

    protected void createLinkingIssueQuickfixes(Issue issue, IssueResolutionAcceptor issueResolutionAcceptor, IXtextDocument xtextDocument, XtextResource resource, EObject referenceOwner, EReference unresolvedReference) throws Exception {
        this.javaTypeQuickfixes.addQuickfixes(issue, issueResolutionAcceptor, xtextDocument, resource, referenceOwner, unresolvedReference);
    }

    @Fix(value="org.eclipse.emf.ecore.model.19")
    public void convertToReference(final Issue issue, final IssueResolutionAcceptor acceptor) {
        IModificationContext modificationContext = this.getModificationContextFactory().createModificationContext(issue);
        final IXtextDocument xtextDocument = modificationContext.getXtextDocument();
        xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

            public void process(XtextResource xtextResource) throws Exception {
                XGenericType xGenericType;
                EObject cause = xtextResource.getResourceSet().getEObject(issue.getUriToProblem(), false);
                if (cause instanceof XGenericType && (xGenericType = (XGenericType)cause).eContainer() instanceof XAttribute && xGenericType.getType() instanceof GenClass) {
                    ICompositeNode node = NodeModelUtils.getNode((EObject)xGenericType.eContainer());
                    String range = node == null ? xtextDocument.get(issue.getOffset().intValue(), issue.getLength().intValue()) : xtextDocument.get(node.getOffset(), node.getLength());
                    this.quickFix(issue, "Convert to cross reference", "refers ", acceptor, range);
                    this.quickFix(issue, "Convert to containment reference", "contains ", acceptor, range);
                    this.quickFix(issue, "Convert to container reference", "container ", acceptor, range);
                }
            }

            private void quickFix(final Issue issue2, String description, final String replacement, IssueResolutionAcceptor acceptor2, String range) {
                acceptor2.accept(issue2, description, String.valueOf(replacement) + range, "full/obj16/correction_change.gif", new IModification(){

                    public void apply(IModificationContext context) throws BadLocationException {
                        IXtextDocument xtextDocument = context.getXtextDocument();
                        xtextDocument.replace(issue2.getOffset().intValue(), 0, replacement);
                    }
                });
            }
        });
    }

    @Fix(value="org.eclipse.emf.ecore.xcore.validation.colliding_import")
    public void collidingImport(Issue issue, IssueResolutionAcceptor acceptor) {
        this.removeImport(issue, acceptor);
        this.oranizeImports(issue, acceptor);
    }

    @Fix(value="org.eclipse.emf.ecore.xcore.validation.duplicate_import")
    public void duplicateImport(Issue issue, IssueResolutionAcceptor acceptor) {
        this.removeImport(issue, acceptor);
        this.oranizeImports(issue, acceptor);
    }

    @Fix(value="org.eclipse.emf.ecore.xcore.validation.unused_import")
    public void unusedImport(Issue issue, IssueResolutionAcceptor acceptor) {
        this.removeImport(issue, acceptor);
        this.oranizeImports(issue, acceptor);
    }

    public void removeImport(final Issue issue, final IssueResolutionAcceptor acceptor) {
        IModificationContext modificationContext = this.getModificationContextFactory().createModificationContext(issue);
        final IXtextDocument xtextDocument = modificationContext.getXtextDocument();
        xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

            public void process(XtextResource xtextResource) throws Exception {
                EObject cause = xtextResource.getResourceSet().getEObject(issue.getUriToProblem(), false);
                final RemovalRegion removalRegion = new RemovalRegion(xtextDocument, cause);
                acceptor.accept(issue, "Remove import", "...\n" + xtextDocument.get(removalRegion.begin, removalRegion.deleteBegin - removalRegion.begin) + removalRegion.replacement + xtextDocument.get(removalRegion.deleteEnd, removalRegion.end - removalRegion.deleteEnd) + "\n...", "full/obj16/delete_obj.gif", new IModification(){

                    public void apply(IModificationContext context) throws BadLocationException {
                        IXtextDocument xtextDocument = context.getXtextDocument();
                        xtextDocument.replace(removalRegion.deleteBegin, removalRegion.deleteEnd - removalRegion.deleteBegin, removalRegion.replacement);
                    }
                });
            }
        });
    }

    @Fix(value="org.eclipse.emf.ecore.xcore.validation.wildcard_import")
    public void oranizeImports(final Issue issue, final IssueResolutionAcceptor acceptor) {
        IModificationContext modificationContext = this.getModificationContextFactory().createModificationContext(issue);
        IXtextDocument xtextDocument = modificationContext.getXtextDocument();
        xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

            public void process(XtextResource xtextResource) throws Exception {
                XcoreImportOrganizer xcoreImportOrganizer = (XcoreImportOrganizer)XcoreQuickfixProvider.this.xcoreImportOrganizerProvider.get();
                final TextRegion importRegion = xcoreImportOrganizer.getImportRegion(xtextResource);
                final String importSection = xcoreImportOrganizer.getOrganizedImportSection(xtextResource);
                acceptor.accept(issue, "Organize all imports", importSection.trim(), "full/obj16/correction_change.gif", new IModification(){

                    public void apply(IModificationContext context) throws BadLocationException {
                        int length;
                        int offset;
                        IXtextDocument xtextDocument = context.getXtextDocument();
                        String string = xtextDocument.get(offset = importRegion.getOffset(), length = importRegion.getLength());
                        if (!string.equals(importSection)) {
                            xtextDocument.replace(offset, length, importSection);
                        }
                    }
                });
            }
        });
    }

    @Fix(value="org.eclipse.emf.ecore.xcore.validation.xbase_lib_not_on_classpath")
    public void addXbaseLibToClasspath(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add Xbase library to classpath", "Add 'org.eclipse.xtext.xbase.lib' to the project's classpath", "full/obj16/correction_change.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                ResourceSet resourceSet = element.eResource().getResourceSet();
                IJavaProject javaProject = XcoreQuickfixProvider.this.projectProvider.getJavaProject(resourceSet);
                XcoreQuickfixProvider.this.classpathUpdater.addBundle(javaProject, "org.eclipse.xtext.xbase.lib", (IProgressMonitor)new NullProgressMonitor());
            }
        });
    }

    @Fix(value="org.eclipse.emf.ecore.xcore.validation.xcore_lib_not_on_classpath")
    public void addXcoreLibToClasspath(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add Xcore library to classpath", "Add 'org.eclipse.emf.ecore.xcore.lib' to the project's classpath", "full/obj16/correction_change.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                ResourceSet resourceSet = element.eResource().getResourceSet();
                IJavaProject javaProject = XcoreQuickfixProvider.this.projectProvider.getJavaProject(resourceSet);
                XcoreQuickfixProvider.this.classpathUpdater.addBundle(javaProject, "org.eclipse.emf.ecore.xcore.lib", (IProgressMonitor)new NullProgressMonitor());
            }
        });
    }

    public static class RemovalRegion {
        protected IXtextDocument xtextDocument;
        protected int begin;
        protected int end;
        protected int deleteBegin;
        protected int deleteEnd;
        protected String replacement;

        public RemovalRegion(IXtextDocument xtextDocument, EObject eObject) throws BadLocationException {
            this.xtextDocument = xtextDocument;
            ICompositeNode node = NodeModelUtils.getNode((EObject)eObject);
            if (node != null) {
                INode previous = node.getPreviousSibling();
                this.begin = this.getLineBeginOffsetOfOffset(previous == null ? node.getOffset() : previous.getOffset() + previous.getLength());
                INode next = node.getNextSibling();
                this.end = this.getLineEndOffsetOfOffset(next == null ? node.getOffset() + node.getLength() : next.getOffset());
                this.deleteBegin = this.getBeginOffset((INode)node);
                this.deleteEnd = this.getEndOffset((INode)node);
                this.replacement = this.deleteBegin > 0 && !Character.isWhitespace(xtextDocument.getChar(this.deleteBegin - 1)) && this.deleteEnd + 1 < xtextDocument.getLength() && !Character.isWhitespace(xtextDocument.getChar(this.deleteEnd + 1)) ? " " : "";
            }
        }

        public int getBegin() {
            return this.begin;
        }

        public int getEnd() {
            return this.end;
        }

        public int getDeleteBegin() {
            return this.deleteBegin;
        }

        public int getDeleteEnd() {
            return this.deleteEnd;
        }

        public String getReplacement() {
            return this.replacement;
        }

        protected int getLineBeginOffsetOfOffset(int offset) throws BadLocationException {
            return this.xtextDocument.getLineOffset(this.xtextDocument.getLineOfOffset(offset));
        }

        protected int getLineEndOffsetOfOffset(int offset) throws BadLocationException {
            int lineOfOffset = this.xtextDocument.getLineOfOffset(offset);
            return lineOfOffset + 1 < this.xtextDocument.getNumberOfLines() ? this.xtextDocument.getLineOffset(lineOfOffset + 1) : this.xtextDocument.getLength();
        }

        /*
         * Unable to fully structure code
         */
        protected int getBeginOffset(INode node) throws BadLocationException {
            block4: {
                block3: {
                    result = node.getOffset();
                    previous = node.getPreviousSibling();
                    if (previous == null) break block3;
                    nodeLine = this.xtextDocument.getLineOfOffset(result);
                    if (nodeLine != (previousLine = this.xtextDocument.getLineOfOffset(previous.getOffset() + previous.getLength()))) ** GOTO lbl18
                    result = previous.getOffset() + previous.getLength();
                    break block4;
lbl-1000:
                    // 1 sources

                    {
                        isWhite = true;
                        j = this.xtextDocument.getLineOffset(nodeLine);
                        end = j + this.xtextDocument.getLineLength(nodeLine);
                        while (j < end) {
                            if (!Character.isWhitespace(this.xtextDocument.getChar(j))) {
                                isWhite = false;
                                break;
                            }
                            ++j;
                        }
                        if (isWhite) break;
lbl18:
                        // 2 sources

                        ** while (--nodeLine > previousLine)
                    }
lbl19:
                    // 2 sources

                    result = this.xtextDocument.getLineOffset(nodeLine + 1);
                    break block4;
                }
                result = this.getLineBeginOffsetOfOffset(result);
            }
            return result;
        }

        protected int getEndOffset(INode node) throws BadLocationException {
            int nextLine;
            int nodeLine;
            int result = node.getOffset() + node.getLength();
            INode next = node.getNextSibling();
            result = next != null ? ((nodeLine = this.xtextDocument.getLineOfOffset(result)) == (nextLine = this.xtextDocument.getLineOfOffset(next.getOffset() + next.getLength())) ? next.getOffset() : this.getLineEndOffsetOfOffset(result)) : this.getLineEndOffsetOfOffset(result);
            return result;
        }
    }
}

