/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class MementoUtils {
    protected static final String ROOT_ELEMENT_TAGNAME = "root_element";
    protected static final String ELEMENT_TAGNAME = "elem";
    protected static final String ATTRIBUTE_KEY = "key";
    protected static final String ATTRIBUTE_VALUE = "value";

    public static String encodeStringIntoMemento(String str) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(str);
        return MementoUtils.encodeListIntoMemento(list);
    }

    public static String decodeStringFromMemento(String memento) {
        return MementoUtils.decodeListFromMemento(memento).get(0);
    }

    public static String encodeMapIntoMemento(Map<String, String> keyPairValues) {
        String returnValue = null;
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = dfactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement(ROOT_ELEMENT_TAGNAME);
            doc.appendChild(rootElement);
            for (String key : keyPairValues.keySet()) {
                Element elem = doc.createElement(ELEMENT_TAGNAME);
                elem.setAttribute(ATTRIBUTE_KEY, key);
                elem.setAttribute(ATTRIBUTE_VALUE, keyPairValues.get(key));
                rootElement.appendChild(elem);
            }
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult outputTarget = new StreamResult(s);
            transformer.transform(source, outputTarget);
            returnValue = s.toString("UTF8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    public static Map<String, String> decodeMapFromMemento(String memento) {
        HashMap<String, String> keyPairValues = new HashMap<String, String>();
        Element root = null;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            root = parser.parse(new InputSource(new StringReader(memento))).getDocumentElement();
            NodeList nodeList = root.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 1) {
                    Element elem = (Element)node;
                    NamedNodeMap nodeMap = elem.getAttributes();
                    String key = null;
                    String value = null;
                    int idx = 0;
                    while (idx < nodeMap.getLength()) {
                        Node attrNode = nodeMap.item(idx);
                        if (attrNode.getNodeType() == 2) {
                            Attr attr = (Attr)attrNode;
                            if (attr.getName().equals(ATTRIBUTE_KEY)) {
                                key = attr.getValue();
                            } else if (attr.getName().equals(ATTRIBUTE_VALUE)) {
                                value = attr.getValue();
                            }
                        }
                        ++idx;
                    }
                    if (key != null && value != null) {
                        keyPairValues.put(key, value);
                    } else {
                        throw new Exception();
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return keyPairValues;
    }

    public static String encodeListIntoMemento(List<String> labels) {
        String returnValue = null;
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = dfactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement(ROOT_ELEMENT_TAGNAME);
            doc.appendChild(rootElement);
            for (String lbl : labels) {
                Element elem = doc.createElement(ELEMENT_TAGNAME);
                elem.setAttribute(ATTRIBUTE_VALUE, lbl);
                rootElement.appendChild(elem);
            }
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult outputTarget = new StreamResult(s);
            transformer.transform(source, outputTarget);
            returnValue = s.toString("UTF8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    public static List<String> decodeListFromMemento(String memento) {
        ArrayList<String> list = new ArrayList<String>();
        Element root = null;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            root = parser.parse(new InputSource(new StringReader(memento))).getDocumentElement();
            NodeList nodeList = root.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 1) {
                    Element elem = (Element)node;
                    String value = elem.getAttribute(ATTRIBUTE_VALUE);
                    if (value != null) {
                        list.add(value);
                    } else {
                        throw new Exception();
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}

