/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.presentation;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.birt.report.engine.executor.PageVariable;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.PageSection;
import org.eclipse.birt.report.engine.presentation.TableColumnHint;
import org.eclipse.birt.report.engine.presentation.UnresolvedRowHint;

public class PageHint
implements IPageHint {
    protected long pageNumber;
    protected long offset;
    protected String masterPage;
    protected Collection<PageVariable> pageVariables = new ArrayList<PageVariable>();
    ArrayList sections = new ArrayList();
    ArrayList unresolvedRowHints = new ArrayList();
    ArrayList columnInfo = new ArrayList();

    public PageHint() {
        this.pageNumber = 0L;
        this.offset = -1L;
    }

    public PageHint(long pageNumber, long pageOffset) {
        this.pageNumber = pageNumber;
        this.offset = pageOffset;
    }

    public PageHint(long pageNumber, String masterPage) {
        this.pageNumber = pageNumber;
        this.masterPage = masterPage;
    }

    @Override
    public long getPageNumber() {
        return this.pageNumber;
    }

    @Override
    public int getSectionCount() {
        return this.sections.size();
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public long getSectionStart(int i) {
        PageSection section = (PageSection)this.sections.get(i);
        return section.startOffset;
    }

    @Override
    public long getSectionEnd(int i) {
        PageSection section = (PageSection)this.sections.get(i);
        return section.endOffset;
    }

    @Override
    public PageSection getSection(int i) {
        return (PageSection)this.sections.get(i);
    }

    public void addSection(PageSection section) {
        this.sections.add(section);
    }

    @Override
    public void addUnresolvedRowHints(Collection hints) {
        this.unresolvedRowHints.addAll(hints);
    }

    @Override
    public int getUnresolvedRowCount() {
        return this.unresolvedRowHints.size();
    }

    @Override
    public UnresolvedRowHint getUnresolvedRowHint(int index) {
        assert (index >= 0 && index < this.unresolvedRowHints.size());
        return (UnresolvedRowHint)this.unresolvedRowHints.get(index);
    }

    public void addUnresolvedRowHint(UnresolvedRowHint hint) {
        this.unresolvedRowHints.add(hint);
    }

    public void setMasterPage(String masterPage) {
        this.masterPage = masterPage;
    }

    @Override
    public String getMasterPage() {
        return this.masterPage;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public void addTableColumnHint(TableColumnHint hint) {
        this.columnInfo.add(hint);
    }

    @Override
    public TableColumnHint getTableColumnHint(int index) {
        return (TableColumnHint)this.columnInfo.get(index);
    }

    @Override
    public int getTableColumnHintCount() {
        return this.columnInfo.size();
    }

    @Override
    public void addTableColumnHints(Collection hints) {
        this.columnInfo.addAll(hints);
    }

    @Override
    public Collection<PageVariable> getPageVariables() {
        return this.pageVariables;
    }
}

