/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBasePreparedQuery;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.IPreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.data.DataEngineFactory;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.dte.AbstractDataEngine;
import org.eclipse.birt.report.engine.data.dte.CubeResultSet;
import org.eclipse.birt.report.engine.data.dte.DteMetaInfoIOUtil;
import org.eclipse.birt.report.engine.data.dte.QueryResultSet;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.ir.Report;

public class DataPresentationEngine
extends AbstractDataEngine {
    protected HashMap rsetRelations2 = new HashMap();
    private boolean needAccessFactTable = false;
    private StringBuffer keyBuffer = new StringBuffer();

    public DataPresentationEngine(DataEngineFactory factory, ExecutionContext context, IDocArchiveReader reader, boolean needAccessFactTable) throws Exception {
        super(factory, context);
        DataSessionContext dteSessionContext = new DataSessionContext(2, context.getDesign(), context.getScriptContext(), context.getApplicationClassLoader());
        dteSessionContext.setDocumentReader(reader);
        dteSessionContext.setAppContext(context.getAppContext());
        DataEngineContext dteEngineContext = dteSessionContext.getDataEngineContext();
        dteEngineContext.setLocale(context.getLocale());
        dteEngineContext.setTimeZone(context.getTimeZone());
        String tempDir = this.getTempDir(context);
        if (tempDir != null) {
            dteEngineContext.setTmpdir(tempDir);
        }
        this.dteSession = DataRequestSession.newSession((DataSessionContext)dteSessionContext);
        this.loadDteMetaInfo(reader);
        this.needAccessFactTable = needAccessFactTable;
    }

    @Override
    protected void doPrepareQuery(Report report, Map appContext) {
        this.queryIDMap.putAll(report.getQueryIDs());
    }

    private void loadDteMetaInfo(IDocArchiveReader reader) throws IOException {
        ArrayList result = DteMetaInfoIOUtil.loadDteMetaInfo(reader);
        if (result != null) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < result.size()) {
                String[] rsetRelation = (String[])result.get(i);
                String pRsetId = rsetRelation[0];
                String rawId = rsetRelation[1];
                String queryId = rsetRelation[2];
                String rsetId = rsetRelation[3];
                String rowId = rsetRelation[4];
                this.addResultSetRelation(pRsetId, rawId, queryId, rsetId);
                buffer.setLength(0);
                buffer.append(pRsetId);
                buffer.append(".");
                buffer.append(rowId);
                buffer.append(".");
                buffer.append(queryId);
                this.rsetRelations2.put(buffer.toString(), rsetId);
                ++i;
            }
        }
    }

    @Override
    public String getResultIDByRowID(String pRsetId, String rowId, String queryId) {
        this.keyBuffer.setLength(0);
        this.keyBuffer.append(pRsetId);
        this.keyBuffer.append(".");
        this.keyBuffer.append(rowId);
        this.keyBuffer.append(".");
        this.keyBuffer.append(queryId);
        String rsetId = (String)this.rsetRelations2.get(this.keyBuffer.toString());
        return rsetId;
    }

    @Override
    protected IBaseResultSet doExecuteQuery(IBaseResultSet parentResult, IQueryDefinition query, Object queryOwner, boolean useCache) throws BirtException {
        String queryID = (String)this.queryIDMap.get(query);
        String resultSetID = this.loadResultSetID(parentResult, queryID);
        if (resultSetID == null) {
            throw new EngineException("Error.ReportQueryLoadingError");
        }
        ((QueryDefinition)query).setQueryResultsID(resultSetID);
        IPreparedQuery pq = this.dteSession.prepare(query);
        IBaseQueryResults queryResults = this.dteSession.execute((IBasePreparedQuery)pq, parentResult == null ? null : parentResult.getQueryResults(), this.context.getScriptContext());
        QueryResultSet resultSet = null;
        resultSet = parentResult == null ? new QueryResultSet(this, this.context, query, (IQueryResults)queryResults) : new QueryResultSet(this, this.context, parentResult, query, (IQueryResults)queryResults);
        return resultSet;
    }

    @Override
    protected IBaseResultSet doExecuteCube(IBaseResultSet parentResult, ICubeQueryDefinition query, Object queryOwner, boolean useCache) throws BirtException {
        String queryID = (String)this.queryIDMap.get(query);
        String resultSetID = this.loadResultSetID(parentResult, queryID);
        IBaseQueryResults queryResults = null;
        query.setQueryResultsID(resultSetID);
        IPreparedCubeQuery pQuery = this.dteSession.prepare(query, this.context.getAppContext());
        query.setNeedAccessFactTable(this.needAccessFactTable);
        ScriptContext scriptContext = this.context.getScriptContext();
        queryResults = parentResult != null ? this.dteSession.execute((IBasePreparedQuery)pQuery, parentResult.getQueryResults(), scriptContext) : this.dteSession.execute((IBasePreparedQuery)pQuery, null, scriptContext);
        CubeResultSet resultSet = null;
        resultSet = parentResult == null ? new CubeResultSet(this, this.context, query, (ICubeQueryResults)queryResults) : new CubeResultSet((IDataEngine)this, this.context, parentResult, query, (ICubeQueryResults)queryResults);
        return resultSet;
    }

    private String loadResultSetID(IBaseResultSet parentResult, String queryID) throws BirtException {
        String resultSetID = null;
        if (parentResult == null) {
            if (this.context.isExecutingMasterPage()) {
                long pageNumber;
                resultSetID = this.getResultID(null, "-1", queryID);
                if (resultSetID == null && (resultSetID = this.getResultID(null, String.valueOf(pageNumber = this.context.getPageNumber()), queryID)) == null) {
                    resultSetID = this.getResultID(null, "1", queryID);
                }
            } else {
                resultSetID = this.getResultID(null, "-1", queryID);
            }
        } else {
            String pRsetId = parentResult instanceof QueryResultSet ? ((QueryResultSet)parentResult).getQueryResultsID() : ((CubeResultSet)parentResult).getQueryResultsID();
            String rowid = parentResult.getRawID();
            resultSetID = this.getResultID(pRsetId, rowid, queryID);
        }
        return resultSetID;
    }
}

