/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import org.eclipse.birt.report.designer.internal.ui.dialogs.ReportPrintGraphicalViewerOperation;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.DeferredGraphicalViewer;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.GraphicalPartFactory;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportRootEditPart;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ReportGraphicsViewPainter {
    private Object model;
    private GraphicalViewer viewer;
    private Shell hostShell;

    public ReportGraphicsViewPainter(Object model) {
        this.model = model;
        this.configGraphicalViewer();
    }

    public void paint(Drawable drawable, Device device, Rectangle region) {
        ReportPrintGraphicalViewerOperation op = new ReportPrintGraphicalViewerOperation(this.viewer, drawable, device, new org.eclipse.draw2d.geometry.Rectangle(region));
        if (this.model instanceof ReportDesignHandle) {
            op.setOrientation(((ReportDesignHandle)this.model).getBidiOrientation());
        }
        op.run("paint");
    }

    public void dispose() {
        if (this.hostShell != null && !this.hostShell.isDisposed()) {
            this.hostShell.dispose();
            this.hostShell = null;
        }
    }

    protected void configGraphicalViewer() {
        String orientation;
        this.viewer = new DeferredGraphicalViewer(){

            @Override
            protected void fireSelectionChanged() {
            }
        };
        DeferredGraphicalViewer reportViewer = (DeferredGraphicalViewer)this.viewer;
        this.hostShell = this.model instanceof ReportDesignHandle ? ("rtl".equals(orientation = ((ReportDesignHandle)this.model).getBidiOrientation()) ? new Shell(0x4000000) : new Shell(0x2000000)) : new Shell();
        reportViewer.createControl((Composite)this.hostShell);
        reportViewer.setEditDomain((EditDomain)new DefaultEditDomain(null));
        reportViewer.setRootEditPart((RootEditPart)new ReportRootEditPart());
        reportViewer.setEditPartFactory(new GraphicalPartFactory());
        reportViewer.setContents(this.model);
        reportViewer.flush();
    }
}

