/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.TextAreaElement;
import com.google.gwt.i18n.client.BidiUtils;
import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextBoxBase;

public class TextArea
extends TextBoxBase
implements HasDirection {
    public static TextArea wrap(Element element) {
        assert (Document.get().getBody().isOrHasChild(element));
        TextArea textArea = new TextArea(element);
        textArea.onAttach();
        RootPanel.detachOnWindowClose(textArea);
        return textArea;
    }

    public TextArea() {
        super(Document.get().createTextAreaElement());
        this.setStyleName("gwt-TextArea");
    }

    protected TextArea(Element element) {
        super((Element)element.cast());
        TextAreaElement.as(element);
    }

    public int getCharacterWidth() {
        return this.getTextAreaElement().getCols();
    }

    public int getCursorPos() {
        return this.getImpl().getTextAreaCursorPos(this.getElement());
    }

    public HasDirection.Direction getDirection() {
        return BidiUtils.getDirectionOnElement(this.getElement());
    }

    public int getSelectionLength() {
        return this.getImpl().getTextAreaSelectionLength(this.getElement());
    }

    public int getVisibleLines() {
        return this.getTextAreaElement().getRows();
    }

    public void setCharacterWidth(int width) {
        this.getTextAreaElement().setCols(width);
    }

    public void setDirection(HasDirection.Direction direction) {
        BidiUtils.setDirectionOnElement(this.getElement(), direction);
    }

    public void setVisibleLines(int lines) {
        this.getTextAreaElement().setRows(lines);
    }

    private TextAreaElement getTextAreaElement() {
        return (TextAreaElement)this.getElement().cast();
    }
}

