/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot.extension;

import java.util.EnumSet;
import org.eclipse.mat.inspections.collectionextract.ICollectionExtractor;
import org.eclipse.mat.snapshot.extension.JdkVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionExtractionInfo {
    public final String className;
    public final EnumSet<JdkVersion> version;
    public final ICollectionExtractor extractor;

    public CollectionExtractionInfo(String className, ICollectionExtractor extractor) {
        this(className, JdkVersion.ALL, extractor);
    }

    public CollectionExtractionInfo(String className, JdkVersion version, ICollectionExtractor extractor) {
        this(className, JdkVersion.of(version, new JdkVersion[0]), extractor);
    }

    public CollectionExtractionInfo(String className, EnumSet<JdkVersion> version, ICollectionExtractor extractor) {
        if (className == null) {
            throw new IllegalArgumentException();
        }
        if (version == null) {
            throw new IllegalArgumentException();
        }
        if (extractor == null) {
            throw new IllegalArgumentException();
        }
        this.className = className;
        this.version = version;
        this.extractor = extractor;
    }

    public String toString() {
        return "CollectionExtractionInfo for " + this.className + " on versions:" + this.version.toString();
    }
}

