/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.server;

import com.google.common.base.Charsets;
import com.google.common.hash.Hasher;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epp.logging.aeri.core.IBundle;
import org.eclipse.epp.logging.aeri.core.IReport;
import org.eclipse.epp.logging.aeri.core.IStackTraceElement;
import org.eclipse.epp.logging.aeri.core.IStatus;
import org.eclipse.epp.logging.aeri.core.IThrowable;
import org.eclipse.epp.logging.aeri.core.util.ModelSwitch;
import org.eclipse.epp.logging.aeri.core.util.Reports;

public class ReportFingerprints {
    public static String exactIdentityHash(IReport report) {
        final Hasher hasher = Reports.newHasher();
        ModelSwitch<Hasher> s = new ModelSwitch<Hasher>(){

            public Hasher caseReport(IReport object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getEclipseProduct()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getEclipseBuildId()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getJavaRuntimeVersion()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getOsgiOs()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getOsgiOsVersion()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getOsgiArch()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getOsgiWs()), Charsets.UTF_8);
                return null;
            }

            public Hasher caseStatus(IStatus object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getPluginId()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getPluginVersion()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getMessage()), Charsets.UTF_8);
                hasher.putInt(object.getSeverity());
                hasher.putInt(object.getCode());
                return null;
            }

            public Hasher caseBundle(IBundle object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getName()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getVersion()), Charsets.UTF_8);
                return null;
            }

            public Hasher caseStackTraceElement(IStackTraceElement object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getClassName()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getMethodName()), Charsets.UTF_8);
                hasher.putInt(object.getLineNumber());
                return null;
            }

            public Hasher caseThrowable(IThrowable object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getClassName()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getMessage()), Charsets.UTF_8);
                return null;
            }
        };
        Reports.visit((EObject)report, (ModelSwitch)s);
        String hash = hasher.hash().toString();
        return hash;
    }

    public static String traceIdentityHash(IReport report) {
        final Hasher hasher = Reports.newHasher();
        Reports.visit((EObject)report, (ModelSwitch)new ModelSwitch<Hasher>(){

            public Hasher caseStackTraceElement(IStackTraceElement element) {
                hasher.putString((CharSequence)element.getClassName(), Charsets.UTF_8);
                hasher.putString((CharSequence)element.getMethodName(), Charsets.UTF_8);
                hasher.putInt(element.getLineNumber());
                return null;
            }
        });
        String hash = hasher.hash().toString();
        return hash;
    }
}

