/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.formatter;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.SourceElementRequestorAdaptor;
import org.eclipse.dltk.formatter.AbstractScriptFormatter;
import org.eclipse.dltk.formatter.FormatterContext;
import org.eclipse.dltk.formatter.FormatterDocument;
import org.eclipse.dltk.formatter.IFormatterContext;
import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.formatter.internal.DumpContentException;
import org.eclipse.dltk.tcl.formatter.internal.FormatterIndentDetector;
import org.eclipse.dltk.tcl.formatter.internal.FormatterWorker;
import org.eclipse.dltk.tcl.formatter.internal.Messages;
import org.eclipse.dltk.tcl.formatter.internal.TclFormatterPlugin;
import org.eclipse.dltk.tcl.formatter.internal.TclFormatterWriter;
import org.eclipse.dltk.tcl.formatter.internal.UnexpectedFormatterException;
import org.eclipse.dltk.tcl.internal.structure.TclSourceElementParser2;
import org.eclipse.dltk.ui.formatter.FormatterException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class TclFormatter
extends AbstractScriptFormatter {
    protected static final String[] INDENTING = new String[]{"indent.script", "indent.after.backslash"};
    protected static final String[] BLANK_LINES = new String[]{"line.file.require.after", "line.file.proc.between"};
    private final String lineDelimiter;

    public TclFormatter(String lineDelimiter, Map<String, ? extends Object> preferences) {
        super(preferences);
        this.lineDelimiter = lineDelimiter;
    }

    public int detectIndentationLevel(IDocument document, int offset) {
        if (offset == 0) {
            return 0;
        }
        String input = document.get();
        List<TclCommand> commands = this.parse(input);
        FormatterIndentDetector detector = new FormatterIndentDetector(offset);
        return detector.getLevel(commands);
    }

    public TextEdit format(String source, int offset, int length, int indent) throws FormatterException {
        List<TclCommand> commands;
        String input = source.substring(offset, offset + length);
        String output = this.format(input, commands = this.parse(input), indent);
        if (output != null) {
            if (!input.equals(output)) {
                if (!this.isValidation() || this.equalsIgnoreBlanks(new StringReader(input), new StringReader(output))) {
                    return new ReplaceEdit(offset, length, output);
                }
                TclFormatterPlugin.log((IStatus)new Status(4, "org.eclipse.dltk.tcl.formatter", 0, Messages.TclFormatter_contentCorrupted, (Throwable)new DumpContentException(input)));
            } else {
                return new MultiTextEdit();
            }
        }
        return null;
    }

    protected List<TclCommand> parse(String input) {
        TclSourceElementParser2 parser = new TclSourceElementParser2();
        parser.setRequestor((ISourceElementRequestor)new SourceElementRequestorAdaptor());
        return parser.parse(input, 0);
    }

    private String format(String input, List<TclCommand> commands, int indent) throws FormatterException {
        FormatterDocument document = this.createDocument(input);
        TclFormatterWriter writer = new TclFormatterWriter((IFormatterDocument)document, this.lineDelimiter, this.createIndentGenerator());
        writer.setWrapLength(this.getInt("wrap.comments.length"));
        writer.setLinesPreserve(this.getInt("lines.preserve"));
        try {
            FormatterContext context = new FormatterContext(indent);
            FormatterWorker worker = new FormatterWorker(writer, (IFormatterDocument)document, (IFormatterContext)context);
            worker.format(commands);
            writer.flush((IFormatterContext)context);
            return writer.getOutput();
        }
        catch (UnexpectedFormatterException e) {
            throw new FormatterException((Throwable)e);
        }
    }

    private FormatterDocument createDocument(String input) {
        FormatterDocument document = new FormatterDocument(input);
        int i = 0;
        while (i < INDENTING.length) {
            document.setBoolean(INDENTING[i], this.getBoolean(INDENTING[i]));
            ++i;
        }
        i = 0;
        while (i < BLANK_LINES.length) {
            document.setInt(BLANK_LINES[i], this.getInt(BLANK_LINES[i]));
            ++i;
        }
        document.setInt("formatter.tabulation.size", this.getInt("formatter.tabulation.size"));
        document.setBoolean("wrap.comments", this.getBoolean("wrap.comments"));
        return document;
    }

    protected boolean isValidation() {
        return !this.getBoolean("wrap.comments");
    }

    private boolean equalsIgnoreBlanks(Reader inputReader, Reader outputReader) {
        String outputLine;
        String inputLine;
        LineNumberReader input = new LineNumberReader(inputReader);
        LineNumberReader output = new LineNumberReader(outputReader);
        do {
            inputLine = this.readLine(input);
            outputLine = this.readLine(output);
            if (inputLine == null) {
                return outputLine == null;
            }
            if (outputLine != null) continue;
            return false;
        } while (inputLine.equals(outputLine));
        return false;
    }

    private String readLine(LineNumberReader reader) {
        String line;
        do {
            try {
                line = reader.readLine();
            }
            catch (IOException e) {
                return null;
            }
            if (line != null) continue;
            return line;
        } while ((line = line.trim()).length() == 0);
        return line;
    }
}

