/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.factory.map.primitive.MutableCharFloatMapFactory;
import org.eclipse.collections.api.map.primitive.CharFloatMap;
import org.eclipse.collections.api.map.primitive.MutableCharFloatMap;
import org.eclipse.collections.impl.factory.primitive.CharFloatMaps;
import org.eclipse.collections.impl.map.mutable.primitive.CharFloatHashMap;
import org.eclipse.collections.impl.utility.Iterate;

public enum MutableCharFloatMapFactoryImpl implements MutableCharFloatMapFactory
{
    INSTANCE;


    public MutableCharFloatMap empty() {
        return new CharFloatHashMap(0);
    }

    public MutableCharFloatMap of() {
        return this.empty();
    }

    public MutableCharFloatMap with() {
        return this.empty();
    }

    public MutableCharFloatMap ofInitialCapacity(int capacity) {
        return this.withInitialCapacity(capacity);
    }

    public MutableCharFloatMap withInitialCapacity(int capacity) {
        return new CharFloatHashMap(capacity);
    }

    public MutableCharFloatMap ofAll(CharFloatMap map) {
        return this.withAll(map);
    }

    public MutableCharFloatMap withAll(CharFloatMap map) {
        if (map.isEmpty()) {
            return this.empty();
        }
        return new CharFloatHashMap(map);
    }

    public <T> MutableCharFloatMap from(Iterable<T> iterable, CharFunction<? super T> keyFunction, FloatFunction<? super T> valueFunction) {
        MutableCharFloatMap map = CharFloatMaps.mutable.empty();
        Iterate.forEach(iterable, (Procedure & Serializable)each -> map.put(keyFunction.charValueOf(each), valueFunction.floatValueOf(each)));
        return map;
    }
}

